/***************************************************************************
                               application.h
                             -------------------
    begin                : Mon Jan 28 2002
    copyright            : (C) 2002 by Benjamin Meyer
    email                : ben-dev@meyerhome.net
 ***************************************************************************/

#include "application.h"
#include "login.h"
#include <qtextstream.h>
#include <kprocess.h>
#include <qregexp.h>

QString KinkattaApplication::soundCommand = "artsplay";
bool KinkattaApplication::muteAudio = false;
Login* KinkattaApplication::loginWindow = NULL;

/**
 * Creates the login window.  
 * Pass command line parameters to KApplication
 */
KinkattaApplication::KinkattaApplication(int a, char ** b) : KApplication(a, b){
  loginWindow = new Login(0, "Login Window");
  loginWindow->hide();
}

/*/
 * Delete the login window.
 */
KinkattaApplication::~KinkattaApplication(){
  delete loginWindow;
}

/**
 * Updates the settings to the loginWindow.
 */
void KinkattaApplication::showLoginWindow(){
  loginWindow->updateSettings();
  loginWindow->show();
}

/**
 * Function to set up the command to use when opening sound files.
 * @param command the new command to use when opening sound files.
 */
void KinkattaApplication::setSoundCommand(const QString &command) {
  soundCommand = command;
}

/**
 * Suppresses sound output.  If mute is true sound will not be
 * played via beep or playFile.
 * @param bool specify whether to mute or not
 */
void KinkattaApplication::muteSound(bool muteMe){
  muteAudio = muteMe;
}

/**
 * Make an audio (speaker type) beep.
 * Does nothing if audio is currently muted.
 */
void KinkattaApplication::beep(){
  if (muteAudio)
    return;
  QApplication::beep(); 
}

/**
 * Plays a sound file using the specified command in another process.
 * Does nothing if audio is currently muted.
 * @param file the full path to the file to play
 */
void KinkattaApplication::playFile( const QString &file ){
  QString fileToPlay = file;
  if (muteAudio)
    return;

  if (fileToPlay.mid(0,1) == "-"){
    printf( "Possible security hack, not parsing: %s.\n" , fileToPlay.latin1());
    return;	
  }
  // Make sure we are only passing in one thing.
  int space = fileToPlay.find(" ", 0, true);
  // If spaces are found, escape them...
  if (space != -1)
    fileToPlay = fileToPlay.replace(QRegExp(" "), ("\\ ") );
  KProcess *proc = new KProcess();
  *proc << soundCommand.latin1();
  *proc << fileToPlay.latin1();
  proc->start( KProcess::DontCare );
}

// application.cpp

