/******************************************************************************
                                chatwindow.h
                             -------------------
    begin                : Wednesday March 28 2000
    copyright            : (C) 2001 by Benjamin Meyer
    email                : ben-dev@meyerhome.net
 ******************************************************************************/

#ifndef CHATWINDOW_H
#define CHATWINDOW_H

#include "chat.h"

/**
 * This is the implementation of a chat "im" window.  It is based off of the
 * chat class.
 * @author Benjamin Meyer
 */
class ChatWindow : public Chat {

Q_OBJECT

signals:
  /// Emitted when the a buddy is to be removed
  void removeContact( QString contactName );

  /// Emitted when the a buddy is to be added
  void addContact( QString contactName );

  /// Emitted when a buddy is to be blocked
  void blockBuddy( QString contactName );

  /// Emitted to warn a buddy
  void warningOut( QString contactName );

  /// Emitted to pounce on a buddy
  void pounce( QString contactName );

  /// Emitted when info is wanted on a buddy
  void getInfo( QString contactName );

public:
  /// Constructor
  ChatWindow(QString userName = "", QString buddysName = "", bool buddy = false,
             QWidget *parent=0, QString alias=0);

public slots:
  /// Sets if the buddy is on the buddy list of not.
  void setIfIsBuddy( QString contactName, bool isABuddy );

  /// Updates the user's buddy name    
  void updateBuddyName( QString buddyName );

private slots:
  /// Configure the toolbars.
  void options_configuretoolbars();

  /// Block this buddy from appearing on the buddy list
  void slotBuddyBlock();

  /// Send a warning message to the buddy
  void slotBuddyWarn();

  /// Add or remove the buddy from the buddy list
  void slotBuddyAddRemove();

  /// Get information about the current buddy.
  void slotBuddyInfo();

  /// Chat window setup.
  void initChatWindow();

  /// Save the size of the window.
  void saveSize();

  /// Emits a pounce
  void slotBuddyPounce();

private:
  KAction *addRemove;

  /// The user's buddy state
  bool isBuddy;

};

#endif

// chatwindow.h

