/* $Id: we_statusbar.c 1014 2009-02-01 12:46:52Z ekalin $ */

/*
 * Copyright (C) 2004-2009 Eduardo M Kalinowski <eduardo@kalinowski.com.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <kcconfig.h>
#endif

#include <libintl.h>
#include <gtk/gtk.h>
#include <glade/glade.h>

#include "kildclient.h"
#include "perlscript.h"


/***********************
 * Function prototypes *
 ***********************/
static void       statusfont_set_cb(GtkFontButton *font_btn,
                                    gpointer data);
static void       time_type_changed_cb(GtkWidget *widget, gpointer data);
static void       reset_activate_toggled_cb(GtkWidget *widget,
                                            gpointer data);


/*************************
 * File global variables *
 *************************/



GtkWidget *
get_we_statusbar_tab(GladeXML *gladexml)
{
  GtkWidget *panel;

  panel = glade_xml_get_widget(gladexml, "we_panel_statusbar");

  return panel;
}


void
fill_we_statusbar_tab(World *world, GladeXML *gladexml)
{
  GtkWidget *statusfont_btn;
  GtkWidget *radCTime_no;
  GtkWidget *radCTime_hms;
  GtkWidget *radCTime_sec;
  GtkWidget *radITime_no;
  GtkWidget *radITime_hms;
  GtkWidget *radITime_sec;
  GtkWidget *chkResetActivate;

  statusfont_btn = glade_xml_get_widget(gladexml, "statusfont_btn");
  gtk_font_button_set_font_name(GTK_FONT_BUTTON(statusfont_btn),
                                world->statusfont);
  g_signal_connect(G_OBJECT(statusfont_btn), "font-set",
                   G_CALLBACK(statusfont_set_cb), world);

  radCTime_no  = glade_xml_get_widget(gladexml, "radCTime_no");
  radCTime_hms = glade_xml_get_widget(gladexml, "radCTime_hms");
  radCTime_sec = glade_xml_get_widget(gladexml, "radCTime_sec");
  if (world->ctime_type == NO) {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radCTime_no), TRUE);
  } else if (world->ctime_type == HMS) {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radCTime_hms), TRUE);
  } else {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radCTime_sec), TRUE);
  }

  radITime_no  = glade_xml_get_widget(gladexml, "radITime_no");
  radITime_hms = glade_xml_get_widget(gladexml, "radITime_hms");
  radITime_sec = glade_xml_get_widget(gladexml, "radITime_sec");
  if (world->itime_type == NO) {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radITime_no), TRUE);
  } else if (world->itime_type == HMS) {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radITime_hms), TRUE);
  } else {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radITime_sec), TRUE);
  }

  g_signal_connect(G_OBJECT(radITime_no), "toggled",
                   G_CALLBACK(time_type_changed_cb), world);
  g_signal_connect(G_OBJECT(radITime_hms), "toggled",
                   G_CALLBACK(time_type_changed_cb), world);
  g_signal_connect(G_OBJECT(radITime_sec), "toggled",
                   G_CALLBACK(time_type_changed_cb), world);
  g_signal_connect(G_OBJECT(radCTime_no), "toggled",
                   G_CALLBACK(time_type_changed_cb), world);
  g_signal_connect(G_OBJECT(radCTime_hms), "toggled",
                   G_CALLBACK(time_type_changed_cb), world);
  g_signal_connect(G_OBJECT(radCTime_sec), "toggled",
                   G_CALLBACK(time_type_changed_cb), world);

  chkResetActivate = glade_xml_get_widget(gladexml, "chkResetActivate");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chkResetActivate),
                               world->itime_reset_activate);
  g_signal_connect(G_OBJECT(chkResetActivate), "toggled",
                   G_CALLBACK(reset_activate_toggled_cb), world);
}


static
void
statusfont_set_cb(GtkFontButton *font_btn, gpointer data)
{
  PangoFontDescription *fontDesc;
  World                *world  = (World *) data;
  WorldGUI             *gui    = world->gui;

  free(world->statusfont);
  world->statusfont = g_strdup(gtk_font_button_get_font_name(font_btn));

  if (gui) {
    GtkWidget *widget = GTK_WIDGET(world->gui->lblStatus);

    fontDesc = pango_font_description_from_string(world->statusfont);
    gtk_widget_modify_font(widget, fontDesc);
    pango_font_description_free(fontDesc);
  }
}


static
void
time_type_changed_cb(GtkWidget *widget, gpointer data)
{
  World    *world = (World *) data;
  GladeXML *gladexml;
  GtkWidget *radCTime_no;
  GtkWidget *radCTime_hms;
  GtkWidget *radCTime_sec;
  GtkWidget *radITime_no;
  GtkWidget *radITime_hms;
  GtkWidget *radITime_sec;

  gladexml = glade_get_widget_tree(widget);
  radCTime_no  = glade_xml_get_widget(gladexml, "radCTime_no");
  radCTime_hms = glade_xml_get_widget(gladexml, "radCTime_hms");
  radCTime_sec = glade_xml_get_widget(gladexml, "radCTime_sec");
  radITime_no  = glade_xml_get_widget(gladexml, "radITime_no");
  radITime_hms = glade_xml_get_widget(gladexml, "radITime_hms");
  radITime_sec = glade_xml_get_widget(gladexml, "radITime_sec");

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radCTime_no))) {
    world->ctime_type = NO;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radCTime_hms))) {
    world->ctime_type = HMS;
  } else {
    world->ctime_type = SEC;
  }

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radITime_no))) {
    world->itime_type = NO;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radITime_hms))) {
    world->itime_type = HMS;
  } else {
    world->itime_type = SEC;
  }
}


static
void
reset_activate_toggled_cb(GtkWidget *widget, gpointer data)
{
  World *world = (World *) data;

  world->itime_reset_activate =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
}
