/* $Id: we_mainwindow.c 1014 2009-02-01 12:46:52Z ekalin $ */

/*
 * Copyright (C) 2004-2009 Eduardo M Kalinowski <eduardo@kalinowski.com.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <kcconfig.h>
#endif

#include <libintl.h>
#include <gtk/gtk.h>
#include <glade/glade.h>

#include "kildclient.h"
#include "ansi.h"
#include "perlscript.h"


/***********************
 * Function prototypes *
 ***********************/
static void terminalfont_set_cb(GtkFontButton *font_btn,
                                gpointer data);
static void use_bold_changed_cb(GtkToggleButton *chkbox,
                                gpointer data);
static void wrap_changed_cb(GtkToggleButton *widget,
                            gpointer         data);


/*************************
 * File global variables *
 *************************/



GtkWidget *
get_we_mainwindow_tab(GladeXML *gladexml)
{
  GtkWidget *panel;

  panel = glade_xml_get_widget(gladexml, "we_panel_mainwindow");

  return panel;
}


void
fill_we_mainwindow_tab(World *world, GladeXML *gladexml)
{
  GtkWidget *terminalfont_btn;
  GtkWidget *chkUseBold;
  GtkWidget *chkUseWrap;

  terminalfont_btn = glade_xml_get_widget(gladexml, "terminalfont_btn");
  chkUseBold       = glade_xml_get_widget(gladexml, "chkUseBold");
  chkUseWrap       = glade_xml_get_widget(gladexml, "chkUseWrap");

  gtk_font_button_set_font_name(GTK_FONT_BUTTON(terminalfont_btn),
                                world->terminalfont);
  g_signal_connect(G_OBJECT(terminalfont_btn), "font-set",
                   G_CALLBACK(terminalfont_set_cb), world);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chkUseBold),
                               world->usebold);
  g_signal_connect(G_OBJECT(chkUseBold), "toggled",
                   G_CALLBACK(use_bold_changed_cb), world);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chkUseWrap),
                               world->wrap);
  g_signal_connect(G_OBJECT(chkUseWrap), "toggled",
                   G_CALLBACK(wrap_changed_cb), world);
}


static
void
terminalfont_set_cb(GtkFontButton *font_btn, gpointer data)
{
  PangoFontDescription *fontDesc;
  World                *world = (World *) data;
  WorldGUI             *gui   = world->gui;

  free(world->terminalfont);
  world->terminalfont = g_strdup(gtk_font_button_get_font_name(font_btn));

  if (gui) {
    GtkWidget *widget = GTK_WIDGET(world->gui->txtView);

    fontDesc = pango_font_description_from_string(world->terminalfont);
    gtk_widget_modify_font(widget, fontDesc);
    pango_font_description_free(fontDesc);

    /* If the font has changed, we don't know what the new font supports. */
    gui->ta.sup_geom_shapes   = -1;
    gui->ta.sup_block         = -1;
    gui->ta.sup_control       = -1;
    gui->ta.sup_l1_supplement = -1;
    gui->ta.sup_box_drawing   = -1;
    gui->ta.sup_misc_tech     = -1;
    gui->ta.sup_math          = -1;
    gui->ta.sup_greek         = -1;
  }
}


static
void
use_bold_changed_cb(GtkToggleButton *chkbox,
                    gpointer data)
{
  World    *world = (World *) data;
  WorldGUI *gui   = world->gui;

  world->usebold = gtk_toggle_button_get_active(chkbox);
  if (gui) {
    ansitextview_update_color_tags(gui, gui->world);
  }
}


static
void
wrap_changed_cb(GtkToggleButton *button,
                gpointer         data)
{
  World    *world = (World *) data;
  WorldGUI *gui   = world->gui;

  world->wrap = gtk_toggle_button_get_active(button);
  if (gui) {
    gtk_text_view_set_wrap_mode(gui->txtView,
                                world->wrap
                                  ? GTK_WRAP_WORD_CHAR
                                  : GTK_WRAP_CHAR);
  }
}
