/////////////////////////////////////////////////////////////////////////////
// Name:        setpage.cpp
// Purpose:     
// Author:      jean-pierre Charras
// Modified by: 
// Created:     06/02/2006 20:53:09
// RCS-ID:      
// Copyright:   License GNU
// Licence:     
/////////////////////////////////////////////////////////////////////////////

// Generated by DialogBlocks (unregistered), 06/02/2006 20:53:09

#if defined(__GNUG__) && !defined(NO_GCC_PRAGMA)
#pragma implementation "setpage.h"
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes
#include "fctsys.h"
#include "gr_basic.h"

#include "common.h"

#ifdef GERBVIEW
#define NB_ITEMS 12
Ki_PageDescr * SheetList[NB_ITEMS+1] =
{
	&g_Sheet_A4, &g_Sheet_A3, &g_Sheet_A2, &g_Sheet_A1, &g_Sheet_A0,
	&g_Sheet_A, &g_Sheet_B, &g_Sheet_C, &g_Sheet_D, &g_Sheet_E, &g_Sheet_GERBER,
	&g_Sheet_user, NULL
};
#else
#define NB_ITEMS 11
Ki_PageDescr * SheetList[NB_ITEMS+1] =
{
	&g_Sheet_A4, &g_Sheet_A3, &g_Sheet_A2, &g_Sheet_A1, &g_Sheet_A0,
	&g_Sheet_A, &g_Sheet_B, &g_Sheet_C, &g_Sheet_D, &g_Sheet_E,
	&g_Sheet_user, NULL
};
#endif

#include "setpage.h"

////@begin XPM images
////@end XPM images

/******************************************************************/
void WinEDA_DrawFrame::Process_PageSettings(wxCommandEvent& event)
/******************************************************************/
/* Creation de la fenetre de configuration
*/
{
	WinEDA_SetPageFrame frame(this);
	frame.ShowModal();
	ReDrawPanel();
}

/*!
 * WinEDA_SetPageFrame type definition
 */

IMPLEMENT_DYNAMIC_CLASS( WinEDA_SetPageFrame, wxDialog )

/*!
 * WinEDA_SetPageFrame event table definition
 */

BEGIN_EVENT_TABLE( WinEDA_SetPageFrame, wxDialog )

////@begin WinEDA_SetPageFrame event table entries
    EVT_CLOSE( WinEDA_SetPageFrame::OnCloseWindow )

    EVT_BUTTON( wxID_OK, WinEDA_SetPageFrame::OnOkClick )

    EVT_BUTTON( wxID_CANCEL, WinEDA_SetPageFrame::OnCancelClick )

////@end WinEDA_SetPageFrame event table entries

END_EVENT_TABLE()

/*!
 * WinEDA_SetPageFrame constructors
 */

WinEDA_SetPageFrame::WinEDA_SetPageFrame( )
{
}

WinEDA_SetPageFrame::WinEDA_SetPageFrame( WinEDA_DrawFrame* parent, wxWindowID id,
				const wxString& caption, const wxPoint& pos,
				const wxSize& size, long style )
{
wxString msg;
	
	m_ParentDrawFrame = parent;
	m_Screen = m_ParentDrawFrame->m_CurrentScreen;
	m_Modified = FALSE;
	m_SelectedSheet = NULL;
    m_CurrentSelection = 0;
	CreateListSizes();
    Create(parent, id, caption, pos, size, style);
	// Init display value for sheet User size
	wxString format = m_TextSheetCount->GetLabel();
	msg.Printf(format, m_Screen->m_NumberOfSheet);
	m_TextSheetCount->SetLabel(msg);
	format = m_TextSheetNumber->GetLabel();
	msg.Printf(format, m_Screen->m_SheetNumber);
	m_TextSheetNumber->SetLabel(msg);
	if ( g_UnitMetric )
	{
		UserSizeX = (double)g_Sheet_user.m_Size.x * 25.4 / 1000 ;
		UserSizeY = (double)g_Sheet_user.m_Size.y * 25.4 / 1000;
		msg.Printf( wxT("%.2f"), UserSizeX);
		m_TextUserSizeX->SetValue(msg);
		msg.Printf( wxT("%.2f"), UserSizeY);
		m_TextUserSizeY->SetValue(msg);
	}
	else
	{
		UserSizeX = (double)g_Sheet_user.m_Size.x / 1000;
		UserSizeY = (double)g_Sheet_user.m_Size.y / 1000;
		msg.Printf( wxT("%.3f"), UserSizeX );
		m_TextUserSizeX->SetValue(msg);
		msg.Printf( wxT("%.3f"), UserSizeY );
		m_TextUserSizeY->SetValue(msg);
	}
}

/*!
 * WinEDA_SetPageFrame creator
 */

bool WinEDA_SetPageFrame::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin WinEDA_SetPageFrame member initialisation
    m_PageSizeBox = NULL;
    m_TextUserSizeX = NULL;
    m_TextUserSizeY = NULL;
    m_TextSheetCount = NULL;
    m_TextSheetNumber = NULL;
    m_TextRevision = NULL;
    m_TextCompany = NULL;
    m_TextTitle = NULL;
    m_TextComment1 = NULL;
    m_TextComment2 = NULL;
    m_TextComment3 = NULL;
    m_TextComment4 = NULL;
////@end WinEDA_SetPageFrame member initialisation

////@begin WinEDA_SetPageFrame creation
    wxDialog::Create( parent, id, caption, pos, size, style );

    CreateControls();
    GetSizer()->Fit(this);
    GetSizer()->SetSizeHints(this);
    Centre();
////@end WinEDA_SetPageFrame creation
    return true;
}

/*!
 * Control creation for WinEDA_SetPageFrame
 */

void WinEDA_SetPageFrame::CreateControls()
{    
	SetFont(*g_DialogFont);
	
////@begin WinEDA_SetPageFrame content construction
    // Generated by DialogBlocks, 08/02/2006 09:27:07 (unregistered)

    WinEDA_SetPageFrame* itemDialog1 = this;

    wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxHORIZONTAL);
    itemDialog1->SetSizer(itemBoxSizer2);

    wxBoxSizer* itemBoxSizer3 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer2->Add(itemBoxSizer3, 0, wxGROW|wxALL, 5);

    m_PageSizeBox = new wxRadioBox( itemDialog1, ID_RADIOBOX, _("Page Size:"), wxDefaultPosition, wxDefaultSize, m_PageSizeList, 1, wxRA_SPECIFY_COLS );
    itemBoxSizer3->Add(m_PageSizeBox, 0, wxALIGN_LEFT|wxALL, 5);

    wxStaticText* itemStaticText5 = new wxStaticText( itemDialog1, wxID_STATIC, _("User Size X: "), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer3->Add(itemStaticText5, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    m_TextUserSizeX = new wxTextCtrl( itemDialog1, ID_TEXTCTRL7, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer3->Add(m_TextUserSizeX, 0, wxALIGN_LEFT|wxALL, 5);

    wxStaticText* itemStaticText7 = new wxStaticText( itemDialog1, wxID_STATIC, _("User Size Y: "), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer3->Add(itemStaticText7, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    m_TextUserSizeY = new wxTextCtrl( itemDialog1, ID_TEXTCTRL8, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer3->Add(m_TextUserSizeY, 0, wxALIGN_LEFT|wxALL, 5);

    wxBoxSizer* itemBoxSizer9 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer2->Add(itemBoxSizer9, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxBoxSizer* itemBoxSizer10 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer9->Add(itemBoxSizer10, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

    wxButton* itemButton11 = new wxButton( itemDialog1, wxID_OK, _("&OK"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton11->SetDefault();
    itemBoxSizer10->Add(itemButton11, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxButton* itemButton12 = new wxButton( itemDialog1, wxID_CANCEL, _("&Cancel"), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer10->Add(itemButton12, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxBoxSizer* itemBoxSizer13 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer9->Add(itemBoxSizer13, 0, wxGROW|wxALL, 5);

    m_TextSheetCount = new wxStaticText( itemDialog1, wxID_STATIC, _("Number of sheets: %d"), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer13->Add(m_TextSheetCount, 0, wxGROW|wxALL|wxADJUST_MINSIZE, 5);

    itemBoxSizer13->Add(5, 5, 0, wxGROW|wxALL, 5);

    m_TextSheetNumber = new wxStaticText( itemDialog1, wxID_STATIC, _("Sheet number: %d"), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer13->Add(m_TextSheetNumber, 0, wxGROW|wxALL|wxADJUST_MINSIZE, 5);

    wxStaticText* itemStaticText17 = new wxStaticText( itemDialog1, wxID_STATIC, _("Revision:"), wxDefaultPosition, wxDefaultSize, 0 );
    itemStaticText17->SetForegroundColour(wxColour(196, 0, 0));
    itemBoxSizer9->Add(itemStaticText17, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    m_TextRevision = new wxTextCtrl( itemDialog1, ID_TEXTCTRL, _T(""), wxDefaultPosition, wxSize(400, -1), wxTE_RICH );
    itemBoxSizer9->Add(m_TextRevision, 0, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    wxStaticText* itemStaticText19 = new wxStaticText( itemDialog1, wxID_STATIC, _("Company:"), wxDefaultPosition, wxDefaultSize, 0 );
    itemStaticText19->SetForegroundColour(wxColour(196, 0, 0));
    itemBoxSizer9->Add(itemStaticText19, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    m_TextCompany = new wxTextCtrl( itemDialog1, ID_TEXTCTRL1, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer9->Add(m_TextCompany, 0, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    wxStaticText* itemStaticText21 = new wxStaticText( itemDialog1, wxID_STATIC, _("Title:"), wxDefaultPosition, wxDefaultSize, 0 );
    itemStaticText21->SetForegroundColour(wxColour(196, 0, 0));
    itemBoxSizer9->Add(itemStaticText21, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    m_TextTitle = new wxTextCtrl( itemDialog1, ID_TEXTCTRL2, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer9->Add(m_TextTitle, 0, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    wxStaticText* itemStaticText23 = new wxStaticText( itemDialog1, wxID_STATIC, _("Comment1:"), wxDefaultPosition, wxDefaultSize, 0 );
    itemStaticText23->SetForegroundColour(wxColour(196, 0, 0));
    itemBoxSizer9->Add(itemStaticText23, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    m_TextComment1 = new wxTextCtrl( itemDialog1, ID_TEXTCTRL3, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer9->Add(m_TextComment1, 0, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    wxStaticText* itemStaticText25 = new wxStaticText( itemDialog1, wxID_STATIC, _("Comment2:"), wxDefaultPosition, wxDefaultSize, 0 );
    itemStaticText25->SetForegroundColour(wxColour(196, 0, 0));
    itemBoxSizer9->Add(itemStaticText25, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    m_TextComment2 = new wxTextCtrl( itemDialog1, ID_TEXTCTRL4, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer9->Add(m_TextComment2, 0, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    wxStaticText* itemStaticText27 = new wxStaticText( itemDialog1, wxID_STATIC, _("Comment3:"), wxDefaultPosition, wxDefaultSize, 0 );
    itemStaticText27->SetForegroundColour(wxColour(196, 0, 0));
    itemBoxSizer9->Add(itemStaticText27, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    m_TextComment3 = new wxTextCtrl( itemDialog1, ID_TEXTCTRL5, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer9->Add(m_TextComment3, 0, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    wxStaticText* itemStaticText29 = new wxStaticText( itemDialog1, wxID_STATIC, _("Comment4:"), wxDefaultPosition, wxDefaultSize, 0 );
    itemStaticText29->SetForegroundColour(wxColour(196, 0, 0));
    itemBoxSizer9->Add(itemStaticText29, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    m_TextComment4 = new wxTextCtrl( itemDialog1, ID_TEXTCTRL6, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer9->Add(m_TextComment4, 0, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    // Set validators
    m_PageSizeBox->SetValidator( wxGenericValidator(& m_CurrentSelection) );
    m_TextRevision->SetValidator( wxTextValidator(wxFILTER_NONE, & m_Screen->m_Revision) );
    m_TextCompany->SetValidator( wxTextValidator(wxFILTER_NONE, & m_Screen->m_Company) );
    m_TextTitle->SetValidator( wxTextValidator(wxFILTER_NONE, & m_Screen->m_Title) );
    m_TextComment1->SetValidator( wxTextValidator(wxFILTER_NONE, & m_Screen->m_Commentaire1) );
    m_TextComment2->SetValidator( wxTextValidator(wxFILTER_NONE, & m_Screen->m_Commentaire2) );
    m_TextComment3->SetValidator( wxTextValidator(wxFILTER_NONE, & m_Screen->m_Commentaire3) );
    m_TextComment4->SetValidator( wxTextValidator(wxFILTER_NONE, & m_Screen->m_Commentaire4) );
////@end WinEDA_SetPageFrame content construction
}

/*!
 * Should we show tooltips?
 */

bool WinEDA_SetPageFrame::ShowToolTips()
{
    return true;
}

/*!
 * Get bitmap resources
 */

wxBitmap WinEDA_SetPageFrame::GetBitmapResource( const wxString& name )
{
    // Bitmap retrieval
////@begin WinEDA_SetPageFrame bitmap retrieval
    wxUnusedVar(name);
    return wxNullBitmap;
////@end WinEDA_SetPageFrame bitmap retrieval
}

/*!
 * Get icon resources
 */

wxIcon WinEDA_SetPageFrame::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin WinEDA_SetPageFrame icon retrieval
    wxUnusedVar(name);
    return wxNullIcon;
////@end WinEDA_SetPageFrame icon retrieval
}
/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_OK
 */

void WinEDA_SetPageFrame::OnOkClick( wxCommandEvent& event )
{
	SavePageSettings(event);
	Close(TRUE);
}

/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CANCEL
 */

void WinEDA_SetPageFrame::OnCancelClick( wxCommandEvent& event )
{
	Close(TRUE);
}


/*****************************************************************/
void WinEDA_SetPageFrame::SavePageSettings(wxCommandEvent& event)
/*****************************************************************/
/* Mise a jour effective des textes et dimensions
*/
{
double dtmp;
wxString msg;
	
	m_Screen->m_Revision = m_TextRevision->GetValue();
	m_Screen->m_Company = m_TextCompany->GetValue();
	m_Screen->m_Title = m_TextTitle->GetValue();
	m_Screen->m_Commentaire1 = m_TextComment1->GetValue();
	m_Screen->m_Commentaire2 = m_TextComment2->GetValue();
	m_Screen->m_Commentaire3 = m_TextComment3->GetValue();
	m_Screen->m_Commentaire4 = m_TextComment4->GetValue();

	msg = m_TextUserSizeX->GetValue();
	msg.ToDouble(&dtmp); UserSizeX = dtmp;
	msg = m_TextUserSizeY->GetValue();
	msg.ToDouble(&dtmp); UserSizeY = dtmp;

	int ii = m_PageSizeBox->GetSelection();
	if ( ii < 0 ) ii = 0;
	m_SelectedSheet = SheetList[ii];
	m_Screen->m_CurrentSheet = m_SelectedSheet;

	if ( g_UnitMetric )
	{
		g_Sheet_user.m_Size.x = (int)(UserSizeX * 1000 / 25.4 );
		g_Sheet_user.m_Size.y = (int)(UserSizeY * 1000 / 25.4 );
	}
	else
	{
		g_Sheet_user.m_Size.x = (int)(UserSizeX * 1000 );
		g_Sheet_user.m_Size.y = (int)(UserSizeY * 1000 );
	}

	if ( g_Sheet_user.m_Size.x < 6000 )g_Sheet_user.m_Size.x = 6000;
	if ( g_Sheet_user.m_Size.x > 44000 )g_Sheet_user.m_Size.x = 44000;
	if ( g_Sheet_user.m_Size.y < 4000 )g_Sheet_user.m_Size.y = 4000;
	if ( g_Sheet_user.m_Size.y > 44000 )g_Sheet_user.m_Size.y = 44000;


	m_Screen->SetModify();
	m_Screen->SetRefreshReq();
}



/***********************************************/
void WinEDA_SetPageFrame::CreateListSizes(void)
/***********************************************/
/* Genere la RadioBox donnant la liste des dimensions des feuilles
*/
{

Ki_PageDescr * sheet;
int ii;
wxString pagesize;
	
	m_CurrentSelection = NB_ITEMS-1;
	for( ii = 0; ii < NB_ITEMS; ii++ )
	{
		sheet = SheetList[ii];
		if( m_ParentDrawFrame->m_CurrentScreen->m_CurrentSheet == sheet )
			m_CurrentSelection = ii;
		pagesize = _("Size ") + sheet->m_Name;
		m_PageSizeList.Add(pagesize);
	}
}

/*!
 * wxEVT_CLOSE_WINDOW event handler for ID_DIALOG
 */

void WinEDA_SetPageFrame::OnCloseWindow( wxCloseEvent& event )
{
	EndModal(m_Modified);
}


