/***************************************************************************
 *   Copyright (C) 2004 by Emil Stoyanov                                   *
 *   emosto@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kiaxcallrecord.h"

int KiaxCallRecord::nextRecord;

KiaxCallRecord::KiaxCallRecord()
{
  callStartTime = QString::number(QDateTime::currentDateTime().toTime_t());
  id = callStartTime+QString::number(KiaxCallRecord::nextRecord);
  nextRecord++;
  answered = false;
  outgoing = true;
  callerIdName = "user";
  callerIdNumber = "0123456789";
  callEndTime = "0";
  accountId="0";
}

KiaxCallRecord::~KiaxCallRecord()
{
}

void KiaxCallRecord::load() {
  load(id);
}

void KiaxCallRecord::load(QString id)
{
  this->id = id;
  QSettings*  settings = getSettings();
  
  callStartTime = settings->readEntry(callStartTimeKey, "0");
  callerIdName = settings->readEntry(callerIdNameKey, "user");
  callerIdNumber = settings->readEntry(callerIdNumberKey, "12345678");
  outgoing = settings->readBoolEntry(outgoingKey, true);
  answered =  settings->readBoolEntry(answeredKey, true);
  callEndTime = settings->readEntry(callEndTimeKey,"0");
  accountId = settings->readEntry(accountIdKey,"0");
  delete settings;
}

bool KiaxCallRecord::save()
{
  bool result = false;  
  
  QSettings*  settings = getSettings();
  
  result &= settings->writeEntry(callStartTimeKey, callStartTime);
  result &= settings->writeEntry(callerIdNameKey, callerIdName);
  result &= settings->writeEntry(callerIdNumberKey, callerIdNumber);
  result &= settings->writeEntry(outgoingKey, outgoing);
  result &= settings->writeEntry(answeredKey, answered);
  result &= settings->writeEntry(callEndTimeKey, callEndTime);
  result &= settings->writeEntry(accountIdKey, accountId);
  
  delete settings;
  
  return result;
  
}

void KiaxCallRecord::remove() {
  QSettings*  settings = getSettings();
  settings->removeEntry(callStartTimeKey);
  settings->removeEntry(callerIdNameKey);
  settings->removeEntry(callerIdNumberKey);
  settings->removeEntry(outgoingKey);
  settings->removeEntry(answeredKey);
  settings->removeEntry(callEndTimeKey);
  settings->removeEntry(accountIdKey);
  delete settings;
}

QSettings * KiaxCallRecord::getSettings() {
  
  QSettings* settings = new QSettings();
  settings->setPath("kiax.org","kiaxcallregister", QSettings::User);// userspace
  QString recordPrefix = "/kiaxcallregister/calls/"+id+"/";
  callStartTimeKey = recordPrefix+"callStartTime";
  callerIdNameKey = recordPrefix+"callerIdName";
  callerIdNumberKey = recordPrefix+"callerIdNumber";
  outgoingKey = recordPrefix+"outgoing";
  answeredKey = recordPrefix+"answered";
  callEndTimeKey = recordPrefix+"callEndTime";
  accountIdKey = recordPrefix+"accountId";
  
  return settings;
}

QString KiaxCallRecord::getCallerIdName() {
  return callerIdName;
}

QString KiaxCallRecord::getCallerIdNumber() {
  return callerIdNumber;
}

bool KiaxCallRecord::isAnswered() {
  return answered;
}

bool KiaxCallRecord::isOutgoing() {
  return outgoing;
}

QString KiaxCallRecord::getId() {
  return id;
}

void KiaxCallRecord::setCallerIdName(QString name) {
  callerIdName = name;
}

void KiaxCallRecord::setCallerIdNumber(QString number) {
  callerIdNumber = number;
}

void KiaxCallRecord::setAnswered(bool flag) {
  answered = flag;
}

void KiaxCallRecord::setOutgoing(bool flag) {
  outgoing = flag;
}

void KiaxCallRecord::setCallStartTime(QString sTime) {
  callStartTime = sTime;
}

void KiaxCallRecord::setCallEndTime(QString eTime) {
  callEndTime = eTime;
}

QString KiaxCallRecord::getCallStartTime() {
  return callStartTime;
}

QString KiaxCallRecord::getCallEndTime() {
  return callEndTime;
}

QString KiaxCallRecord::getAccountId() {
  return accountId;
}

void KiaxCallRecord::setAccountId(QString id) {
  accountId = id;
}

void KiaxCallRecord::setCustomProperty(const QString& name, QString value) {
  customProperty[name] = value;
}

QString KiaxCallRecord::getCustomProperty(QString name) {
 QString result = customProperty[name];
 if (!result) return "false";
  else return result;
}

QMap<QString, QString> KiaxCallRecord::getCustomPropertyList() {
  return customProperty;
}

void KiaxCallRecord::setCustomPropertyList(QMap<QString,QString> cp) {
  customProperty = cp;
}

KiaxCallRecord* KiaxCallRecord::copy() {
  KiaxCallRecord * record = new KiaxCallRecord();
  record->id = id;
  record->setAccountId(getAccountId());
  record->setAnswered(isAnswered());
  record->setCallEndTime(getCallEndTime());
  record->setCallStartTime(getCallStartTime());
  record->setCallerIdName(getCallerIdName());
  record->setCallerIdNumber(getCallerIdNumber());
  record->setCustomPropertyList(getCustomPropertyList());
  record->setOutgoing(isOutgoing());
  return record;
}
