/***************************************************************************
 *   Copyright (C) 2004 by Emil Stoyanov                                   *
 *   emosto@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef IAXWRAPPER_H
#define IAXWRAPPER_H

#include <qobject.h>
#include <qvariant.h>
#include <qpixmap.h>
#include <qapplication.h>
#include <qmainwindow.h>
#include <iaxclient.h>
#include <qevent.h>
#include <qmutex.h>
#include <qapplication.h>
#include <qtimer.h>
#include "iaxwrapperevent.h"
#include "kiaxprefs.h"
#include "kiaxaccount.h"
#include "kiaxcallrecord.h"

#include <stdarg.h>
#include <stdlib.h>

// A global callback function used by libiaxclient
int iaxc_callback(iaxc_event e);

class IaxWrapper : public QObject
{
Q_OBJECT

public:
    IaxWrapper(QObject *parent = 0, const char *name = 0);
    ~IaxWrapper();

public slots:
   
  /* High-Level GUI related methods */
  virtual void registerWithServer();
  virtual void unregisterFromServer();
  virtual void dial(QString accountId, QString contactName, QString contactNumber);
  virtual void answer_call(int callNo);
  virtual void hold_call(int callNo);
  virtual void resume_call(int callNo);
  virtual void interrupt_call();
  virtual void reject_call(int callNo);
  virtual void select_call(int callNumber);
  virtual void transfer_call(int callNo, QString number);
  virtual void send_dtmf(char digit);
  virtual void ring(); // called by the timer
  virtual void startRing();
  virtual void stopRing();
  
  /* Initialization routines */
  virtual bool init_iax_client();  // called from main win constructor
  virtual void start_iax_client();  // starts iaxclient thread
  virtual void stop_iax_client();  // stops iaxclient thread
  virtual int registerAccount(KiaxAccount* account); // register account
  virtual int unregisterAccount(KiaxAccount* account); // unregister account
  virtual void registerMultipleAccounts();
  virtual void configureCall(int accountNumber);
  virtual void shutdown_iax_client(); // called from ~IaxWrapper
  virtual iaxc_sound* initTone(int F1, int F2, int Dur, int Len, int Repeat);
  virtual void debugStatistics(int callNo, int callInterval);
  
public:  

   KiaxAccount* getAccountByRegistrationId(int regId);
   /* override eventHandling to receive events
   	from non-GUI Threads
   */
  virtual void customEvent(QCustomEvent * event); 
  int getSelectedCall();
  QString getIaxClientVersion();  
  /* Event Handling Routines */
  void handleIaxCEvent(iaxc_event e); // event callback
  void event_level(float in, float out); // monitors video and audio signal levels
  void event_registration(int id, int reply, int msgcount);// monitors registration status
  void event_state(int callNo, int state, char *remote, char *remote_name, char *local, char *local_context, int reg_id);
  void event_text(int type, char *message);
  void event_unknown(int type);
  
  KiaxPrefs * getSettings();
  KiaxCallRecord* createCallRecord(QString accountId, QString name, QString number, bool outgoing);  
  
  void debug(const char* log, ...);
  void setShowStats(bool flag);
  bool getShowStats();
protected slots:

  void callDuration();
    
public:  
  
  bool registered;     // to be sure we have a person who can receive calls
  QMap<int, KiaxCallRecord> callSession; //map callNo to callRecord
  QMutex callSessionMutex;
  
signals:
  
  /* Signals to notify the GUI */
  
  /* Wrapper events */
  //void signalCalling(QString callerId, QString callerStatus); //used only for ringing out
  void signalCalling(int callNumber, QString callerStatus); //used only for ringing out
  void signalAnsweredCall(int callNo);
  void signalHoldCall(int callNo);
  void signalResumedCall(int callNo);
  void signalRegistered();
  void signalUnregistered(); 
  
  /*Callback events */
  void signalLevels(int inValue, int outValue, int threshold ); // audio and mic levels
  void signalOutgoingRinging(int callNo); // ringing status of the tab created by singalCalling()
  void signalIncomingRinging(int callNo); // create tab and set status rining
  void signalComplete(int callNo); // call established, ready to speak
  void signalInactive(int callNo); // inactive call - hangup, forwarded to signalHangup(QString)
  void signalTextMessage(int id, int status); // inactive call - hangup, forwarded to   signalHangup(QString)
  //void signalUnregistrationRequested(KiaxAccount* account);
  void signalRegistrationRequested(KiaxAccount* account);
  //void signalRegistrationAccepted(KiaxAccount* account);
  //void signalRegistrationRejected(KiaxAccount* account);
  //void signalRegistrationTimeout(KiaxAccount* account);
  void signalTextMessage(QString message);
  void signalDebug(const char * error);
  
  void callTime(int callNo, int hours, int minutes, int seconds); // inform about the time of the call - every second
  void fatalError(QString message);
    
private:

  /* Lower level libiaxclient routines */
  void fatal_error(char *err);
  uint getCodecMaskFromName(QString codecName);
  int findAccountById(QString accountId);
private:
  KiaxPrefs * settings;
  struct iaxc_sound* ringInTone;
  struct iaxc_sound* ringOutTone;
  QTimer* ringTimer;
  QTimer* callDurationTimer;
  int * rtt;
  iaxc_netstat * localNetstat;
  iaxc_netstat * remoteNetstat;
  bool showStats;
  char* iaxc_ver;
};

#endif
