/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 * Copyright (C) 2004 Markus Brueffer <markus@brueffer.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#ifndef KFTPBOOKMARKEDITOR_H
#define KFTPBOOKMARKEDITOR_H

#include "ui/bookmark_properties.h"

#include <kaction.h>
#include <kdialogbase.h>

#include <qlistview.h>
#include <qdom.h>

namespace KFTPBookmarks {
  class Manager;
  class Site;
}

namespace KFTPWidgets {

namespace Bookmarks {

class ListViewItem;
class ListView;

/**
@author Jernej Kos
*/
class BookmarkEditor : public KDialogBase
{
Q_OBJECT
public:
    BookmarkEditor(QWidget *parent = 0, const char *name = 0);
    BookmarkEditor(ListViewItem *item, QWidget *parent = 0, const char *name = 0);
    ~BookmarkEditor();
private:
    enum BookmarkType {
      BT_CATEGORY = 0,
      BT_SERVER
    };

    enum ServerProtocol {
      SP_FTP = 0,
      SP_SSL_EXPLICIT,
      SP_SSL_IMPLICIT,
      SP_SFTP
    };

    KFTPBookmarks::Manager *m_bookmarks;
    KFTPBookmarks::Site *m_activeSite;

    ListViewItem *m_activeItem;

    BookmarkProperties *m_properties;
    ListView *m_tree;

    bool m_portChanged;

    /* Actions */
    KAction *m_newAction;
    KAction *m_renameAction;
    KAction *m_deleteAction;
    KAction *m_subCatAction;
    KAction *m_copyAction;
    KActionCollection *actionCollection();

    // Some common stuff for the constructors
    void initDialog();

    void showActiveNode();
public slots:
    void refresh();
private slots:
    /* Action slots */
    void slotNewAction(ListViewItem *item, KFTPBookmarks::Site *site);
    void slotDeleteAction();
    void slotDuplicateAction(ListViewItem *item, KFTPBookmarks::Site *site);

    /* Other slots */
    void slotChangeAnonLogin();
    void slotProtoAdvancedClicked();
    void slotChangeActiveRetryGroup();
    void slotChangeActiveKeepaliveGroup();
    void slotChangeServerProtocol(int item);
    void slotPortChanged();

    void slotTreeClicked(QListViewItem *item);

    void slotImportWizard();
    void slotExportWizard();

    void slotSaveActiveNode();
};

}

}

#endif
