/*
 * System call argument to DTrace register array converstion.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * $FreeBSD: src/sys/kern/systrace_args.c,v 1.14 2007/08/16 05:32:26 davidxu Exp $
 * This file is part of the DTrace syscall provider.
 */

static void
systrace_args(int sysnum, void *params, u_int64_t *uarg, int *n_args)
{
	int64_t *iarg  = (int64_t *) uarg;
	switch (sysnum) {
	/* nosys */
	case 0: {
		*n_args = 0;
		break;
	}
	/* sys_exit */
	case 1: {
		struct sys_exit_args *p = params;
		iarg[0] = p->rval; /* int */
		*n_args = 1;
		break;
	}
	/* fork */
	case 2: {
		*n_args = 0;
		break;
	}
	/* read */
	case 3: {
		struct read_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->buf; /* void * */
		uarg[2] = p->nbyte; /* size_t */
		*n_args = 3;
		break;
	}
	/* write */
	case 4: {
		struct write_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->buf; /* const void * */
		uarg[2] = p->nbyte; /* size_t */
		*n_args = 3;
		break;
	}
	/* open */
	case 5: {
		struct open_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->flags; /* int */
		iarg[2] = p->mode; /* int */
		*n_args = 3;
		break;
	}
	/* close */
	case 6: {
		struct close_args *p = params;
		iarg[0] = p->fd; /* int */
		*n_args = 1;
		break;
	}
	/* wait4 */
	case 7: {
		struct wait_args *p = params;
		iarg[0] = p->pid; /* int */
		uarg[1] = (intptr_t) p->status; /* int * */
		iarg[2] = p->options; /* int */
		uarg[3] = (intptr_t) p->rusage; /* struct rusage * */
		*n_args = 4;
		break;
	}
	/* link */
	case 9: {
		struct link_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->link; /* char * */
		*n_args = 2;
		break;
	}
	/* unlink */
	case 10: {
		struct unlink_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* chdir */
	case 12: {
		struct chdir_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* fchdir */
	case 13: {
		struct fchdir_args *p = params;
		iarg[0] = p->fd; /* int */
		*n_args = 1;
		break;
	}
	/* mknod */
	case 14: {
		struct mknod_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->mode; /* int */
		iarg[2] = p->dev; /* int */
		*n_args = 3;
		break;
	}
	/* chmod */
	case 15: {
		struct chmod_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->mode; /* int */
		*n_args = 2;
		break;
	}
	/* chown */
	case 16: {
		struct chown_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->uid; /* int */
		iarg[2] = p->gid; /* int */
		*n_args = 3;
		break;
	}
	/* obreak */
	case 17: {
		struct obreak_args *p = params;
		uarg[0] = (intptr_t) p->nsize; /* char * */
		*n_args = 1;
		break;
	}
	/* getpid */
	case 20: {
		*n_args = 0;
		break;
	}
	/* mount */
	case 21: {
		struct mount_args *p = params;
		uarg[0] = (intptr_t) p->type; /* char * */
		uarg[1] = (intptr_t) p->path; /* char * */
		iarg[2] = p->flags; /* int */
		uarg[3] = (intptr_t) p->data; /* caddr_t */
		*n_args = 4;
		break;
	}
	/* unmount */
	case 22: {
		struct unmount_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->flags; /* int */
		*n_args = 2;
		break;
	}
	/* setuid */
	case 23: {
		struct setuid_args *p = params;
		uarg[0] = p->uid; /* uid_t */
		*n_args = 1;
		break;
	}
	/* getuid */
	case 24: {
		*n_args = 0;
		break;
	}
	/* geteuid */
	case 25: {
		*n_args = 0;
		break;
	}
	/* ptrace */
	case 26: {
		struct ptrace_args *p = params;
		iarg[0] = p->req; /* int */
		iarg[1] = p->pid; /* pid_t */
		uarg[2] = (intptr_t) p->addr; /* caddr_t */
		iarg[3] = p->data; /* int */
		*n_args = 4;
		break;
	}
	/* recvmsg */
	case 27: {
		struct recvmsg_args *p = params;
		iarg[0] = p->s; /* int */
		uarg[1] = (intptr_t) p->msg; /* struct msghdr * */
		iarg[2] = p->flags; /* int */
		*n_args = 3;
		break;
	}
	/* sendmsg */
	case 28: {
		struct sendmsg_args *p = params;
		iarg[0] = p->s; /* int */
		uarg[1] = (intptr_t) p->msg; /* struct msghdr * */
		iarg[2] = p->flags; /* int */
		*n_args = 3;
		break;
	}
	/* recvfrom */
	case 29: {
		struct recvfrom_args *p = params;
		iarg[0] = p->s; /* int */
		uarg[1] = (intptr_t) p->buf; /* caddr_t */
		uarg[2] = p->len; /* size_t */
		iarg[3] = p->flags; /* int */
		uarg[4] = (intptr_t) p->from; /* struct sockaddr *__restrict */
		uarg[5] = (intptr_t) p->fromlenaddr; /* __socklen_t *__restrict */
		*n_args = 6;
		break;
	}
	/* accept */
	case 30: {
		struct accept_args *p = params;
		iarg[0] = p->s; /* int */
		uarg[1] = (intptr_t) p->name; /* struct sockaddr *__restrict */
		uarg[2] = (intptr_t) p->anamelen; /* __socklen_t *__restrict */
		*n_args = 3;
		break;
	}
	/* getpeername */
	case 31: {
		struct getpeername_args *p = params;
		iarg[0] = p->fdes; /* int */
		uarg[1] = (intptr_t) p->asa; /* struct sockaddr *__restrict */
		uarg[2] = (intptr_t) p->alen; /* __socklen_t *__restrict */
		*n_args = 3;
		break;
	}
	/* getsockname */
	case 32: {
		struct getsockname_args *p = params;
		iarg[0] = p->fdes; /* int */
		uarg[1] = (intptr_t) p->asa; /* struct sockaddr *__restrict */
		uarg[2] = (intptr_t) p->alen; /* __socklen_t *__restrict */
		*n_args = 3;
		break;
	}
	/* access */
	case 33: {
		struct access_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->flags; /* int */
		*n_args = 2;
		break;
	}
	/* chflags */
	case 34: {
		struct chflags_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->flags; /* int */
		*n_args = 2;
		break;
	}
	/* fchflags */
	case 35: {
		struct fchflags_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->flags; /* int */
		*n_args = 2;
		break;
	}
	/* sync */
	case 36: {
		*n_args = 0;
		break;
	}
	/* kill */
	case 37: {
		struct kill_args *p = params;
		iarg[0] = p->pid; /* int */
		iarg[1] = p->signum; /* int */
		*n_args = 2;
		break;
	}
	/* getppid */
	case 39: {
		*n_args = 0;
		break;
	}
	/* dup */
	case 41: {
		struct dup_args *p = params;
		uarg[0] = p->fd; /* u_int */
		*n_args = 1;
		break;
	}
	/* pipe */
	case 42: {
		*n_args = 0;
		break;
	}
	/* getegid */
	case 43: {
		*n_args = 0;
		break;
	}
	/* profil */
	case 44: {
		struct profil_args *p = params;
		uarg[0] = (intptr_t) p->samples; /* caddr_t */
		uarg[1] = p->size; /* size_t */
		uarg[2] = p->offset; /* size_t */
		uarg[3] = p->scale; /* u_int */
		*n_args = 4;
		break;
	}
	/* ktrace */
	case 45: {
		struct ktrace_args *p = params;
		uarg[0] = (intptr_t) p->fname; /* const char * */
		iarg[1] = p->ops; /* int */
		iarg[2] = p->facs; /* int */
		iarg[3] = p->pid; /* int */
		*n_args = 4;
		break;
	}
	/* getgid */
	case 47: {
		*n_args = 0;
		break;
	}
	/* getlogin */
	case 49: {
		struct getlogin_args *p = params;
		uarg[0] = (intptr_t) p->namebuf; /* char * */
		uarg[1] = p->namelen; /* u_int */
		*n_args = 2;
		break;
	}
	/* setlogin */
	case 50: {
		struct setlogin_args *p = params;
		uarg[0] = (intptr_t) p->namebuf; /* char * */
		*n_args = 1;
		break;
	}
	/* acct */
	case 51: {
		struct acct_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* sigaltstack */
	case 53: {
		struct sigaltstack_args *p = params;
		uarg[0] = (intptr_t) p->ss; /* stack_t * */
		uarg[1] = (intptr_t) p->oss; /* stack_t * */
		*n_args = 2;
		break;
	}
	/* ioctl */
	case 54: {
		struct ioctl_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = p->com; /* u_long */
		uarg[2] = (intptr_t) p->data; /* caddr_t */
		*n_args = 3;
		break;
	}
	/* reboot */
	case 55: {
		struct reboot_args *p = params;
		iarg[0] = p->opt; /* int */
		*n_args = 1;
		break;
	}
	/* revoke */
	case 56: {
		struct revoke_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* symlink */
	case 57: {
		struct symlink_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->link; /* char * */
		*n_args = 2;
		break;
	}
	/* readlink */
	case 58: {
		struct readlink_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->buf; /* char * */
		iarg[2] = p->count; /* int */
		*n_args = 3;
		break;
	}
	/* execve */
	case 59: {
		struct execve_args *p = params;
		uarg[0] = (intptr_t) p->fname; /* char * */
		uarg[1] = (intptr_t) p->argv; /* char ** */
		uarg[2] = (intptr_t) p->envv; /* char ** */
		*n_args = 3;
		break;
	}
	/* umask */
	case 60: {
		struct umask_args *p = params;
		iarg[0] = p->newmask; /* int */
		*n_args = 1;
		break;
	}
	/* chroot */
	case 61: {
		struct chroot_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* msync */
	case 65: {
		struct msync_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* void * */
		uarg[1] = p->len; /* size_t */
		iarg[2] = p->flags; /* int */
		*n_args = 3;
		break;
	}
	/* vfork */
	case 66: {
		*n_args = 0;
		break;
	}
	/* sbrk */
	case 69: {
		struct sbrk_args *p = params;
		iarg[0] = p->incr; /* int */
		*n_args = 1;
		break;
	}
	/* sstk */
	case 70: {
		struct sstk_args *p = params;
		iarg[0] = p->incr; /* int */
		*n_args = 1;
		break;
	}
	/* ovadvise */
	case 72: {
		struct ovadvise_args *p = params;
		iarg[0] = p->anom; /* int */
		*n_args = 1;
		break;
	}
	/* munmap */
	case 73: {
		struct munmap_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* void * */
		uarg[1] = p->len; /* size_t */
		*n_args = 2;
		break;
	}
	/* mprotect */
	case 74: {
		struct mprotect_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* const void * */
		uarg[1] = p->len; /* size_t */
		iarg[2] = p->prot; /* int */
		*n_args = 3;
		break;
	}
	/* madvise */
	case 75: {
		struct madvise_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* void * */
		uarg[1] = p->len; /* size_t */
		iarg[2] = p->behav; /* int */
		*n_args = 3;
		break;
	}
	/* mincore */
	case 78: {
		struct mincore_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* const void * */
		uarg[1] = p->len; /* size_t */
		uarg[2] = (intptr_t) p->vec; /* char * */
		*n_args = 3;
		break;
	}
	/* getgroups */
	case 79: {
		struct getgroups_args *p = params;
		uarg[0] = p->gidsetsize; /* u_int */
		uarg[1] = (intptr_t) p->gidset; /* gid_t * */
		*n_args = 2;
		break;
	}
	/* setgroups */
	case 80: {
		struct setgroups_args *p = params;
		uarg[0] = p->gidsetsize; /* u_int */
		uarg[1] = (intptr_t) p->gidset; /* gid_t * */
		*n_args = 2;
		break;
	}
	/* getpgrp */
	case 81: {
		*n_args = 0;
		break;
	}
	/* setpgid */
	case 82: {
		struct setpgid_args *p = params;
		iarg[0] = p->pid; /* int */
		iarg[1] = p->pgid; /* int */
		*n_args = 2;
		break;
	}
	/* setitimer */
	case 83: {
		struct setitimer_args *p = params;
		uarg[0] = p->which; /* u_int */
		uarg[1] = (intptr_t) p->itv; /* struct itimerval * */
		uarg[2] = (intptr_t) p->oitv; /* struct itimerval * */
		*n_args = 3;
		break;
	}
	/* swapon */
	case 85: {
		struct swapon_args *p = params;
		uarg[0] = (intptr_t) p->name; /* char * */
		*n_args = 1;
		break;
	}
	/* getitimer */
	case 86: {
		struct getitimer_args *p = params;
		uarg[0] = p->which; /* u_int */
		uarg[1] = (intptr_t) p->itv; /* struct itimerval * */
		*n_args = 2;
		break;
	}
	/* getdtablesize */
	case 89: {
		*n_args = 0;
		break;
	}
	/* dup2 */
	case 90: {
		struct dup2_args *p = params;
		uarg[0] = p->from; /* u_int */
		uarg[1] = p->to; /* u_int */
		*n_args = 2;
		break;
	}
	/* fcntl */
	case 92: {
		struct fcntl_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->cmd; /* int */
		iarg[2] = p->arg; /* long */
		*n_args = 3;
		break;
	}
	/* select */
	case 93: {
		struct select_args *p = params;
		iarg[0] = p->nd; /* int */
		uarg[1] = (intptr_t) p->in; /* fd_set * */
		uarg[2] = (intptr_t) p->ou; /* fd_set * */
		uarg[3] = (intptr_t) p->ex; /* fd_set * */
		uarg[4] = (intptr_t) p->tv; /* struct timeval * */
		*n_args = 5;
		break;
	}
	/* fsync */
	case 95: {
		struct fsync_args *p = params;
		iarg[0] = p->fd; /* int */
		*n_args = 1;
		break;
	}
	/* setpriority */
	case 96: {
		struct setpriority_args *p = params;
		iarg[0] = p->which; /* int */
		iarg[1] = p->who; /* int */
		iarg[2] = p->prio; /* int */
		*n_args = 3;
		break;
	}
	/* socket */
	case 97: {
		struct socket_args *p = params;
		iarg[0] = p->domain; /* int */
		iarg[1] = p->type; /* int */
		iarg[2] = p->protocol; /* int */
		*n_args = 3;
		break;
	}
	/* connect */
	case 98: {
		struct connect_args *p = params;
		iarg[0] = p->s; /* int */
		uarg[1] = (intptr_t) p->name; /* caddr_t */
		iarg[2] = p->namelen; /* int */
		*n_args = 3;
		break;
	}
	/* getpriority */
	case 100: {
		struct getpriority_args *p = params;
		iarg[0] = p->which; /* int */
		iarg[1] = p->who; /* int */
		*n_args = 2;
		break;
	}
	/* bind */
	case 104: {
		struct bind_args *p = params;
		iarg[0] = p->s; /* int */
		uarg[1] = (intptr_t) p->name; /* caddr_t */
		iarg[2] = p->namelen; /* int */
		*n_args = 3;
		break;
	}
	/* setsockopt */
	case 105: {
		struct setsockopt_args *p = params;
		iarg[0] = p->s; /* int */
		iarg[1] = p->level; /* int */
		iarg[2] = p->name; /* int */
		uarg[3] = (intptr_t) p->val; /* caddr_t */
		iarg[4] = p->valsize; /* int */
		*n_args = 5;
		break;
	}
	/* listen */
	case 106: {
		struct listen_args *p = params;
		iarg[0] = p->s; /* int */
		iarg[1] = p->backlog; /* int */
		*n_args = 2;
		break;
	}
	/* gettimeofday */
	case 116: {
		struct gettimeofday_args *p = params;
		uarg[0] = (intptr_t) p->tp; /* struct timeval * */
		uarg[1] = (intptr_t) p->tzp; /* struct timezone * */
		*n_args = 2;
		break;
	}
	/* getrusage */
	case 117: {
		struct getrusage_args *p = params;
		iarg[0] = p->who; /* int */
		uarg[1] = (intptr_t) p->rusage; /* struct rusage * */
		*n_args = 2;
		break;
	}
	/* getsockopt */
	case 118: {
		struct getsockopt_args *p = params;
		iarg[0] = p->s; /* int */
		iarg[1] = p->level; /* int */
		iarg[2] = p->name; /* int */
		uarg[3] = (intptr_t) p->val; /* caddr_t */
		uarg[4] = (intptr_t) p->avalsize; /* int * */
		*n_args = 5;
		break;
	}
	/* readv */
	case 120: {
		struct readv_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->iovp; /* struct iovec * */
		uarg[2] = p->iovcnt; /* u_int */
		*n_args = 3;
		break;
	}
	/* writev */
	case 121: {
		struct writev_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->iovp; /* struct iovec * */
		uarg[2] = p->iovcnt; /* u_int */
		*n_args = 3;
		break;
	}
	/* settimeofday */
	case 122: {
		struct settimeofday_args *p = params;
		uarg[0] = (intptr_t) p->tv; /* struct timeval * */
		uarg[1] = (intptr_t) p->tzp; /* struct timezone * */
		*n_args = 2;
		break;
	}
	/* fchown */
	case 123: {
		struct fchown_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->uid; /* int */
		iarg[2] = p->gid; /* int */
		*n_args = 3;
		break;
	}
	/* fchmod */
	case 124: {
		struct fchmod_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->mode; /* int */
		*n_args = 2;
		break;
	}
	/* setreuid */
	case 126: {
		struct setreuid_args *p = params;
		iarg[0] = p->ruid; /* int */
		iarg[1] = p->euid; /* int */
		*n_args = 2;
		break;
	}
	/* setregid */
	case 127: {
		struct setregid_args *p = params;
		iarg[0] = p->rgid; /* int */
		iarg[1] = p->egid; /* int */
		*n_args = 2;
		break;
	}
	/* rename */
	case 128: {
		struct rename_args *p = params;
		uarg[0] = (intptr_t) p->from; /* char * */
		uarg[1] = (intptr_t) p->to; /* char * */
		*n_args = 2;
		break;
	}
	/* flock */
	case 131: {
		struct flock_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->how; /* int */
		*n_args = 2;
		break;
	}
	/* mkfifo */
	case 132: {
		struct mkfifo_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->mode; /* int */
		*n_args = 2;
		break;
	}
	/* sendto */
	case 133: {
		struct sendto_args *p = params;
		iarg[0] = p->s; /* int */
		uarg[1] = (intptr_t) p->buf; /* caddr_t */
		uarg[2] = p->len; /* size_t */
		iarg[3] = p->flags; /* int */
		uarg[4] = (intptr_t) p->to; /* caddr_t */
		iarg[5] = p->tolen; /* int */
		*n_args = 6;
		break;
	}
	/* shutdown */
	case 134: {
		struct shutdown_args *p = params;
		iarg[0] = p->s; /* int */
		iarg[1] = p->how; /* int */
		*n_args = 2;
		break;
	}
	/* socketpair */
	case 135: {
		struct socketpair_args *p = params;
		iarg[0] = p->domain; /* int */
		iarg[1] = p->type; /* int */
		iarg[2] = p->protocol; /* int */
		uarg[3] = (intptr_t) p->rsv; /* int * */
		*n_args = 4;
		break;
	}
	/* mkdir */
	case 136: {
		struct mkdir_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->mode; /* int */
		*n_args = 2;
		break;
	}
	/* rmdir */
	case 137: {
		struct rmdir_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* utimes */
	case 138: {
		struct utimes_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->tptr; /* struct timeval * */
		*n_args = 2;
		break;
	}
	/* adjtime */
	case 140: {
		struct adjtime_args *p = params;
		uarg[0] = (intptr_t) p->delta; /* struct timeval * */
		uarg[1] = (intptr_t) p->olddelta; /* struct timeval * */
		*n_args = 2;
		break;
	}
	/* setsid */
	case 147: {
		*n_args = 0;
		break;
	}
	/* quotactl */
	case 148: {
		struct quotactl_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->cmd; /* int */
		iarg[2] = p->uid; /* int */
		uarg[3] = (intptr_t) p->arg; /* caddr_t */
		*n_args = 4;
		break;
	}
	/* nfssvc */
	case 155: {
		struct nfssvc_args *p = params;
		iarg[0] = p->flag; /* int */
		uarg[1] = (intptr_t) p->argp; /* caddr_t */
		*n_args = 2;
		break;
	}
	/* lgetfh */
	case 160: {
		struct lgetfh_args *p = params;
		uarg[0] = (intptr_t) p->fname; /* char * */
		uarg[1] = (intptr_t) p->fhp; /* struct fhandle * */
		*n_args = 2;
		break;
	}
	/* getfh */
	case 161: {
		struct getfh_args *p = params;
		uarg[0] = (intptr_t) p->fname; /* char * */
		uarg[1] = (intptr_t) p->fhp; /* struct fhandle * */
		*n_args = 2;
		break;
	}
	/* getdomainname */
	case 162: {
		struct getdomainname_args *p = params;
		uarg[0] = (intptr_t) p->domainname; /* char * */
		iarg[1] = p->len; /* int */
		*n_args = 2;
		break;
	}
	/* setdomainname */
	case 163: {
		struct setdomainname_args *p = params;
		uarg[0] = (intptr_t) p->domainname; /* char * */
		iarg[1] = p->len; /* int */
		*n_args = 2;
		break;
	}
	/* uname */
	case 164: {
		struct uname_args *p = params;
		uarg[0] = (intptr_t) p->name; /* struct utsname * */
		*n_args = 1;
		break;
	}
	/* sysarch */
	case 165: {
		struct sysarch_args *p = params;
		iarg[0] = p->op; /* int */
		uarg[1] = (intptr_t) p->parms; /* char * */
		*n_args = 2;
		break;
	}
	/* rtprio */
	case 166: {
		struct rtprio_args *p = params;
		iarg[0] = p->function; /* int */
		iarg[1] = p->pid; /* pid_t */
		uarg[2] = (intptr_t) p->rtp; /* struct rtprio * */
		*n_args = 3;
		break;
	}
	/* semsys */
	case 169: {
		struct semsys_args *p = params;
		iarg[0] = p->which; /* int */
		iarg[1] = p->a2; /* int */
		iarg[2] = p->a3; /* int */
		iarg[3] = p->a4; /* int */
		iarg[4] = p->a5; /* int */
		*n_args = 5;
		break;
	}
	/* msgsys */
	case 170: {
		struct msgsys_args *p = params;
		iarg[0] = p->which; /* int */
		iarg[1] = p->a2; /* int */
		iarg[2] = p->a3; /* int */
		iarg[3] = p->a4; /* int */
		iarg[4] = p->a5; /* int */
		iarg[5] = p->a6; /* int */
		*n_args = 6;
		break;
	}
	/* shmsys */
	case 171: {
		struct shmsys_args *p = params;
		iarg[0] = p->which; /* int */
		iarg[1] = p->a2; /* int */
		iarg[2] = p->a3; /* int */
		iarg[3] = p->a4; /* int */
		*n_args = 4;
		break;
	}
	/* freebsd6_pread */
	case 173: {
		struct freebsd6_pread_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->buf; /* void * */
		uarg[2] = p->nbyte; /* size_t */
		iarg[3] = p->pad; /* int */
		iarg[4] = p->offset; /* off_t */
		*n_args = 5;
		break;
	}
	/* freebsd6_pwrite */
	case 174: {
		struct freebsd6_pwrite_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->buf; /* const void * */
		uarg[2] = p->nbyte; /* size_t */
		iarg[3] = p->pad; /* int */
		iarg[4] = p->offset; /* off_t */
		*n_args = 5;
		break;
	}
	/* ntp_adjtime */
	case 176: {
		struct ntp_adjtime_args *p = params;
		uarg[0] = (intptr_t) p->tp; /* struct timex * */
		*n_args = 1;
		break;
	}
	/* setgid */
	case 181: {
		struct setgid_args *p = params;
		iarg[0] = p->gid; /* gid_t */
		*n_args = 1;
		break;
	}
	/* setegid */
	case 182: {
		struct setegid_args *p = params;
		iarg[0] = p->egid; /* gid_t */
		*n_args = 1;
		break;
	}
	/* seteuid */
	case 183: {
		struct seteuid_args *p = params;
		uarg[0] = p->euid; /* uid_t */
		*n_args = 1;
		break;
	}
	/* stat */
	case 188: {
		struct stat_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->ub; /* struct stat * */
		*n_args = 2;
		break;
	}
	/* fstat */
	case 189: {
		struct fstat_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->sb; /* struct stat * */
		*n_args = 2;
		break;
	}
	/* lstat */
	case 190: {
		struct lstat_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->ub; /* struct stat * */
		*n_args = 2;
		break;
	}
	/* pathconf */
	case 191: {
		struct pathconf_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->name; /* int */
		*n_args = 2;
		break;
	}
	/* fpathconf */
	case 192: {
		struct fpathconf_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->name; /* int */
		*n_args = 2;
		break;
	}
	/* getrlimit */
	case 194: {
		struct __getrlimit_args *p = params;
		uarg[0] = p->which; /* u_int */
		uarg[1] = (intptr_t) p->rlp; /* struct rlimit * */
		*n_args = 2;
		break;
	}
	/* setrlimit */
	case 195: {
		struct __setrlimit_args *p = params;
		uarg[0] = p->which; /* u_int */
		uarg[1] = (intptr_t) p->rlp; /* struct rlimit * */
		*n_args = 2;
		break;
	}
	/* getdirentries */
	case 196: {
		struct getdirentries_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->buf; /* char * */
		uarg[2] = p->count; /* u_int */
		uarg[3] = (intptr_t) p->basep; /* long * */
		*n_args = 4;
		break;
	}
	/* freebsd6_mmap */
	case 197: {
		struct freebsd6_mmap_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* caddr_t */
		uarg[1] = p->len; /* size_t */
		iarg[2] = p->prot; /* int */
		iarg[3] = p->flags; /* int */
		iarg[4] = p->fd; /* int */
		iarg[5] = p->pad; /* int */
		iarg[6] = p->pos; /* off_t */
		*n_args = 7;
		break;
	}
	/* nosys */
	case 198: {
		*n_args = 0;
		break;
	}
	/* freebsd6_lseek */
	case 199: {
		struct freebsd6_lseek_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->pad; /* int */
		iarg[2] = p->offset; /* off_t */
		iarg[3] = p->whence; /* int */
		*n_args = 4;
		break;
	}
	/* freebsd6_truncate */
	case 200: {
		struct freebsd6_truncate_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->pad; /* int */
		iarg[2] = p->length; /* off_t */
		*n_args = 3;
		break;
	}
	/* freebsd6_ftruncate */
	case 201: {
		struct freebsd6_ftruncate_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->pad; /* int */
		iarg[2] = p->length; /* off_t */
		*n_args = 3;
		break;
	}
	/* __sysctl */
	case 202: {
		struct sysctl_args *p = params;
		uarg[0] = (intptr_t) p->name; /* int * */
		uarg[1] = p->namelen; /* u_int */
		uarg[2] = (intptr_t) p->old; /* void * */
		uarg[3] = (intptr_t) p->oldlenp; /* size_t * */
		uarg[4] = (intptr_t) p->new; /* void * */
		uarg[5] = p->newlen; /* size_t */
		*n_args = 6;
		break;
	}
	/* mlock */
	case 203: {
		struct mlock_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* const void * */
		uarg[1] = p->len; /* size_t */
		*n_args = 2;
		break;
	}
	/* munlock */
	case 204: {
		struct munlock_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* const void * */
		uarg[1] = p->len; /* size_t */
		*n_args = 2;
		break;
	}
	/* undelete */
	case 205: {
		struct undelete_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* futimes */
	case 206: {
		struct futimes_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->tptr; /* struct timeval * */
		*n_args = 2;
		break;
	}
	/* getpgid */
	case 207: {
		struct getpgid_args *p = params;
		iarg[0] = p->pid; /* pid_t */
		*n_args = 1;
		break;
	}
	/* poll */
	case 209: {
		struct poll_args *p = params;
		uarg[0] = (intptr_t) p->fds; /* struct pollfd * */
		uarg[1] = p->nfds; /* u_int */
		iarg[2] = p->timeout; /* int */
		*n_args = 3;
		break;
	}
	/* lkmnosys */
	case 210: {
		*n_args = 0;
		break;
	}
	/* lkmnosys */
	case 211: {
		*n_args = 0;
		break;
	}
	/* lkmnosys */
	case 212: {
		*n_args = 0;
		break;
	}
	/* lkmnosys */
	case 213: {
		*n_args = 0;
		break;
	}
	/* lkmnosys */
	case 214: {
		*n_args = 0;
		break;
	}
	/* lkmnosys */
	case 215: {
		*n_args = 0;
		break;
	}
	/* lkmnosys */
	case 216: {
		*n_args = 0;
		break;
	}
	/* lkmnosys */
	case 217: {
		*n_args = 0;
		break;
	}
	/* lkmnosys */
	case 218: {
		*n_args = 0;
		break;
	}
	/* lkmnosys */
	case 219: {
		*n_args = 0;
		break;
	}
	/* __semctl */
	case 220: {
		struct __semctl_args *p = params;
		iarg[0] = p->semid; /* int */
		iarg[1] = p->semnum; /* int */
		iarg[2] = p->cmd; /* int */
		uarg[3] = (intptr_t) p->arg; /* union semun * */
		*n_args = 4;
		break;
	}
	/* semget */
	case 221: {
		struct semget_args *p = params;
		iarg[0] = p->key; /* key_t */
		iarg[1] = p->nsems; /* int */
		iarg[2] = p->semflg; /* int */
		*n_args = 3;
		break;
	}
	/* semop */
	case 222: {
		struct semop_args *p = params;
		iarg[0] = p->semid; /* int */
		uarg[1] = (intptr_t) p->sops; /* struct sembuf * */
		uarg[2] = p->nsops; /* size_t */
		*n_args = 3;
		break;
	}
	/* msgctl */
	case 224: {
		struct msgctl_args *p = params;
		iarg[0] = p->msqid; /* int */
		iarg[1] = p->cmd; /* int */
		uarg[2] = (intptr_t) p->buf; /* struct msqid_ds * */
		*n_args = 3;
		break;
	}
	/* msgget */
	case 225: {
		struct msgget_args *p = params;
		iarg[0] = p->key; /* key_t */
		iarg[1] = p->msgflg; /* int */
		*n_args = 2;
		break;
	}
	/* msgsnd */
	case 226: {
		struct msgsnd_args *p = params;
		iarg[0] = p->msqid; /* int */
		uarg[1] = (intptr_t) p->msgp; /* const void * */
		uarg[2] = p->msgsz; /* size_t */
		iarg[3] = p->msgflg; /* int */
		*n_args = 4;
		break;
	}
	/* msgrcv */
	case 227: {
		struct msgrcv_args *p = params;
		iarg[0] = p->msqid; /* int */
		uarg[1] = (intptr_t) p->msgp; /* void * */
		uarg[2] = p->msgsz; /* size_t */
		iarg[3] = p->msgtyp; /* long */
		iarg[4] = p->msgflg; /* int */
		*n_args = 5;
		break;
	}
	/* shmat */
	case 228: {
		struct shmat_args *p = params;
		iarg[0] = p->shmid; /* int */
		uarg[1] = (intptr_t) p->shmaddr; /* const void * */
		iarg[2] = p->shmflg; /* int */
		*n_args = 3;
		break;
	}
	/* shmctl */
	case 229: {
		struct shmctl_args *p = params;
		iarg[0] = p->shmid; /* int */
		iarg[1] = p->cmd; /* int */
		uarg[2] = (intptr_t) p->buf; /* struct shmid_ds * */
		*n_args = 3;
		break;
	}
	/* shmdt */
	case 230: {
		struct shmdt_args *p = params;
		uarg[0] = (intptr_t) p->shmaddr; /* const void * */
		*n_args = 1;
		break;
	}
	/* shmget */
	case 231: {
		struct shmget_args *p = params;
		iarg[0] = p->key; /* key_t */
		uarg[1] = p->size; /* size_t */
		iarg[2] = p->shmflg; /* int */
		*n_args = 3;
		break;
	}
	/* clock_gettime */
	case 232: {
		struct clock_gettime_args *p = params;
		iarg[0] = p->clock_id; /* clockid_t */
		uarg[1] = (intptr_t) p->tp; /* struct timespec * */
		*n_args = 2;
		break;
	}
	/* clock_settime */
	case 233: {
		struct clock_settime_args *p = params;
		iarg[0] = p->clock_id; /* clockid_t */
		uarg[1] = (intptr_t) p->tp; /* const struct timespec * */
		*n_args = 2;
		break;
	}
	/* clock_getres */
	case 234: {
		struct clock_getres_args *p = params;
		iarg[0] = p->clock_id; /* clockid_t */
		uarg[1] = (intptr_t) p->tp; /* struct timespec * */
		*n_args = 2;
		break;
	}
	/* ktimer_create */
	case 235: {
		struct ktimer_create_args *p = params;
		iarg[0] = p->clock_id; /* clockid_t */
		uarg[1] = (intptr_t) p->evp; /* struct sigevent * */
		uarg[2] = (intptr_t) p->timerid; /* int * */
		*n_args = 3;
		break;
	}
	/* ktimer_delete */
	case 236: {
		struct ktimer_delete_args *p = params;
		iarg[0] = p->timerid; /* int */
		*n_args = 1;
		break;
	}
	/* ktimer_settime */
	case 237: {
		struct ktimer_settime_args *p = params;
		iarg[0] = p->timerid; /* int */
		iarg[1] = p->flags; /* int */
		uarg[2] = (intptr_t) p->value; /* const struct itimerspec * */
		uarg[3] = (intptr_t) p->ovalue; /* struct itimerspec * */
		*n_args = 4;
		break;
	}
	/* ktimer_gettime */
	case 238: {
		struct ktimer_gettime_args *p = params;
		iarg[0] = p->timerid; /* int */
		uarg[1] = (intptr_t) p->value; /* struct itimerspec * */
		*n_args = 2;
		break;
	}
	/* ktimer_getoverrun */
	case 239: {
		struct ktimer_getoverrun_args *p = params;
		iarg[0] = p->timerid; /* int */
		*n_args = 1;
		break;
	}
	/* nanosleep */
	case 240: {
		struct nanosleep_args *p = params;
		uarg[0] = (intptr_t) p->rqtp; /* const struct timespec * */
		uarg[1] = (intptr_t) p->rmtp; /* struct timespec * */
		*n_args = 2;
		break;
	}
	/* ntp_gettime */
	case 248: {
		struct ntp_gettime_args *p = params;
		uarg[0] = (intptr_t) p->ntvp; /* struct ntptimeval * */
		*n_args = 1;
		break;
	}
	/* minherit */
	case 250: {
		struct minherit_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* void * */
		uarg[1] = p->len; /* size_t */
		iarg[2] = p->inherit; /* int */
		*n_args = 3;
		break;
	}
	/* rfork */
	case 251: {
		struct rfork_args *p = params;
		iarg[0] = p->flags; /* int */
		*n_args = 1;
		break;
	}
	/* openbsd_poll */
	case 252: {
		struct openbsd_poll_args *p = params;
		uarg[0] = (intptr_t) p->fds; /* struct pollfd * */
		uarg[1] = p->nfds; /* u_int */
		iarg[2] = p->timeout; /* int */
		*n_args = 3;
		break;
	}
	/* issetugid */
	case 253: {
		*n_args = 0;
		break;
	}
	/* lchown */
	case 254: {
		struct lchown_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->uid; /* int */
		iarg[2] = p->gid; /* int */
		*n_args = 3;
		break;
	}
	/* aio_read */
	case 255: {
		struct aio_read_args *p = params;
		uarg[0] = (intptr_t) p->aiocbp; /* struct aiocb * */
		*n_args = 1;
		break;
	}
	/* aio_write */
	case 256: {
		struct aio_write_args *p = params;
		uarg[0] = (intptr_t) p->aiocbp; /* struct aiocb * */
		*n_args = 1;
		break;
	}
	/* lio_listio */
	case 257: {
		struct lio_listio_args *p = params;
		iarg[0] = p->mode; /* int */
		uarg[1] = (intptr_t) p->acb_list; /* struct aiocb *const * */
		iarg[2] = p->nent; /* int */
		uarg[3] = (intptr_t) p->sig; /* struct sigevent * */
		*n_args = 4;
		break;
	}
	/* getdents */
	case 272: {
		struct getdents_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->buf; /* char * */
		uarg[2] = p->count; /* size_t */
		*n_args = 3;
		break;
	}
	/* lchmod */
	case 274: {
		struct lchmod_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->mode; /* mode_t */
		*n_args = 2;
		break;
	}
	/* lchown */
	case 275: {
		struct lchown_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = p->uid; /* uid_t */
		iarg[2] = p->gid; /* gid_t */
		*n_args = 3;
		break;
	}
	/* lutimes */
	case 276: {
		struct lutimes_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->tptr; /* struct timeval * */
		*n_args = 2;
		break;
	}
	/* msync */
	case 277: {
		struct msync_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* void * */
		uarg[1] = p->len; /* size_t */
		iarg[2] = p->flags; /* int */
		*n_args = 3;
		break;
	}
	/* nstat */
	case 278: {
		struct nstat_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->ub; /* struct nstat * */
		*n_args = 2;
		break;
	}
	/* nfstat */
	case 279: {
		struct nfstat_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->sb; /* struct nstat * */
		*n_args = 2;
		break;
	}
	/* nlstat */
	case 280: {
		struct nlstat_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->ub; /* struct nstat * */
		*n_args = 2;
		break;
	}
	/* preadv */
	case 289: {
		struct preadv_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->iovp; /* struct iovec * */
		uarg[2] = p->iovcnt; /* u_int */
		iarg[3] = p->offset; /* off_t */
		*n_args = 4;
		break;
	}
	/* pwritev */
	case 290: {
		struct pwritev_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->iovp; /* struct iovec * */
		uarg[2] = p->iovcnt; /* u_int */
		iarg[3] = p->offset; /* off_t */
		*n_args = 4;
		break;
	}
	/* fhopen */
	case 298: {
		struct fhopen_args *p = params;
		uarg[0] = (intptr_t) p->u_fhp; /* const struct fhandle * */
		iarg[1] = p->flags; /* int */
		*n_args = 2;
		break;
	}
	/* fhstat */
	case 299: {
		struct fhstat_args *p = params;
		uarg[0] = (intptr_t) p->u_fhp; /* const struct fhandle * */
		uarg[1] = (intptr_t) p->sb; /* struct stat * */
		*n_args = 2;
		break;
	}
	/* modnext */
	case 300: {
		struct modnext_args *p = params;
		iarg[0] = p->modid; /* int */
		*n_args = 1;
		break;
	}
	/* modstat */
	case 301: {
		struct modstat_args *p = params;
		iarg[0] = p->modid; /* int */
		uarg[1] = (intptr_t) p->stat; /* struct module_stat * */
		*n_args = 2;
		break;
	}
	/* modfnext */
	case 302: {
		struct modfnext_args *p = params;
		iarg[0] = p->modid; /* int */
		*n_args = 1;
		break;
	}
	/* modfind */
	case 303: {
		struct modfind_args *p = params;
		uarg[0] = (intptr_t) p->name; /* const char * */
		*n_args = 1;
		break;
	}
	/* kldload */
	case 304: {
		struct kldload_args *p = params;
		uarg[0] = (intptr_t) p->file; /* const char * */
		*n_args = 1;
		break;
	}
	/* kldunload */
	case 305: {
		struct kldunload_args *p = params;
		iarg[0] = p->fileid; /* int */
		*n_args = 1;
		break;
	}
	/* kldfind */
	case 306: {
		struct kldfind_args *p = params;
		uarg[0] = (intptr_t) p->file; /* const char * */
		*n_args = 1;
		break;
	}
	/* kldnext */
	case 307: {
		struct kldnext_args *p = params;
		iarg[0] = p->fileid; /* int */
		*n_args = 1;
		break;
	}
	/* kldstat */
	case 308: {
		struct kldstat_args *p = params;
		iarg[0] = p->fileid; /* int */
		uarg[1] = (intptr_t) p->stat; /* struct kld_file_stat * */
		*n_args = 2;
		break;
	}
	/* kldfirstmod */
	case 309: {
		struct kldfirstmod_args *p = params;
		iarg[0] = p->fileid; /* int */
		*n_args = 1;
		break;
	}
	/* getsid */
	case 310: {
		struct getsid_args *p = params;
		iarg[0] = p->pid; /* pid_t */
		*n_args = 1;
		break;
	}
	/* setresuid */
	case 311: {
		struct setresuid_args *p = params;
		uarg[0] = p->ruid; /* uid_t */
		uarg[1] = p->euid; /* uid_t */
		uarg[2] = p->suid; /* uid_t */
		*n_args = 3;
		break;
	}
	/* setresgid */
	case 312: {
		struct setresgid_args *p = params;
		iarg[0] = p->rgid; /* gid_t */
		iarg[1] = p->egid; /* gid_t */
		iarg[2] = p->sgid; /* gid_t */
		*n_args = 3;
		break;
	}
	/* aio_return */
	case 314: {
		struct aio_return_args *p = params;
		uarg[0] = (intptr_t) p->aiocbp; /* struct aiocb * */
		*n_args = 1;
		break;
	}
	/* aio_suspend */
	case 315: {
		struct aio_suspend_args *p = params;
		uarg[0] = (intptr_t) p->aiocbp; /* struct aiocb *const * */
		iarg[1] = p->nent; /* int */
		uarg[2] = (intptr_t) p->timeout; /* const struct timespec * */
		*n_args = 3;
		break;
	}
	/* aio_cancel */
	case 316: {
		struct aio_cancel_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->aiocbp; /* struct aiocb * */
		*n_args = 2;
		break;
	}
	/* aio_error */
	case 317: {
		struct aio_error_args *p = params;
		uarg[0] = (intptr_t) p->aiocbp; /* struct aiocb * */
		*n_args = 1;
		break;
	}
	/* oaio_read */
	case 318: {
		struct oaio_read_args *p = params;
		uarg[0] = (intptr_t) p->aiocbp; /* struct oaiocb * */
		*n_args = 1;
		break;
	}
	/* oaio_write */
	case 319: {
		struct oaio_write_args *p = params;
		uarg[0] = (intptr_t) p->aiocbp; /* struct oaiocb * */
		*n_args = 1;
		break;
	}
	/* olio_listio */
	case 320: {
		struct olio_listio_args *p = params;
		iarg[0] = p->mode; /* int */
		uarg[1] = (intptr_t) p->acb_list; /* struct oaiocb *const * */
		iarg[2] = p->nent; /* int */
		uarg[3] = (intptr_t) p->sig; /* struct osigevent * */
		*n_args = 4;
		break;
	}
	/* yield */
	case 321: {
		*n_args = 0;
		break;
	}
	/* mlockall */
	case 324: {
		struct mlockall_args *p = params;
		iarg[0] = p->how; /* int */
		*n_args = 1;
		break;
	}
	/* munlockall */
	case 325: {
		*n_args = 0;
		break;
	}
	/* __getcwd */
	case 326: {
		struct __getcwd_args *p = params;
		uarg[0] = (intptr_t) p->buf; /* u_char * */
		uarg[1] = p->buflen; /* u_int */
		*n_args = 2;
		break;
	}
	/* sched_setparam */
	case 327: {
		struct sched_setparam_args *p = params;
		iarg[0] = p->pid; /* pid_t */
		uarg[1] = (intptr_t) p->param; /* const struct sched_param * */
		*n_args = 2;
		break;
	}
	/* sched_getparam */
	case 328: {
		struct sched_getparam_args *p = params;
		iarg[0] = p->pid; /* pid_t */
		uarg[1] = (intptr_t) p->param; /* struct sched_param * */
		*n_args = 2;
		break;
	}
	/* sched_setscheduler */
	case 329: {
		struct sched_setscheduler_args *p = params;
		iarg[0] = p->pid; /* pid_t */
		iarg[1] = p->policy; /* int */
		uarg[2] = (intptr_t) p->param; /* const struct sched_param * */
		*n_args = 3;
		break;
	}
	/* sched_getscheduler */
	case 330: {
		struct sched_getscheduler_args *p = params;
		iarg[0] = p->pid; /* pid_t */
		*n_args = 1;
		break;
	}
	/* sched_yield */
	case 331: {
		*n_args = 0;
		break;
	}
	/* sched_get_priority_max */
	case 332: {
		struct sched_get_priority_max_args *p = params;
		iarg[0] = p->policy; /* int */
		*n_args = 1;
		break;
	}
	/* sched_get_priority_min */
	case 333: {
		struct sched_get_priority_min_args *p = params;
		iarg[0] = p->policy; /* int */
		*n_args = 1;
		break;
	}
	/* sched_rr_get_interval */
	case 334: {
		struct sched_rr_get_interval_args *p = params;
		iarg[0] = p->pid; /* pid_t */
		uarg[1] = (intptr_t) p->interval; /* struct timespec * */
		*n_args = 2;
		break;
	}
	/* utrace */
	case 335: {
		struct utrace_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* const void * */
		uarg[1] = p->len; /* size_t */
		*n_args = 2;
		break;
	}
	/* kldsym */
	case 337: {
		struct kldsym_args *p = params;
		iarg[0] = p->fileid; /* int */
		iarg[1] = p->cmd; /* int */
		uarg[2] = (intptr_t) p->data; /* void * */
		*n_args = 3;
		break;
	}
	/* jail */
	case 338: {
		struct jail_args *p = params;
		uarg[0] = (intptr_t) p->jail; /* struct jail * */
		*n_args = 1;
		break;
	}
	/* sigprocmask */
	case 340: {
		struct sigprocmask_args *p = params;
		iarg[0] = p->how; /* int */
		uarg[1] = (intptr_t) p->set; /* const sigset_t * */
		uarg[2] = (intptr_t) p->oset; /* sigset_t * */
		*n_args = 3;
		break;
	}
	/* sigsuspend */
	case 341: {
		struct sigsuspend_args *p = params;
		uarg[0] = (intptr_t) p->sigmask; /* const sigset_t * */
		*n_args = 1;
		break;
	}
	/* sigpending */
	case 343: {
		struct sigpending_args *p = params;
		uarg[0] = (intptr_t) p->set; /* sigset_t * */
		*n_args = 1;
		break;
	}
	/* sigtimedwait */
	case 345: {
		struct sigtimedwait_args *p = params;
		uarg[0] = (intptr_t) p->set; /* const sigset_t * */
		uarg[1] = (intptr_t) p->info; /* siginfo_t * */
		uarg[2] = (intptr_t) p->timeout; /* const struct timespec * */
		*n_args = 3;
		break;
	}
	/* sigwaitinfo */
	case 346: {
		struct sigwaitinfo_args *p = params;
		uarg[0] = (intptr_t) p->set; /* const sigset_t * */
		uarg[1] = (intptr_t) p->info; /* siginfo_t * */
		*n_args = 2;
		break;
	}
	/* __acl_get_file */
	case 347: {
		struct __acl_get_file_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->type; /* acl_type_t */
		uarg[2] = (intptr_t) p->aclp; /* struct acl * */
		*n_args = 3;
		break;
	}
	/* __acl_set_file */
	case 348: {
		struct __acl_set_file_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->type; /* acl_type_t */
		uarg[2] = (intptr_t) p->aclp; /* struct acl * */
		*n_args = 3;
		break;
	}
	/* __acl_get_fd */
	case 349: {
		struct __acl_get_fd_args *p = params;
		iarg[0] = p->filedes; /* int */
		iarg[1] = p->type; /* acl_type_t */
		uarg[2] = (intptr_t) p->aclp; /* struct acl * */
		*n_args = 3;
		break;
	}
	/* __acl_set_fd */
	case 350: {
		struct __acl_set_fd_args *p = params;
		iarg[0] = p->filedes; /* int */
		iarg[1] = p->type; /* acl_type_t */
		uarg[2] = (intptr_t) p->aclp; /* struct acl * */
		*n_args = 3;
		break;
	}
	/* __acl_delete_file */
	case 351: {
		struct __acl_delete_file_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->type; /* acl_type_t */
		*n_args = 2;
		break;
	}
	/* __acl_delete_fd */
	case 352: {
		struct __acl_delete_fd_args *p = params;
		iarg[0] = p->filedes; /* int */
		iarg[1] = p->type; /* acl_type_t */
		*n_args = 2;
		break;
	}
	/* __acl_aclcheck_file */
	case 353: {
		struct __acl_aclcheck_file_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->type; /* acl_type_t */
		uarg[2] = (intptr_t) p->aclp; /* struct acl * */
		*n_args = 3;
		break;
	}
	/* __acl_aclcheck_fd */
	case 354: {
		struct __acl_aclcheck_fd_args *p = params;
		iarg[0] = p->filedes; /* int */
		iarg[1] = p->type; /* acl_type_t */
		uarg[2] = (intptr_t) p->aclp; /* struct acl * */
		*n_args = 3;
		break;
	}
	/* extattrctl */
	case 355: {
		struct extattrctl_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->cmd; /* int */
		uarg[2] = (intptr_t) p->filename; /* const char * */
		iarg[3] = p->attrnamespace; /* int */
		uarg[4] = (intptr_t) p->attrname; /* const char * */
		*n_args = 5;
		break;
	}
	/* extattr_set_file */
	case 356: {
		struct extattr_set_file_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->attrname; /* const char * */
		uarg[3] = (intptr_t) p->data; /* void * */
		uarg[4] = p->nbytes; /* size_t */
		*n_args = 5;
		break;
	}
	/* extattr_get_file */
	case 357: {
		struct extattr_get_file_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->attrname; /* const char * */
		uarg[3] = (intptr_t) p->data; /* void * */
		uarg[4] = p->nbytes; /* size_t */
		*n_args = 5;
		break;
	}
	/* extattr_delete_file */
	case 358: {
		struct extattr_delete_file_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->attrname; /* const char * */
		*n_args = 3;
		break;
	}
	/* aio_waitcomplete */
	case 359: {
		struct aio_waitcomplete_args *p = params;
		uarg[0] = (intptr_t) p->aiocbp; /* struct aiocb ** */
		uarg[1] = (intptr_t) p->timeout; /* struct timespec * */
		*n_args = 2;
		break;
	}
	/* getresuid */
	case 360: {
		struct getresuid_args *p = params;
		uarg[0] = (intptr_t) p->ruid; /* uid_t * */
		uarg[1] = (intptr_t) p->euid; /* uid_t * */
		uarg[2] = (intptr_t) p->suid; /* uid_t * */
		*n_args = 3;
		break;
	}
	/* getresgid */
	case 361: {
		struct getresgid_args *p = params;
		uarg[0] = (intptr_t) p->rgid; /* gid_t * */
		uarg[1] = (intptr_t) p->egid; /* gid_t * */
		uarg[2] = (intptr_t) p->sgid; /* gid_t * */
		*n_args = 3;
		break;
	}
	/* kqueue */
	case 362: {
		*n_args = 0;
		break;
	}
	/* kevent */
	case 363: {
		struct kevent_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->changelist; /* struct kevent * */
		iarg[2] = p->nchanges; /* int */
		uarg[3] = (intptr_t) p->eventlist; /* struct kevent * */
		iarg[4] = p->nevents; /* int */
		uarg[5] = (intptr_t) p->timeout; /* const struct timespec * */
		*n_args = 6;
		break;
	}
	/* lkmressys */
	case 370: {
		*n_args = 0;
		break;
	}
	/* extattr_set_fd */
	case 371: {
		struct extattr_set_fd_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->attrname; /* const char * */
		uarg[3] = (intptr_t) p->data; /* void * */
		uarg[4] = p->nbytes; /* size_t */
		*n_args = 5;
		break;
	}
	/* extattr_get_fd */
	case 372: {
		struct extattr_get_fd_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->attrname; /* const char * */
		uarg[3] = (intptr_t) p->data; /* void * */
		uarg[4] = p->nbytes; /* size_t */
		*n_args = 5;
		break;
	}
	/* extattr_delete_fd */
	case 373: {
		struct extattr_delete_fd_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->attrname; /* const char * */
		*n_args = 3;
		break;
	}
	/* __setugid */
	case 374: {
		struct __setugid_args *p = params;
		iarg[0] = p->flag; /* int */
		*n_args = 1;
		break;
	}
	/* nfsclnt */
	case 375: {
		struct nfsclnt_args *p = params;
		iarg[0] = p->flag; /* int */
		uarg[1] = (intptr_t) p->argp; /* caddr_t */
		*n_args = 2;
		break;
	}
	/* eaccess */
	case 376: {
		struct eaccess_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->flags; /* int */
		*n_args = 2;
		break;
	}
	/* nmount */
	case 378: {
		struct nmount_args *p = params;
		uarg[0] = (intptr_t) p->iovp; /* struct iovec * */
		uarg[1] = p->iovcnt; /* unsigned int */
		iarg[2] = p->flags; /* int */
		*n_args = 3;
		break;
	}
	/* kse_exit */
	case 379: {
		*n_args = 0;
		break;
	}
	/* kse_wakeup */
	case 380: {
		struct kse_wakeup_args *p = params;
		uarg[0] = (intptr_t) p->mbx; /* struct kse_mailbox * */
		*n_args = 1;
		break;
	}
	/* kse_create */
	case 381: {
		struct kse_create_args *p = params;
		uarg[0] = (intptr_t) p->mbx; /* struct kse_mailbox * */
		iarg[1] = p->newgroup; /* int */
		*n_args = 2;
		break;
	}
	/* kse_thr_interrupt */
	case 382: {
		struct kse_thr_interrupt_args *p = params;
		uarg[0] = (intptr_t) p->tmbx; /* struct kse_thr_mailbox * */
		iarg[1] = p->cmd; /* int */
		iarg[2] = p->data; /* long */
		*n_args = 3;
		break;
	}
	/* kse_release */
	case 383: {
		struct kse_release_args *p = params;
		uarg[0] = (intptr_t) p->timeout; /* struct timespec * */
		*n_args = 1;
		break;
	}
	/* __mac_get_proc */
	case 384: {
		struct __mac_get_proc_args *p = params;
		uarg[0] = (intptr_t) p->mac_p; /* struct mac * */
		*n_args = 1;
		break;
	}
	/* __mac_set_proc */
	case 385: {
		struct __mac_set_proc_args *p = params;
		uarg[0] = (intptr_t) p->mac_p; /* struct mac * */
		*n_args = 1;
		break;
	}
	/* __mac_get_fd */
	case 386: {
		struct __mac_get_fd_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->mac_p; /* struct mac * */
		*n_args = 2;
		break;
	}
	/* __mac_get_file */
	case 387: {
		struct __mac_get_file_args *p = params;
		uarg[0] = (intptr_t) p->path_p; /* const char * */
		uarg[1] = (intptr_t) p->mac_p; /* struct mac * */
		*n_args = 2;
		break;
	}
	/* __mac_set_fd */
	case 388: {
		struct __mac_set_fd_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->mac_p; /* struct mac * */
		*n_args = 2;
		break;
	}
	/* __mac_set_file */
	case 389: {
		struct __mac_set_file_args *p = params;
		uarg[0] = (intptr_t) p->path_p; /* const char * */
		uarg[1] = (intptr_t) p->mac_p; /* struct mac * */
		*n_args = 2;
		break;
	}
	/* kenv */
	case 390: {
		struct kenv_args *p = params;
		iarg[0] = p->what; /* int */
		uarg[1] = (intptr_t) p->name; /* const char * */
		uarg[2] = (intptr_t) p->value; /* char * */
		iarg[3] = p->len; /* int */
		*n_args = 4;
		break;
	}
	/* lchflags */
	case 391: {
		struct lchflags_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->flags; /* int */
		*n_args = 2;
		break;
	}
	/* uuidgen */
	case 392: {
		struct uuidgen_args *p = params;
		uarg[0] = (intptr_t) p->store; /* struct uuid * */
		iarg[1] = p->count; /* int */
		*n_args = 2;
		break;
	}
	/* sendfile */
	case 393: {
		struct sendfile_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->s; /* int */
		iarg[2] = p->offset; /* off_t */
		uarg[3] = p->nbytes; /* size_t */
		uarg[4] = (intptr_t) p->hdtr; /* struct sf_hdtr * */
		uarg[5] = (intptr_t) p->sbytes; /* off_t * */
		iarg[6] = p->flags; /* int */
		*n_args = 7;
		break;
	}
	/* mac_syscall */
	case 394: {
		struct mac_syscall_args *p = params;
		uarg[0] = (intptr_t) p->policy; /* const char * */
		iarg[1] = p->call; /* int */
		uarg[2] = (intptr_t) p->arg; /* void * */
		*n_args = 3;
		break;
	}
	/* getfsstat */
	case 395: {
		struct getfsstat_args *p = params;
		uarg[0] = (intptr_t) p->buf; /* struct statfs * */
		iarg[1] = p->bufsize; /* long */
		iarg[2] = p->flags; /* int */
		*n_args = 3;
		break;
	}
	/* statfs */
	case 396: {
		struct statfs_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		uarg[1] = (intptr_t) p->buf; /* struct statfs * */
		*n_args = 2;
		break;
	}
	/* fstatfs */
	case 397: {
		struct fstatfs_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->buf; /* struct statfs * */
		*n_args = 2;
		break;
	}
	/* fhstatfs */
	case 398: {
		struct fhstatfs_args *p = params;
		uarg[0] = (intptr_t) p->u_fhp; /* const struct fhandle * */
		uarg[1] = (intptr_t) p->buf; /* struct statfs * */
		*n_args = 2;
		break;
	}
	/* ksem_close */
	case 400: {
		struct ksem_close_args *p = params;
		iarg[0] = p->id; /* semid_t */
		*n_args = 1;
		break;
	}
	/* ksem_post */
	case 401: {
		struct ksem_post_args *p = params;
		iarg[0] = p->id; /* semid_t */
		*n_args = 1;
		break;
	}
	/* ksem_wait */
	case 402: {
		struct ksem_wait_args *p = params;
		iarg[0] = p->id; /* semid_t */
		*n_args = 1;
		break;
	}
	/* ksem_trywait */
	case 403: {
		struct ksem_trywait_args *p = params;
		iarg[0] = p->id; /* semid_t */
		*n_args = 1;
		break;
	}
	/* ksem_init */
	case 404: {
		struct ksem_init_args *p = params;
		uarg[0] = (intptr_t) p->idp; /* semid_t * */
		uarg[1] = p->value; /* unsigned int */
		*n_args = 2;
		break;
	}
	/* ksem_open */
	case 405: {
		struct ksem_open_args *p = params;
		uarg[0] = (intptr_t) p->idp; /* semid_t * */
		uarg[1] = (intptr_t) p->name; /* const char * */
		iarg[2] = p->oflag; /* int */
		iarg[3] = p->mode; /* mode_t */
		uarg[4] = p->value; /* unsigned int */
		*n_args = 5;
		break;
	}
	/* ksem_unlink */
	case 406: {
		struct ksem_unlink_args *p = params;
		uarg[0] = (intptr_t) p->name; /* const char * */
		*n_args = 1;
		break;
	}
	/* ksem_getvalue */
	case 407: {
		struct ksem_getvalue_args *p = params;
		iarg[0] = p->id; /* semid_t */
		uarg[1] = (intptr_t) p->val; /* int * */
		*n_args = 2;
		break;
	}
	/* ksem_destroy */
	case 408: {
		struct ksem_destroy_args *p = params;
		iarg[0] = p->id; /* semid_t */
		*n_args = 1;
		break;
	}
	/* __mac_get_pid */
	case 409: {
		struct __mac_get_pid_args *p = params;
		iarg[0] = p->pid; /* pid_t */
		uarg[1] = (intptr_t) p->mac_p; /* struct mac * */
		*n_args = 2;
		break;
	}
	/* __mac_get_link */
	case 410: {
		struct __mac_get_link_args *p = params;
		uarg[0] = (intptr_t) p->path_p; /* const char * */
		uarg[1] = (intptr_t) p->mac_p; /* struct mac * */
		*n_args = 2;
		break;
	}
	/* __mac_set_link */
	case 411: {
		struct __mac_set_link_args *p = params;
		uarg[0] = (intptr_t) p->path_p; /* const char * */
		uarg[1] = (intptr_t) p->mac_p; /* struct mac * */
		*n_args = 2;
		break;
	}
	/* extattr_set_link */
	case 412: {
		struct extattr_set_link_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->attrname; /* const char * */
		uarg[3] = (intptr_t) p->data; /* void * */
		uarg[4] = p->nbytes; /* size_t */
		*n_args = 5;
		break;
	}
	/* extattr_get_link */
	case 413: {
		struct extattr_get_link_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->attrname; /* const char * */
		uarg[3] = (intptr_t) p->data; /* void * */
		uarg[4] = p->nbytes; /* size_t */
		*n_args = 5;
		break;
	}
	/* extattr_delete_link */
	case 414: {
		struct extattr_delete_link_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->attrname; /* const char * */
		*n_args = 3;
		break;
	}
	/* __mac_execve */
	case 415: {
		struct __mac_execve_args *p = params;
		uarg[0] = (intptr_t) p->fname; /* char * */
		uarg[1] = (intptr_t) p->argv; /* char ** */
		uarg[2] = (intptr_t) p->envv; /* char ** */
		uarg[3] = (intptr_t) p->mac_p; /* struct mac * */
		*n_args = 4;
		break;
	}
	/* sigaction */
	case 416: {
		struct sigaction_args *p = params;
		iarg[0] = p->sig; /* int */
		uarg[1] = (intptr_t) p->act; /* const struct sigaction * */
		uarg[2] = (intptr_t) p->oact; /* struct sigaction * */
		*n_args = 3;
		break;
	}
	/* sigreturn */
	case 417: {
		struct sigreturn_args *p = params;
		uarg[0] = (intptr_t) p->sigcntxp; /* const struct __ucontext * */
		*n_args = 1;
		break;
	}
	/* getcontext */
	case 421: {
		struct getcontext_args *p = params;
		uarg[0] = (intptr_t) p->ucp; /* struct __ucontext * */
		*n_args = 1;
		break;
	}
	/* setcontext */
	case 422: {
		struct setcontext_args *p = params;
		uarg[0] = (intptr_t) p->ucp; /* const struct __ucontext * */
		*n_args = 1;
		break;
	}
	/* swapcontext */
	case 423: {
		struct swapcontext_args *p = params;
		uarg[0] = (intptr_t) p->oucp; /* struct __ucontext * */
		uarg[1] = (intptr_t) p->ucp; /* const struct __ucontext * */
		*n_args = 2;
		break;
	}
	/* swapoff */
	case 424: {
		struct swapoff_args *p = params;
		uarg[0] = (intptr_t) p->name; /* const char * */
		*n_args = 1;
		break;
	}
	/* __acl_get_link */
	case 425: {
		struct __acl_get_link_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->type; /* acl_type_t */
		uarg[2] = (intptr_t) p->aclp; /* struct acl * */
		*n_args = 3;
		break;
	}
	/* __acl_set_link */
	case 426: {
		struct __acl_set_link_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->type; /* acl_type_t */
		uarg[2] = (intptr_t) p->aclp; /* struct acl * */
		*n_args = 3;
		break;
	}
	/* __acl_delete_link */
	case 427: {
		struct __acl_delete_link_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->type; /* acl_type_t */
		*n_args = 2;
		break;
	}
	/* __acl_aclcheck_link */
	case 428: {
		struct __acl_aclcheck_link_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->type; /* acl_type_t */
		uarg[2] = (intptr_t) p->aclp; /* struct acl * */
		*n_args = 3;
		break;
	}
	/* sigwait */
	case 429: {
		struct sigwait_args *p = params;
		uarg[0] = (intptr_t) p->set; /* const sigset_t * */
		uarg[1] = (intptr_t) p->sig; /* int * */
		*n_args = 2;
		break;
	}
	/* thr_create */
	case 430: {
		struct thr_create_args *p = params;
		uarg[0] = (intptr_t) p->ctx; /* ucontext_t * */
		uarg[1] = (intptr_t) p->id; /* long * */
		iarg[2] = p->flags; /* int */
		*n_args = 3;
		break;
	}
	/* thr_exit */
	case 431: {
		struct thr_exit_args *p = params;
		uarg[0] = (intptr_t) p->state; /* long * */
		*n_args = 1;
		break;
	}
	/* thr_self */
	case 432: {
		struct thr_self_args *p = params;
		uarg[0] = (intptr_t) p->id; /* long * */
		*n_args = 1;
		break;
	}
	/* thr_kill */
	case 433: {
		struct thr_kill_args *p = params;
		iarg[0] = p->id; /* long */
		iarg[1] = p->sig; /* int */
		*n_args = 2;
		break;
	}
	/* _umtx_lock */
	case 434: {
		struct _umtx_lock_args *p = params;
		uarg[0] = (intptr_t) p->umtx; /* struct umtx * */
		*n_args = 1;
		break;
	}
	/* _umtx_unlock */
	case 435: {
		struct _umtx_unlock_args *p = params;
		uarg[0] = (intptr_t) p->umtx; /* struct umtx * */
		*n_args = 1;
		break;
	}
	/* jail_attach */
	case 436: {
		struct jail_attach_args *p = params;
		iarg[0] = p->jid; /* int */
		*n_args = 1;
		break;
	}
	/* extattr_list_fd */
	case 437: {
		struct extattr_list_fd_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->data; /* void * */
		uarg[3] = p->nbytes; /* size_t */
		*n_args = 4;
		break;
	}
	/* extattr_list_file */
	case 438: {
		struct extattr_list_file_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->data; /* void * */
		uarg[3] = p->nbytes; /* size_t */
		*n_args = 4;
		break;
	}
	/* extattr_list_link */
	case 439: {
		struct extattr_list_link_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->attrnamespace; /* int */
		uarg[2] = (intptr_t) p->data; /* void * */
		uarg[3] = p->nbytes; /* size_t */
		*n_args = 4;
		break;
	}
	/* kse_switchin */
	case 440: {
		struct kse_switchin_args *p = params;
		uarg[0] = (intptr_t) p->tmbx; /* struct kse_thr_mailbox * */
		iarg[1] = p->flags; /* int */
		*n_args = 2;
		break;
	}
	/* ksem_timedwait */
	case 441: {
		struct ksem_timedwait_args *p = params;
		iarg[0] = p->id; /* semid_t */
		uarg[1] = (intptr_t) p->abstime; /* const struct timespec * */
		*n_args = 2;
		break;
	}
	/* thr_suspend */
	case 442: {
		struct thr_suspend_args *p = params;
		uarg[0] = (intptr_t) p->timeout; /* const struct timespec * */
		*n_args = 1;
		break;
	}
	/* thr_wake */
	case 443: {
		struct thr_wake_args *p = params;
		iarg[0] = p->id; /* long */
		*n_args = 1;
		break;
	}
	/* kldunloadf */
	case 444: {
		struct kldunloadf_args *p = params;
		iarg[0] = p->fileid; /* int */
		iarg[1] = p->flags; /* int */
		*n_args = 2;
		break;
	}
	/* audit */
	case 445: {
		struct audit_args *p = params;
		uarg[0] = (intptr_t) p->record; /* const void * */
		uarg[1] = p->length; /* u_int */
		*n_args = 2;
		break;
	}
	/* auditon */
	case 446: {
		struct auditon_args *p = params;
		iarg[0] = p->cmd; /* int */
		uarg[1] = (intptr_t) p->data; /* void * */
		uarg[2] = p->length; /* u_int */
		*n_args = 3;
		break;
	}
	/* getauid */
	case 447: {
		struct getauid_args *p = params;
		uarg[0] = (intptr_t) p->auid; /* uid_t * */
		*n_args = 1;
		break;
	}
	/* setauid */
	case 448: {
		struct setauid_args *p = params;
		uarg[0] = (intptr_t) p->auid; /* uid_t * */
		*n_args = 1;
		break;
	}
	/* getaudit */
	case 449: {
		struct getaudit_args *p = params;
		uarg[0] = (intptr_t) p->auditinfo; /* struct auditinfo * */
		*n_args = 1;
		break;
	}
	/* setaudit */
	case 450: {
		struct setaudit_args *p = params;
		uarg[0] = (intptr_t) p->auditinfo; /* struct auditinfo * */
		*n_args = 1;
		break;
	}
	/* getaudit_addr */
	case 451: {
		struct getaudit_addr_args *p = params;
		uarg[0] = (intptr_t) p->auditinfo_addr; /* struct auditinfo_addr * */
		uarg[1] = p->length; /* u_int */
		*n_args = 2;
		break;
	}
	/* setaudit_addr */
	case 452: {
		struct setaudit_addr_args *p = params;
		uarg[0] = (intptr_t) p->auditinfo_addr; /* struct auditinfo_addr * */
		uarg[1] = p->length; /* u_int */
		*n_args = 2;
		break;
	}
	/* auditctl */
	case 453: {
		struct auditctl_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		*n_args = 1;
		break;
	}
	/* _umtx_op */
	case 454: {
		struct _umtx_op_args *p = params;
		uarg[0] = (intptr_t) p->obj; /* void * */
		iarg[1] = p->op; /* int */
		uarg[2] = p->val; /* u_long */
		uarg[3] = (intptr_t) p->uaddr1; /* void * */
		uarg[4] = (intptr_t) p->uaddr2; /* void * */
		*n_args = 5;
		break;
	}
	/* thr_new */
	case 455: {
		struct thr_new_args *p = params;
		uarg[0] = (intptr_t) p->param; /* struct thr_param * */
		iarg[1] = p->param_size; /* int */
		*n_args = 2;
		break;
	}
	/* sigqueue */
	case 456: {
		struct sigqueue_args *p = params;
		iarg[0] = p->pid; /* pid_t */
		iarg[1] = p->signum; /* int */
		uarg[2] = (intptr_t) p->value; /* void * */
		*n_args = 3;
		break;
	}
	/* kmq_open */
	case 457: {
		struct kmq_open_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		iarg[1] = p->flags; /* int */
		iarg[2] = p->mode; /* mode_t */
		uarg[3] = (intptr_t) p->attr; /* const struct mq_attr * */
		*n_args = 4;
		break;
	}
	/* kmq_setattr */
	case 458: {
		struct kmq_setattr_args *p = params;
		iarg[0] = p->mqd; /* int */
		uarg[1] = (intptr_t) p->attr; /* const struct mq_attr * */
		uarg[2] = (intptr_t) p->oattr; /* struct mq_attr * */
		*n_args = 3;
		break;
	}
	/* kmq_timedreceive */
	case 459: {
		struct kmq_timedreceive_args *p = params;
		iarg[0] = p->mqd; /* int */
		uarg[1] = (intptr_t) p->msg_ptr; /* char * */
		uarg[2] = p->msg_len; /* size_t */
		uarg[3] = (intptr_t) p->msg_prio; /* unsigned * */
		uarg[4] = (intptr_t) p->abs_timeout; /* const struct timespec * */
		*n_args = 5;
		break;
	}
	/* kmq_timedsend */
	case 460: {
		struct kmq_timedsend_args *p = params;
		iarg[0] = p->mqd; /* int */
		uarg[1] = (intptr_t) p->msg_ptr; /* const char * */
		uarg[2] = p->msg_len; /* size_t */
		uarg[3] = p->msg_prio; /* unsigned */
		uarg[4] = (intptr_t) p->abs_timeout; /* const struct timespec * */
		*n_args = 5;
		break;
	}
	/* kmq_notify */
	case 461: {
		struct kmq_notify_args *p = params;
		iarg[0] = p->mqd; /* int */
		uarg[1] = (intptr_t) p->sigev; /* const struct sigevent * */
		*n_args = 2;
		break;
	}
	/* kmq_unlink */
	case 462: {
		struct kmq_unlink_args *p = params;
		uarg[0] = (intptr_t) p->path; /* const char * */
		*n_args = 1;
		break;
	}
	/* abort2 */
	case 463: {
		struct abort2_args *p = params;
		uarg[0] = (intptr_t) p->why; /* const char * */
		iarg[1] = p->nargs; /* int */
		uarg[2] = (intptr_t) p->args; /* void ** */
		*n_args = 3;
		break;
	}
	/* thr_set_name */
	case 464: {
		struct thr_set_name_args *p = params;
		iarg[0] = p->id; /* long */
		uarg[1] = (intptr_t) p->name; /* const char * */
		*n_args = 2;
		break;
	}
	/* aio_fsync */
	case 465: {
		struct aio_fsync_args *p = params;
		iarg[0] = p->op; /* int */
		uarg[1] = (intptr_t) p->aiocbp; /* struct aiocb * */
		*n_args = 2;
		break;
	}
	/* rtprio_thread */
	case 466: {
		struct rtprio_thread_args *p = params;
		iarg[0] = p->function; /* int */
		iarg[1] = p->lwpid; /* lwpid_t */
		uarg[2] = (intptr_t) p->rtp; /* struct rtprio * */
		*n_args = 3;
		break;
	}
	/* sctp_peeloff */
	case 471: {
		struct sctp_peeloff_args *p = params;
		iarg[0] = p->sd; /* int */
		uarg[1] = p->name; /* uint32_t */
		*n_args = 2;
		break;
	}
	/* sctp_generic_sendmsg */
	case 472: {
		struct sctp_generic_sendmsg_args *p = params;
		iarg[0] = p->sd; /* int */
		uarg[1] = (intptr_t) p->msg; /* caddr_t */
		iarg[2] = p->mlen; /* int */
		uarg[3] = (intptr_t) p->to; /* caddr_t */
		iarg[4] = p->tolen; /* __socklen_t */
		uarg[5] = (intptr_t) p->sinfo; /* struct sctp_sndrcvinfo * */
		iarg[6] = p->flags; /* int */
		*n_args = 7;
		break;
	}
	/* sctp_generic_sendmsg_iov */
	case 473: {
		struct sctp_generic_sendmsg_iov_args *p = params;
		iarg[0] = p->sd; /* int */
		uarg[1] = (intptr_t) p->iov; /* struct iovec * */
		iarg[2] = p->iovlen; /* int */
		uarg[3] = (intptr_t) p->to; /* caddr_t */
		iarg[4] = p->tolen; /* __socklen_t */
		uarg[5] = (intptr_t) p->sinfo; /* struct sctp_sndrcvinfo * */
		iarg[6] = p->flags; /* int */
		*n_args = 7;
		break;
	}
	/* sctp_generic_recvmsg */
	case 474: {
		struct sctp_generic_recvmsg_args *p = params;
		iarg[0] = p->sd; /* int */
		uarg[1] = (intptr_t) p->iov; /* struct iovec * */
		iarg[2] = p->iovlen; /* int */
		uarg[3] = (intptr_t) p->from; /* struct sockaddr * */
		uarg[4] = (intptr_t) p->fromlenaddr; /* __socklen_t * */
		uarg[5] = (intptr_t) p->sinfo; /* struct sctp_sndrcvinfo * */
		uarg[6] = (intptr_t) p->msg_flags; /* int * */
		*n_args = 7;
		break;
	}
	/* pread */
	case 475: {
		struct pread_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->buf; /* void * */
		uarg[2] = p->nbyte; /* size_t */
		iarg[3] = p->offset; /* off_t */
		*n_args = 4;
		break;
	}
	/* pwrite */
	case 476: {
		struct pwrite_args *p = params;
		iarg[0] = p->fd; /* int */
		uarg[1] = (intptr_t) p->buf; /* const void * */
		uarg[2] = p->nbyte; /* size_t */
		iarg[3] = p->offset; /* off_t */
		*n_args = 4;
		break;
	}
	/* mmap */
	case 477: {
		struct mmap_args *p = params;
		uarg[0] = (intptr_t) p->addr; /* caddr_t */
		uarg[1] = p->len; /* size_t */
		iarg[2] = p->prot; /* int */
		iarg[3] = p->flags; /* int */
		iarg[4] = p->fd; /* int */
		iarg[5] = p->pos; /* off_t */
		*n_args = 6;
		break;
	}
	/* lseek */
	case 478: {
		struct lseek_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->offset; /* off_t */
		iarg[2] = p->whence; /* int */
		*n_args = 3;
		break;
	}
	/* truncate */
	case 479: {
		struct truncate_args *p = params;
		uarg[0] = (intptr_t) p->path; /* char * */
		iarg[1] = p->length; /* off_t */
		*n_args = 2;
		break;
	}
	/* ftruncate */
	case 480: {
		struct ftruncate_args *p = params;
		iarg[0] = p->fd; /* int */
		iarg[1] = p->length; /* off_t */
		*n_args = 2;
		break;
	}
	/* thr_kill2 */
	case 481: {
		struct thr_kill2_args *p = params;
		iarg[0] = p->pid; /* pid_t */
		iarg[1] = p->id; /* long */
		iarg[2] = p->sig; /* int */
		*n_args = 3;
		break;
	}
	default:
		*n_args = 0;
		break;
	};
}
