\ pfex.4th
\
\ Annotated example of using the polynomial fitting routine
\ under kforth.
\
\ K. Myneni, 5-10-2000
\
\ Requires:
\
\	matrix.4th
\	polyfit.4th
\
\ Revised: 01-01-2002  cleaned up code  KM

\ First load the necessary source files

include matrix
include polyfit


\ Now create the x and y matrices (floating pt) to hold
\   the data to be fitted.

10 constant NP  ( the number of points we will fit)

NP 1 fmatrix x
NP 1 fmatrix y

\ Let's manually put in NP (10) values into the x and y arrays now.
\   I will use the data for y = x^2

0e  1e  2e  3e  4e  5e  6e  7e  8e  9e  NP 1 x fcol!
0e  1e  4e  9e 16e 25e 36e 49e 64e 81e  NP 1 y fcol!

\ You can verify that the x and y matrices have the correct
\   data in them by printing them out, e.g.
\
\	x fmat.
\	y fmat.


\ We also need an array to hold the fitted polynomial coefficients.

4 1 fmatrix coeffs


\ Now fit the data to a 2nd order polynomial, and print 
\   chi-square and the coefficients

x y coeffs 2 polfit

." Chi-square = " f. cr
." The coefficients are: " cr   coeffs fmat.


