\ mouse.4th
\
\ mouse interface for kForth under Linux
\
\ Requires gpm to be run in the console under which the
\   Forth application is running. As root user, type:
\
\	/usr/bin/gpm-root
\	/etc/init.d/gpm start
\
\ The paths for gpm-root and gpm may be different on your
\ system.
\
\ Krishna Myneni, 2002-11-10
\
\ Notes:
\
\ 1.	MKEY can also be used to receive extended key codes,
\       such as Fn, Alt x keys.
\
\ 2.    A mouse button release is a separate event from a
\       button press. Therefore mouse events require two
\       successive MKEY calls to process the input completely.
\
\ 3.	Tested under gforth and pfe.
\

create key-data 8 allot

: mouse.col  ( -- n | last column for mouse returned by gpm)
    key-data 4 + c@ 32 - ;

: mouse.row  ( -- n | last row for mouse )
    key-data 5 + c@ 32 - ;

: mouse.buttons ( -- n | button state for mouse)
    \ 0 = left down, 1 = both down, 2 = right down, 3 = release
    key-data 3 + c@ 32 - ;  

: MKEY ( -- u flag | wait for keyboard or mouse event )
       \ flag is true for a mouse event.
       \ u is the number of bytes returned by the key/mouse event.
       begin key? until
       key-data begin key? while dup key swap c! 1+ repeat
       key-data - dup 6 = 
       if key-data c@ 27 = key-data 1+ c@ 91 = and else false then ;
 
       
	 
	 
	   
