\ headlines.4th
\
\ Search selected web pages for text on an item of interest
\
\ Copyright (c) 2002 Krishna Myneni
\ Creative Consulting for Research and Education
\
\ Requires:
\
\	lynx and grep utilities
\	strings.4th ( or suitable definitions of STRCAT and SCAN )
\ 
\ Revisions:
\	2002-08-15  created
\ 
include strings.4th  ( for kForth )

create news_urls 512 allot      news_urls 512 blank
create url 256 allot
create url_page 256 allot
create search_word 64 allot

s" www.cnn.com|www.cbsnews.com|www.abcnews.com|www.nbcnews.com|"  
news_urls swap cmove

\ Use a definition of SHELL appropriate to your system

: shell  \ c-addr u -- n | execute a shell command in kForth
	strpck system ; 

\ pfe shell command
\ : shell  system ; \ c-addr u -- n | execute a shell command in PFE

\ gforth shell command
\ : shell  system  $? ; \ c-addr u -- n | execute a shell command in gforth

\ iforth shell command
\ : shell  system  RETURNCODE @ ;  \ c-addr u -- n | shell command in iForth


: pack ( a u a2 -- | copy string to counted string at a2)
	2DUP C! 1+ SWAP CMOVE ;	

: search-headlines ( -- )
	bl word count search_word pack
	news_urls
	begin
	  dup dup news_urls - 512 swap - [char] | scan  
	while 
	  over - 2dup + 1+ -rot
	  url pack
	  cr url count type cr
	  url count s" .out" strcat url_page pack 
	  s" lynx -dump " url count strcat s"  > " strcat
	  url_page count strcat
	  \ 2dup type cr  \ show the lynx command 
	  shell drop
	  s" grep -i " search_word count strcat s"  " strcat
	  url_page count strcat
	  \ 2dup type cr  \ show the grep command
	  shell drop
	  cr
	repeat 
	2drop ;

	  
	
	  