/*********************************************************************
 * $Id: gui_thread.h,v 1.4 2000/12/02 20:40:30 orjana Exp $
 * Filename:      gui_thread.h
 * Status:        Experimental, do not distribute.
 * Author:        rjan Nygaard Austvold <austvold@acm.org>
 * Created at:    Mon Nov 24 20:52:12 2000
 * Modified at:   Sat Dec  2 21:13:33 2000
 * Modified by:   rjan Nygaard Austvold <austvold@acm.org>
 *                
 * Copyright (c) 2000 rjan Nygaard Austvold, All Rights Reserved.
 *                
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * Revision History:
 *
 *   01-Dec-00 15:22:49   rjan Nygaard Austvold <austvold@acm.org>
 *     Added prototype set_window_icon().
 *
 ********************************************************************/

#ifndef GUI_THREAD_H
#define GUI_THREAD_H 1

#include "common.h"
#include "properties.h"

#define HORIZONTAL 0
#define VERTICAL   1

/* macro that simplifies what have to be written to update
   each key frame & image that has changed state */
#define UPDATE_IMAGE_STATE(KEY, VAR, ON, OFF)				\
{									\
  VAR = VAR ^ 1;							\
  gtk_frame_set_shadow_type (GTK_FRAME (frame[KEY]),			\
			     (VAR) ? GTK_SHADOW_IN : GTK_SHADOW_OUT);	\
  gtk_container_remove (GTK_CONTAINER(frame[KEY]),			\
			pixmap[key[KEY]]);				\
  gtk_widget_hide (pixmap[key[KEY]]);					\
  key[KEY] = (VAR) ? ON : OFF;						\
  gtk_container_add (GTK_CONTAINER (frame[KEY]), pixmap[key[KEY]]);	\
  gtk_widget_show (pixmap[key[KEY]]);					\
}

void gui_thread (void);

GtkWidget *create_applet (void);

void set_window_icon (void);

void update_tooltip (void);

void reshape_applet (gboolean reload_images);

void scale_pixmaps (int w, int h);

void led_pipe_callback (gpointer data, int fd, GdkInputCondition cond);

gboolean room_for_optimization (int orient);

void rebox_applet (int orient);

void applet_change_orient (AppletWidget *widget,
			   PanelOrientType orient, gpointer data);
/* #ifdef HAVE_PANEL_PIXEL_SIZE */
void applet_change_pixel_size (AppletWidget *widget, gint size, gpointer data);
/* #endif */

gint applet_save_session (AppletWidget *widget,
			  const char *privcfgpath, const char *globcfgpath);

void applet_tooltip_state (AppletWidget *widget, gint state, gpointer data);

void applet_destroy (AppletWidget *widget, gpointer data);

void callback_help (AppletWidget *applet, gpointer data);

void callback_about (AppletWidget *applet, gpointer data);

#endif
