/***************************************************************************
                          popup.cpp  -  description
                             -------------------
    begin                : Tue Jul 17 2001
    copyright            : (C) 2001 by Aurelien Jarno
    email                : aurelien@aurel32.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// includes files for Qt
#include <qpainter.h>
#include <qstring.h>

// includes files for KDE
#include <kwin.h>

// application specific includes
#include "popup.h"
#include "popup.moc"

PopUp::PopUp(QWidget *parent, const char *name) : QWidget(parent,name)
{
  KWin::setType(winId(), NET::Override);
  KWin::setState(winId(), NET::Sticky | NET::SkipTaskbar | NET::StaysOnTop);

  resize(220, 60);

  relX = 0;
  relY = 0;

  isDragged = FALSE;
}

PopUp::~PopUp()
{
}

void PopUp::setText(const QString text)
{
  if (popupText != text)
  {
    popupText = text;
    repaint();
  }
}

void PopUp::paintEvent(QPaintEvent *Event)
{
  Event = (QPaintEvent *) 0;
  QPainter p(this);

  p.fillRect(0, 0, 220, 60, QBrush(QColor((isDragged) ? QColor(0, 0, 255) : QColor(0, 0, 100))));
  p.fillRect(2, 2, 216, 56, QBrush(QColor(254, 254, 220)));

  p.setFont(QFont("courier new", 12));
  p.setPen(QColor(0, 0, 0));
  p.drawText(10, 5, 200, 50, AlignLeft | AlignVCenter, popupText);
}

void PopUp::mousePressEvent(QMouseEvent *Event)
{
  if(Event->button() == RightButton) emit clicked();
  else
  {
    isDragged = TRUE;
    relX = Event->x();
    relY = Event->y();
    repaint();
  }
}

void PopUp::mouseReleaseEvent(QMouseEvent *Event)
{
  Event = (QMouseEvent *) 0;
  isDragged = FALSE;
  repaint();
  emit savePos();
}

void PopUp::mouseMoveEvent(QMouseEvent *Event)
{
  move(Event->globalX() - relX, Event->globalY() - relY);
}
