import string
import SCons.Scanner
def DScan(fs=SCons.Node.FS.default_fs):
    """ """
    ds=DScanner(name="DScan",
                  suffixes='$DSUFFIXES',
                  path_variable='DPATH',
                  regex='import\s+([^\;]*)\;',
                  fs=fs)
    return ds
class DScanner(SCons.Scanner.Classic):
    def find_include(self, include, source_dir, path):
        inc=string.replace(include, '.', '/')
        i=SCons.Node.FS.find_file(inc + '.d',
                                    (source_dir,) + path,
                                    self.fs.File)
        return i, include
