/***************************************************************************
 *   Copyright (C) 2005 Thomas Nagy                                        *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qframe.h>
#include <qpixmap.h>
#include <qevent.h>

#include <kpushbutton.h>
#include <kiconloader.h>
#include <kglobal.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <kdebug.h>

#include "DDataItem.h"
#include "TextProperties.h"

TextProperties::TextProperties(QWidget *parent, const char *name) : 
    TextProperties_base(parent, name)
{
    m_lastitem = NULL;
    textedit->setTextFormat( RichText );

    boldbt->setPixmap( BarIcon("text_bold", KGlobal::instance()) );
    italicbt->setPixmap( BarIcon("text_italic", KGlobal::instance()) );
    underlinebt->setPixmap( BarIcon("text_under", KGlobal::instance()) );

    connect(summaryedit, SIGNAL(textChanged(const QString&)), this, SLOT(updateItem()));
    connect(textedit, SIGNAL(textChanged()), this, SLOT(updateItem()));
}

TextProperties::~TextProperties()
{
}

void TextProperties::setCurrentItem(DDataItem* item)
{
    disconnect(summaryedit, SIGNAL(textChanged(const QString&)), this, SLOT(updateItem()));
    disconnect(textedit, SIGNAL(textChanged()), this, SLOT(updateItem()));

    if (item != m_lastitem)
    {
	summaryedit->clear();
	textedit->clear();
    }

    m_lastitem = item;

    if (item)
    {
	summaryedit->setText(item->m_summary);
	textedit->setText(item->m_text);

	summaryedit->setEnabled(true);
	textedit->setReadOnly(false);
    }
    else
    {
	summaryedit->setEnabled(false);
	textedit->setReadOnly(true);

	boldbt->setDown(false);
	italicbt->setDown(false);
	underlinebt->setDown(false);
    }

    connect(summaryedit, SIGNAL(textChanged(const QString&)), this, SLOT(updateItem()));
    connect(textedit, SIGNAL(textChanged()), this, SLOT(updateItem()));
}

void TextProperties::itemChanged(int id)
{
    if (!m_lastitem) return;

    if (m_lastitem->Id() == id)
	if (summaryedit->text() != m_lastitem->m_summary)
	    summaryedit->setText( m_lastitem->m_summary );
}

void TextProperties::updateItem()
{
    if (!m_lastitem) return;

    m_lastitem->m_summary = summaryedit->text();
    m_lastitem->m_text = textedit->text();
    m_lastitem->setChanged();
}

void TextProperties::showEvent(QShowEvent *ev)
{
    QWidget::showEvent(ev);
    activate();
}

void TextProperties::activate()
{
    setFocusProxy( summaryedit);
    //summaryedit->setFocus();
}

#include "TextProperties.moc"
