/************************************************************************
 *                                                                      *
 * Copyright 2010 Andreas Pakulat <apaku@gmx.de>                        *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 or version 3 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful, but  *
 * WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU     *
 * General Public License for more details.                             *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, see <http://www.gnu.org/licenses/>. *
 ************************************************************************/

#ifndef KDEVELOP_PROJECTMANAGERS_CUSTOM_BUILDSYSTEM_INCLUDESWIDGET_H
#define KDEVELOP_PROJECTMANAGERS_CUSTOM_BUILDSYSTEM_INCLUDESWIDGET_H

#include <QWidget>

namespace Ui
{
class IncludesWidget;
}

namespace KDevelop
{
    class IProject;
}
class QUrl;
class ProjectPathsModel;
class IncludesModel;

class IncludesWidget : public QWidget
{
Q_OBJECT
public:
    explicit IncludesWidget( QWidget* parent = nullptr );
    void setProject(KDevelop::IProject* w_project);
    void setIncludes( const QStringList& );
    void clear();
Q_SIGNALS:
    void includesChanged( const QStringList& );
private Q_SLOTS:
    // Handling of include-path url-requester, add and remove buttons
    void includePathSelected( const QModelIndex& selected );
    void includePathEdited();
    void includePathUrlSelected(const QUrl&);
    void addIncludePath();
    // Handles action and also Del-key in list
    void deleteIncludePath();
    void checkIfIncludePathExist();

    // Forward includes model changes
    void includesChanged();
private:
    Ui::IncludesWidget* ui;
    IncludesModel* includesModel;
    QString makeIncludeDirAbsolute( const QUrl &url ) const;
    // Enables/Disables widgets based on UI state/selection
    void updateEnablements();
    void updatePathsModel( const QVariant& newData, int role );
};

#endif
