/***************************************************************************
                          Kwin4  -  Four in a Row for KDE
                             -------------------
    begin                : March 2000 
    copyright            : (C) 1995-2000 by Martin Heni
    email                : martin@heni-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KWIN4DOC_H
#define KWIN4DOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>

#include "tabelle.h"
#include "kwin4.h"
#include "KEInput.h"

#define WIN_VALUE 9999000L
#define NOOFPLAYER  2



// forward declaration of the Kwin4 classes
class Kwin4View;

/**	Kwin4Doc provides a document object for a document-view model.
  *
  * The Kwin4Doc class provides a document object that can be used in conjunction with the classes Kwin4App and Kwin4View
  * to create a document-view model for standard KDE applications based on KApplication and KTMainWindow. Thereby, the document object
  * is created by the Kwin4App instance and contains the document structure with the according methods for manipulation of the document
  * data by Kwin4View objects. Also, Kwin4Doc contains the methods for serialization of the document data from and to files.
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
  * @version KDevelop version 0.4 code generation
  */
class Kwin4Doc : public QObject
{
  Q_OBJECT
  public:
    /** Constructor for the fileclass of the application */
    Kwin4Doc(QWidget *parent, const char *name=0);
    /** Destructor for the fileclass of the application */
    ~Kwin4Doc();

    /** adds a view to the document which represents the document contents. Usually this is your main view. */
    void addView(Kwin4View *view);
    /** removes a view from the list of currently connected views */
    void removeView(Kwin4View *view);
    /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
    void setModified(bool _m=true){ modified=_m; };
    /** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
    bool isModified(){ return modified; };
    /** "save modified" - asks the user for saving if the document is modified */
    bool saveModified();	
    /** deletes the document's contents */
    void deleteContents();
    /** initializes the document generally */
    bool newDocument(KConfig *config,QString file);
    /** closes the acutal document */
    void closeDocument();
    /** loads the document by filename and format and emits the updateViews() signal */
    bool openDocument(const QString &filename, const char *format=0);
    /** saves the document under filename and format.*/	
    bool saveDocument(const QString &filename, const char *format=0);
    /** sets the path to the file connected with the document */
    void setAbsFilePath(const QString &filename);
    /** returns the pathname of the current document file*/
    const QString &getAbsFilePath() const;
    /** sets the filename of the document */
    void setTitle(const QString &_t);
    /** returns the title of the document */
    const QString &getTitle() const;
  /**  */
  int QueryLastHint();
  /**  */
  int QueryHeight(int x);
  /**  */
  bool IsLocked();
  /**  */
  void ReleaseLock();
  /**  */
  void SetLock();
  /**  */
  long QueryScore();
  /**  */
  void SetScore(long i);
  /** Reset the stats */
  void ResetStat();
  /**  */
  int CheckGameOver(int x, FARBE col);
  /**  */
  void SetPlayerColour(int player,FARBE col);
  /**  */
  FARBE QueryPlayerColour(int player);
  /**  */
  void SetTable(FARBE i,int value,TABLE mode);
  /**  */
  void SetStat(FARBE i,int value,TABLE mode);
  /**  */
  int QueryStat(FARBE i,TABLE mode);
  /** Query the table */
  int QueryTable(FARBE i, TABLE mode);
  /** Query the name of i */
  QString QueryName(FARBE i);
  /** Set the name of col */
  void SetName(FARBE i,QString n);
  /** col is played remotely */
  void SetRemote(FARBE col);
  /** col is played by the interactive user */
  void SetUser(FARBE col);
  /** col will be played by the computer */
  void SetComputer(FARBE col);
  /** Is col played remotely */
  bool IsRemote(FARBE col);
  /** Is col played by the interactive player */
  bool IsUser(FARBE col);
  /** Is colour player by a computer */
  bool IsComputer(FARBE col);
  /** Redo a move */
  int RedoMove();
  /** Undo a move */
  int UndoMove();
  /** Make a game move */
  MOVESTATUS MakeMove(int x,int mode=0);
  /** Is the introduction on */
  bool IsIntro();
  /** Is a game running */
  bool IsRunning();
  /** End a game */
  void EndGame(TABLE mode);
  /** Start a new game */
  void StartGame();
  /** Reset the whole game */
  void ResetGame();
  /** Set the colour */
  void SetColour(int x,int y,FARBE c);
  /** Returns colour */
  FARBE QueryColour(int x,int y);

  /** Read game config */
  void ReadConfig(KConfig *config);
  /** Write game config */
  void WriteConfig(KConfig *config);
  /** Sends and update to all views.
Depending on which only party of
the view, like the table are updated */
  void UpdateViews(int which,int x,int y);

  // return pointer to input handeler
  KEInput *QueryInputHandler();
  void SetInputHandler(KEInput *);
  /** Returns the current player, resp
amzug */
  FARBE QueryCurrentPlayer();
  void SetCurrentPlayer(FARBE i);

  /** Set Computer level */
  void SetLevel(int i);
  /** Query Computer Level */
  int QueryLevel();

  /** Swtich the starting player and return the new started */
  FARBE SwitchStartPlayer();

  int QueryLastcolumn();   // last x moved
  FARBE QueryLastcolour(); // last colour moved
  int QueryCurrentMove();  // 0..42
  void SetCurrentMove(int );  // 0..42
  int QueryMaxMove();      // 0..42
  int QueryHistoryCnt();  // 0..42
  int QueryID();          // Doc id (random)
  /**  */
  void SetServer(bool s);
  /** Do we want to be a remote server */
  bool QueryServer();
  /** Random number between 0..max-1 */
  int Random(int max);
  /** Preload all Bitmaps */
  int LoadBitmaps(const QString path);
  QString QueryProcessName();
  void SetHost(QString host);
  void SetPort(unsigned short port);
  unsigned short QueryPort();
  QString QueryHost();
  int QueryWinX(int i) {return winx[i];}
  int QueryWinY(int i) {return winy[i];}
  FARBE QueryWinC() {return winc;}
  int QueryBlink() {return doBlink;}
  void SetBlink(int i) {doBlink=i;}

	
  public slots:
    /** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
     * As this view normally repaints itself, it is excluded from the paintEvent.
     */
    void slotUpdateAllViews(Kwin4View *sender);
 	
  public:	
    /** the list of the views currently connected to the document */
    static QList<Kwin4View> *pViewList;	

  public: // Protected attributes
  /**  */
  QPixmap m_PixBackground;
  QPixmap m_PixBoard;
  QPixmap m_PixArrow;
  QPixmap m_PixArrowRed;
  QPixmap m_PixArrowYellow;
  QPixmap m_PixAbout;
  QPixmap m_PixFieldYellow;
  QPixmap m_PixFieldRed;
  QPixmap m_PixFieldHint;
  QPixmap m_PixFieldEmpty;
  QPixmap m_PixWin4About;

  protected:
  QString procfile;// file for computer player
  QString picpath; // path to pictures dir
  int     delpath; // delete delpath?
  FARBE amzug;
  int docid;

  int currentmove;  // current move in the game
  int maxmove;      // maximal move in a game
  int lastcolumn;   // last x moved
  FARBE lastcolour; // last colour moved

  // Calculation
  int maxreklev;
  long aktwert;
  /**  */
  bool is_server;

  int history_cnt;
  unsigned short mPort;
  QString mHost;

  private:
   KEInput *inputHandler;

    /** the modified flag of the current document */
    bool modified;
    QString title;
    QString absFilePath;

  FARBE *fields;
  int *field_filled;
  int running;   // is a game running?
  int intro;     // show intro screen?

  int lasthint;
  bool is_lock;   // Move is locked due to computer move

  // gameplay
  class tabelle tab[NOOFPLAYER+1];
  class tabelle alltab[NOOFPLAYER+1];

  QString Names[NOOFPLAYER+1];
  FARBE Colour[NOOFPLAYER+1];

  int *history;
  PLAYER player[NOOFPLAYER+1];

  // Mark the fields of the four winning stones
  int winx[4],winy[4];
  FARBE winc;
  int doBlink;  // shall we blink the winning pieces


};

#endif // KWIN4DOC_H
