#!/usr/bin/env python

"""**************************************************************************
** $Id: rangecontrols.py,v 1.1 2004/06/19 20:33:28 sedwards Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
***************************************************************************"""

import sys
from qt import *

INT_MAX = sys.maxint

class RangeControls( QVBox ):
    def __init__( self, parent=None, name=None ):
        QVBox.__init__( self, parent, name )
        
        row1  = QHBox( self )
        cell2 = QVBox( row1 )
        cell2.setMargin( 10 )
        cell2.setFrameStyle( QFrame.WinPanel | QFrame.Sunken )

        QWidget( cell2 )

        label1 = QLabel( QString( "Enter a value between\n%1 and %2:" ).arg( -INT_MAX ).arg( INT_MAX ), cell2 )
        label1.setMaximumHeight( label1.sizeHint().height() )
        sb1 = QSpinBox( -INT_MAX, INT_MAX, 1, cell2 )
        sb1.setValue( 0 )

        label2 = QLabel( "Enter a zoom value:", cell2 )
        label2.setMaximumHeight( label2.sizeHint().height() )
        sb2 = QSpinBox( 0, 1000, 10, cell2 )
        sb2.setSuffix( " %" )
        sb2.setSpecialValueText( "Automatic" )

        label3 = QLabel( "Enter a price:", cell2 )
        label3.setMaximumHeight( label3.sizeHint().height() )
        sb3 = QSpinBox( 0, INT_MAX, 1, cell2 )
        sb3.setPrefix( "$" )
        sb3.setValue( 355 )

        QWidget( cell2 )

        row2 = QHBox( self )

        cell3 = QVBox( row2 )
        cell3.setMargin( 10 )
        cell3.setFrameStyle( QFrame.WinPanel | QFrame.Sunken )
        hslider = QSlider( 0, 64, 1, 33, Qt.Horizontal, cell3 )
        lcd2 = QLCDNumber( 2, cell3 )
        lcd2.display( 33 )
        lcd2.setSegmentStyle( QLCDNumber.Filled )
        self.connect( hslider, SIGNAL("valueChanged( int )"), lcd2, SLOT("display( int )") )

        cell4 = QHBox( row2 )
        cell4.setFrameStyle( QFrame.WinPanel | QFrame.Sunken )
        cell4.setMargin( 10 )
        vslider = QSlider( 0, 64, 1, 8, Qt.Vertical, cell4 )
        lcd3 = QLCDNumber( 3, cell4 )
        lcd3.display( 8 )
        self.connect( vslider, SIGNAL("valueChanged( int )"), lcd3, SLOT("display( int )") )

def main( args ):
    a = QApplication( args )
    
    rangecontrols = RangeControls()
    rangecontrols.resize( 500, 300 )
    rangecontrols.setCaption( "Qt Example - Range Control Widgets" );
    a.setMainWidget( rangecontrols )
    rangecontrols.show()
    
    a.exec_loop()
    
if __name__=="__main__":
    main(sys.argv)
