/*
	Serenity Style for KDE 3+
	
		Copyright (C) 2006 Remi Villatel <maxilys@tele2.fr>
	
	Based on Lipstik engine:
	
		Copyright (C) 2004 Patrice Tremblay <tremblaypatrice@yahoo.fr>
	
	Also based on numerous open source styles that helped me to not 
	re-invent the wheel for every line of code. Thanks to everyone.  ;-)
	
	This library is free software; you can redistribute it and/or 
	modify it under the terms of the GNU Library General Public 
	License version 2 as published by the Free Software Foundation.
	
	This library is distributed in the hope that it will be useful, 
	but WITHOUT ANY WARRANTY; without even the implied warranty of 
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
	Library General Public License for more details.
	
	You should have received a copy of the GNU Library General Public 
	License along with this library. (See the file COPYING.) If not, 
	write to:
	The Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
	Boston, MA 02111-1307, USA.
*/

#ifndef SERENITY_CONF_H
#define SERENITY_CONF_H

class QCheckBox;
class QSlider;

class SerenityStyleConfig: public QWidget
{
	Q_OBJECT
	
	public:
		SerenityStyleConfig(QWidget* parent);
		~SerenityStyleConfig();
	
		// This signal and the next two slots are 
		// the plugin page interface
	signals:
		void changed(bool);
	
	public slots:
		void save();
		void defaults();
	
		// Everything below this point is internal.
	protected slots:
		void updateChanged();
	
	protected:
		// We store settings directly in widgets 
		// to avoid the hassle of sync'ing things
		QComboBox*	gradientStyle;
		QCheckBox*	alternateSinking;
		QCheckBox*	customOverHighlightColor;
		KColorButton*	overHighlightColor;
		//QCheckBox	mouseOverLabel;
		QComboBox*	scrollBarStyle;
		QCheckBox*	centerTabs;
		QComboBox*	tabStyle;
		QComboBox*	tabWarnStyle;
		QComboBox*	menuGrooveStyle;
		QCheckBox*	menubarHack;
		//
		QComboBox*	tipTint;
		QCheckBox*	drawTriangularExpander;
		QCheckBox*	drawFocusRect;
		QCheckBox*	drawToolBarHandle;
		QCheckBox*	drawToolBarSeparator;
		QComboBox*	progressBarPattern;
		QCheckBox*	flatProgressBar;
		QCheckBox*	animateProgressBar;
		QSlider*	submenuSpeed;
	
		// Original settings, for accurate dirtiness tracking
		int		origGradientStyle;
		bool		origAlternateSinking;
		bool		origCustomOverHighlightColor;
		QColor		origOverHighlightColor;
		//bool		origMouseOverLabel;
		int		origScrollBarStyle;
		bool		origCenterTabs;
		int		origTabStyle;
		int		origTabWarnStyle;
		int		origMenuGrooveStyle;
		bool		origMenubarHack;
		//
		int		origTipTint;
		bool		origDrawTriangularExpander;
		bool		origDrawFocusRect;
		bool		origDrawToolBarHandle;
		bool		origDrawToolBarSeparator;
		int		origProgressBarPattern;
		bool		origFlatProgressBar;
		bool		origAnimProgressBar;
		int		origSubmenuSpeed;
};

#endif
