/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef KBIBTEXSIDEBAR_H
#define KBIBTEXSIDEBAR_H

#include <qwidget.h>

#include <entryfield.h>
#include <file.h>

class QComboBox;
class QToolButton;
class KListBox;
class QListBoxItem;

namespace KBibTeX
{
    class SideBar : public QWidget
    {
        Q_OBJECT
    public:
        SideBar( QWidget *parent = 0, const char *name = 0 );
        ~SideBar();

        void restoreState();

    signals:
        void selected( const QString& text, BibTeX::EntryField::FieldType fieldType );

    public slots:
        void refreshLists( const BibTeX::File *bibtexFile = NULL );

    protected:
        void resizeEvent( QResizeEvent *event );

    private:
        const BibTeX::File *m_bibtexFile;
        QToolButton *m_buttonToggleShowAll;
        QComboBox *m_listTypeList;
        KListBox *m_listAvailableItems;
        static const BibTeX::EntryField::FieldType importantFields[ 5 ];

        void setupGUI();

    private slots:
        void prepareSearch( QListBoxItem *item );
        void toggleShowAll( bool showAll );
    };

}

#endif
