/******************************************************************************
 *   Copyright (C) 2006 PhobosK <phobosk@mail.kbfx.org>                       *
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This package is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the             *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this package; if not, write to the Free Software              *
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA *
 ******************************************************************************/

#ifndef PIXMAPLABEL_H
#define PIXMAPLABEL_H

#include <qlabel.h>
#include <kdebug.h>
#include <qdragobject.h>

#include "kbfxconfigdlgbutton.h"

class KbfxPixmapLabel : public QLabel
{
  Q_OBJECT

public:
  KbfxPixmapLabel(QWidget *parent = 0, const char *name = 0, WFlags f = 0);

  void dragEnterEvent(QDragEnterEvent *mouseDragEnterEvent);
  void dropEvent(QDropEvent *mouseDropEvent);

signals:
  void targetDrop(const QString &);
};

#endif // PIXMAPLABEL_H
