/***************************************************************************
                          kbearimportfilterplugin.cpp  -  description
                             -------------------
    begin                : tis mar 19 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////
// Qt specific includes
#include <qfile.h>
#include <qdir.h>
#include <qmap.h>
#include <qdom.h>
#include <qstringlist.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <klocale.h>
#include <kconfig.h>
#include <kmdcodec.h>
#include <kmessagebox.h>
#include <kinstance.h>
#include <kgenericfactory.h>
#include <kdebug.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "kbearimportfilterplugin.h"

///////////////////////////////////////////////////////
bool KBearImportFilterPlugin::OLD_SITEMANAGER = false;
///////////////////////////////////////////////////////

typedef struct ConnectInfo;
struct ConnectInfo{
	QString label;
	QString protocol;
	QString host;
	int port;
	bool anonym;
	bool passiveMode;
	QString user;
	QString pass;
	QString remotePath;
	QString localPath;
};
///////////////////////////////////////////////////////
inline QDataStream& operator >> ( QDataStream& s, struct ConnectInfo& inf ) {
	s >> inf.label;
	s >> inf.host;
	s >> inf.port;
	QString str;
	s >> str;
	if(str =="true")
		inf.anonym = true;
	else
		inf.anonym = false;
	s >> inf.user;
	s >> inf.pass;
	s >> inf.remotePath;
	if( KBearImportFilterPlugin::OLD_SITEMANAGER ){
		inf.protocol="ftp";
		inf.localPath = QDir::homeDirPath();
		inf.passiveMode = true;
	}
	else{
		s >> inf.localPath;
		inf.protocol="ftp";
		inf.passiveMode = true;
	}
	return s;
}		
///////////////////////////////////////////////////////
typedef struct SiteInfo;
struct SiteInfo {
	QString parent;
	ConnectInfo info;
	QString description;
};
///////////////////////////////////////////////////////
inline QDataStream& operator >> ( QDataStream& s, struct SiteInfo& inf ) {
	s >> inf.parent;
	s >> inf.info;
	s >> inf.description;
	return s;
}
///////////////////////////////////////////////////////
inline QDataStream& operator>>( QDataStream& s, QMap<QString, SiteInfo>& m) {
	m.clear();
	Q_UINT32 c;
	s >> c;
	for( Q_UINT32 i = 0; i < c; ++i ) {
		QString k;
		SiteInfo t;
		s >> k;
		s >> t;
		m.insert( k, t );
	}
	return s;
}
///////////////////////////////////////////////////////
typedef KGenericFactory<KBearImportFilterPlugin> KBearImportFilterPluginFactory;
K_EXPORT_COMPONENT_FACTORY( libkbearimportfilter, KBearImportFilterPluginFactory( "KBearImportFilterPlugin" ) );
//-----------------------------------------------
KBearImportFilterPlugin::KBearImportFilterPlugin(QObject *parent, const char *name,const QStringList& )
	:	SiteImportFilterPluginIface(parent,name),
		m_hasError( false )
{
//	setXMLFile("kbearimportfilterui.rc");
	KGlobal::locale()->insertCatalogue("kbear");
	m_domDocument.setContent( QString("<group label=\"%1\"/>").arg(i18n("KBear 1.x.x import")) );
}
//-----------------------------------------------
KBearImportFilterPlugin::~KBearImportFilterPlugin(){
}
//-----------------------------------------------
QString KBearImportFilterPlugin::getDomDocument() {
	return m_domDocument.toString();
}
//-----------------------------------------------
void KBearImportFilterPlugin::import( const QString& fileName ) {
	if( fileName.isEmpty() || fileName.isNull() ) {
		KMessageBox::sorry( 0, i18n("You have to select a file to import."), i18n("No file") );
		m_hasError = true;
		emit progress( 100 );
		return;
	}
	//Check version of sitemanager
	QStringList list = QStringList::split( "/", fileName );
	if( list.last() == "sitemanager" )
		OLD_SITEMANAGER = true;
	else if( list.last() == "sitemanager_1_3" )
		OLD_SITEMANAGER = false;
	else { // Not a KBear sitemanager file
		invalidFileError( fileName );
		m_hasError = true;
	}
	if( ! m_hasError ) {
		QFile file( fileName );
		file.open(IO_ReadOnly);
		QDataStream fileStream( &file );
		QMap<QString, SiteInfo> mySiteMap;
		fileStream >> mySiteMap;
		file.close();
		size = (float)mySiteMap.count();
		counter = 0;
		if( size <= 0 ) {
			invalidFileError( fileName );
			m_hasError = true;
		}
		else
			createTree( &mySiteMap, m_domDocument.firstChild().toElement() );

		int answer = KMessageBox::questionYesNo( 0, i18n("The old sitemanager has now been imported.\n"
									"Do you want to remove the old sitemanager file now ?"), i18n("Remove file") );
		if( answer == KMessageBox::Yes ) {
			file.remove();
		}
	}
	emit progress( 100 );
}
//-----------------------------------------------
void KBearImportFilterPlugin::createTree( QMap<QString, SiteInfo>* mySiteMap , QDomElement parentElement ){
	SiteInfo groupInf, siteInf;
	QDomElement tmpElement;
	QMapIterator<QString, SiteInfo> siteIter, groupIter;
	for( groupIter = mySiteMap->begin(); groupIter != mySiteMap->end(); ++groupIter )  {
		groupInf = groupIter.data();
		if( groupInf.description == "group" ) {
			if( ( groupInf.parent == "Root" && parentElement == m_domDocument.firstChild().toElement() )
				|| groupInf.parent == parentElement.attribute( "label" ) )	
			{
				tmpElement = m_domDocument.createElement( "group" );
				tmpElement.setAttribute( "label", groupInf.info.label );
				parentElement.appendChild( tmpElement );	
				createTree( mySiteMap, tmpElement );
			}
		}
		else {
			for( siteIter = mySiteMap->begin(); siteIter != mySiteMap->end(); ++siteIter )  {
				siteInf = siteIter.data();
				if( siteInf.description == "group" ) // is it a group  item
					;                                            // do nothing
				else if( ( siteInf.parent == "Root" && parentElement == m_domDocument.firstChild().toElement() )
					|| siteInf.parent == parentElement.attribute( "label" ) )
				{          // is this a root item ?
					if( addSite( siteInf, parentElement ) ) {
						emit progress( int(float(counter) / size * 100) );	
						counter++;	
					}
				}
			}
		}
	}
}
//-----------------------------------------------
bool KBearImportFilterPlugin::addSite( SiteInfo siteInf, QDomElement parentElement ) {
	QDomNodeList list = parentElement.childNodes();
	for( unsigned int i = 0; i < list.count(); i++ ) {
		if( list.item( i ).toElement().attribute("label") == siteInf.info.label )
			return false; // site already exist
	}
	// first  check so the site has a host, if not ignore it
	if( siteInf.info.host.isNull() || siteInf.info.host.isEmpty() )  // no host
		return false;

	// set host
	QDomElement siteElement = m_domDocument.createElement( "site" );
	siteElement.setAttribute( "label", siteInf.info.label );			
	parentElement.appendChild( siteElement );	
	// set host
	QString tmp = siteInf.info.host;
	QDomElement tmpElement = m_domDocument.createElement( "host" );
	QDomText txtNode = m_domDocument.createTextNode( tmp );
	tmpElement.appendChild( txtNode );
	siteElement.appendChild( tmpElement );	
	// set port
	int p = siteInf.info.port;
	tmpElement = m_domDocument.createElement( "port" );
	txtNode = m_domDocument.createTextNode( QString::number( p ) );
	tmpElement.appendChild( txtNode );
	siteElement.appendChild( tmpElement );	
	// set protocol
	tmp = siteInf.info.protocol;
	tmpElement = m_domDocument.createElement( "protocol" );
	txtNode = m_domDocument.createTextNode( tmp );
	tmpElement.appendChild( txtNode );
	siteElement.appendChild( tmpElement );	
	// set remote directory
	tmp = siteInf.info.remotePath;
	tmpElement = m_domDocument.createElement( "remote_path" );
	txtNode = m_domDocument.createTextNode( tmp );
	tmpElement.appendChild( txtNode );
	siteElement.appendChild( tmpElement );	
	// set local directory
	tmp = siteInf.info.localPath;
	tmpElement = m_domDocument.createElement( "local_path" );
	txtNode = m_domDocument.createTextNode( tmp );
	tmpElement.appendChild( txtNode );
	siteElement.appendChild( tmpElement );	
	// set username
	tmp = siteInf.info.user;
	tmpElement = m_domDocument.createElement( "user" );
	txtNode = m_domDocument.createTextNode( tmp );
	tmpElement.appendChild( txtNode );
	siteElement.appendChild( tmpElement );	
	// set password
	tmp = encodePassword( siteInf.info.pass );
	tmpElement = m_domDocument.createElement( "pass" );
	txtNode = m_domDocument.createTextNode( tmp );
	tmpElement.appendChild( txtNode );
	siteElement.appendChild( tmpElement );	
	// set description
	tmp = siteInf.description;
	tmpElement = m_domDocument.createElement( "description" );
	txtNode = m_domDocument.createTextNode( tmp );
	tmpElement.appendChild( txtNode );
	siteElement.appendChild( tmpElement );	
	// set anonym
	if( siteInf.info.anonym ) {
		tmpElement = m_domDocument.createElement( "anonymous" );
		siteElement.appendChild( tmpElement );	
	}
	// set PASV
	if( ! siteInf.info.passiveMode ) {
		tmpElement = m_domDocument.createElement( "disable_pasv" );
		siteElement.appendChild( tmpElement );	
	}
	return true;
}
	
//-----------------------------------------------
QString KBearImportFilterPlugin::encodePassword( const QString& password ) {
	QString pass = password;
	QTextStream sStream( &pass, IO_ReadOnly );
	QCString bArray;
	sStream >> bArray;
	QCString result = KCodecs::base64Encode( bArray );	
	return result.data();
}
//-----------------------------------------------
void KBearImportFilterPlugin::invalidFileError(const QString& fileName){
	KMessageBox::sorry( 0, i18n("The file: %1\nis not a valid KBear sitemanager file.").arg(fileName), i18n("Invalid import file") );
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbearimportfilterplugin.moc"
#endif
