/************************************************************************************
                          kbeartransferviewitem.cpp  -  description
                             -------------------
    Begin					: Mn Maj 06 2002
    Copyright				: (C) 2000 by Bjrn Sahlstrm
    Email						: kbjorn@users.sourceforge.net
 ***********************************************************************************/

/************************************************************************************
 *																						*
 *   This program is free software; you can redistribute it and/or modify		*
 *   it under the terms of the GNU General Public License as published by	*
 *   the Free Software Foundation; either version 2 of the License, or			*
 *   (at your option) any later version.												*
 *																						*
 ************************************************************************************/

/////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qapplication.h>
#include <qtimer.h>
#include <qtextcodec.h>
/////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
#include <kglobal.h>
#include <kcharsets.h>
#include <kiconloader.h>
#include <kio/global.h>
#include <kmessagebox.h>
#include <kdebug.h>
/////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbeartransferviewitem.h"
#include "kbeartransferviewpage.h"
#include "kbearconnectionmanager.h"
#include "transfer.h"

/////////////////////////////////////////////////////////////////////
class KBearTransferViewItem::KBearTransferViewSubItem : public QListViewItem  {
	public:
		KBearTransferViewSubItem( QListView* parent, const QString& name ):QListViewItem( parent, name ){}
		virtual ~KBearTransferViewSubItem(){}
		virtual void setOpen(bool o) {
			if( o )
				QListViewItem::setPixmap( 0, * KBearTransferViewPage::folderOpen() );
			else
				QListViewItem::setPixmap( 0, * KBearTransferViewPage::folderClosed() );

			QListViewItem::setOpen( o );
		}
};
/////////////////////////////////////////////////////////////////////
KBearTransferViewItem::KBearTransferViewItem( KBearTransferViewPage* v, Transfer* t )
	:	QObject( v ), m_transferViewPage( v ), m_transfer( t ),
		m_finishedStat( false )

{
	m_transfer->setViewItem( this );
	init();
}
//-----------------------------------------------
KBearTransferViewItem::~KBearTransferViewItem(){
	delete m_transfer;
	m_transfer = 0L;
}
//-----------------------------------------------
void KBearTransferViewItem::init(){
	QString host;
	if( ! m_transfer->sourceList().first().hasHost() || ! m_transfer->destURL().hasHost() )  // transfer against local file sys
		host = i18n("Local File System");
	else  // both source and dest are remote so we set dest here
		host = m_transfer->destConnection().label();

	connect( m_transferViewPage, SIGNAL( showMenu( QListViewItem* ) ),
	   				this, SLOT( slotShowMenu( QListViewItem* ) ) );
	connect( connectionManager, SIGNAL( jobPaused( KIO::Job* ) ),
	   				this, SLOT( slotPaused( KIO::Job* ) ) );
	connect( connectionManager, SIGNAL( jobResumed( KIO::Job* ) ),
	   				this, SLOT( slotResumed( KIO::Job* ) ) );


	int n = m_transferViewPage->checkNameIntegrity( host );
	if( n ) {
		while( m_transferViewPage->checkNameIntegrity( host+QString("( %1 )").arg( n+1 ) ) > 0 )
			++n;

		host += QString("( %1 )").arg( n+1 );
	}
	p_myTreeViewItem = new KBearTransferViewSubItem( m_transferViewPage, host );
	p_myTreeViewItem->setExpandable( true );
	p_myTreeViewItem->setPixmap( 0, * KBearTransferViewPage::folderClosed() );
	p_myTreeViewItem->setOpen( true );
	transferTypeItem = new QListViewItem( p_myTreeViewItem, i18n("Transfer Type") );
	progressItem = new QListViewItem( p_myTreeViewItem, i18n("Progress") );
	speedItem = new QListViewItem( p_myTreeViewItem, i18n("Speed") );
	remainingTimeItem = new QListViewItem( p_myTreeViewItem, i18n("Remaining Time") );
	processedSizeItem = new QListViewItem( p_myTreeViewItem, i18n("Processed Size") );
	totalSizeItem = new QListViewItem( p_myTreeViewItem, i18n("Total Size") );
	sourceItem = new QListViewItem( p_myTreeViewItem, i18n("Source") );
	destinationItem = new QListViewItem( p_myTreeViewItem, i18n("Destination") );
	totalDirsItem = new QListViewItem( p_myTreeViewItem, i18n("Total Dirs") );
	totalFilesItem = new QListViewItem( p_myTreeViewItem, i18n("Total Files") );
	processedDirsItem = new QListViewItem( p_myTreeViewItem, i18n("Processed Dirs") );
	processedFilesItem = new QListViewItem( p_myTreeViewItem, i18n("Processed Files") );

	transferTypeItem->setExpandable( false );
	progressItem->setExpandable( false );
	speedItem->setExpandable( false );
	remainingTimeItem->setExpandable( false );
	processedSizeItem->setExpandable( false );
	totalSizeItem->setExpandable( false );
	sourceItem->setExpandable( false );
	destinationItem->setExpandable( false );
	totalDirsItem->setExpandable( false );
	totalFilesItem->setExpandable( false );
	processedDirsItem->setExpandable( false );
	processedFilesItem->setExpandable( false );
	//this seems unnecessary, but I need to do this in order to get the items in the order I want them
	m_transferViewPage->moveItem( progressItem, p_myTreeViewItem, transferTypeItem );
	m_transferViewPage->moveItem( speedItem, p_myTreeViewItem, progressItem );
	m_transferViewPage->moveItem( remainingTimeItem, p_myTreeViewItem, speedItem );
	m_transferViewPage->moveItem( processedSizeItem, p_myTreeViewItem, remainingTimeItem );
	m_transferViewPage->moveItem( totalSizeItem, p_myTreeViewItem, processedSizeItem );
	m_transferViewPage->moveItem( sourceItem, p_myTreeViewItem, totalSizeItem );
	m_transferViewPage->moveItem( destinationItem, p_myTreeViewItem, sourceItem );
	m_transferViewPage->moveItem( totalDirsItem, p_myTreeViewItem, destinationItem );
	m_transferViewPage->moveItem( totalFilesItem, p_myTreeViewItem, totalDirsItem );
	m_transferViewPage->moveItem( processedDirsItem, p_myTreeViewItem, totalFilesItem );
	m_transferViewPage->moveItem( processedFilesItem, p_myTreeViewItem, processedDirsItem );

	QString tmp = i18n("Queued");
	transferTypeItem->setText( 1 , tmp );
	p_myTreeViewItem->setText( 1 , tmp );
	progressItem->setText( 1 , i18n( "0 %" ) );

	QTime t( 0, 0 );
	remainingTimeItem->setText( 1 , t.toString() );

	tmp = m_transfer->sourceList().first().prettyURL();
	bool ok;
	if( m_transfer->sourceList().first().hasHost() ) {
		QTextCodec* codec = KGlobal::charsets()->codecForName( m_transfer->sourceConnection().fileSysEncoding(), ok );
		tmp = codec->toUnicode( tmp );
	}
	sourceItem->setText( 1, tmp );

	tmp = m_transfer->destURL().prettyURL();
	if( m_transfer->destURL().hasHost() ) {
		QTextCodec* codec = KGlobal::charsets()->codecForName( m_transfer->destConnection().fileSysEncoding(), ok );
		tmp = codec->toUnicode( tmp );
	}
	destinationItem->setText( 1, tmp );

}
//-----------------------------------------------
KBearCopyJob* KBearTransferViewItem::start(){
	KBearCopyJob* job;
	if( m_transfer->move() ) {
		job = connectionManager->move( m_transfer );
		transferTypeItem->setText( 1 , i18n("Moving") );
	}
	else {
		job = connectionManager->copy( m_transfer );
		transferTypeItem->setText( 1 , i18n("Copying") );
	}

	m_transfer->setJob( job );
	// first connect all slots
	connect( job, SIGNAL( totalSize( KIO::Job*, KIO::filesize_t ) ),
	   		this,SLOT( slotTotalSize( KIO::Job*, KIO::filesize_t ) ) );
	connect( job, SIGNAL( totalFiles( KIO::Job*, unsigned long ) ),
	   		this,SLOT( slotTotalFiles( KIO::Job*, unsigned long ) ) );
	connect( job, SIGNAL( totalDirs( KIO::Job*, unsigned long ) ),
	   		this,SLOT( slotTotalDirs( KIO::Job*, unsigned long ) ) );

	connect( job, SIGNAL( processedSize( KIO::Job*, KIO::filesize_t ) ),
	   		this,SLOT( slotProcessedSize( KIO::Job*, KIO::filesize_t ) ) );
	connect( job, SIGNAL( processedFiles( KIO::Job*, unsigned long ) ),
	   		this,SLOT( slotProcessedFiles( KIO::Job*, unsigned long ) ) );
	connect( job, SIGNAL( processedDirs( KIO::Job*, unsigned long ) ),
	   		this,SLOT( slotProcessedDirs( KIO::Job*, unsigned long ) ) );

	connect( job, SIGNAL( speed( KIO::Job*, unsigned long ) ),
	   		this,SLOT( slotSpeed( KIO::Job*, unsigned long ) ) );
	connect( job, SIGNAL( percent( KIO::Job*, unsigned long ) ),
	   		this,SLOT( slotPercent( KIO::Job*, unsigned long ) ) );

	connect( job, SIGNAL( copying( KIO::Job*, const KURL& , const KURL& ) ),
	   		this,SLOT( slotCopying( KIO::Job*, const KURL&, const KURL& ) ) );
	connect( job, SIGNAL( moving( KIO::Job*, const KURL& , const KURL& ) ),
	   		this,SLOT( slotMoving( KIO::Job*, const KURL&, const KURL& ) ) );
	connect( job, SIGNAL( linking( KIO::Job*, const QString& , const KURL& ) ),
	   		this,SLOT( slotLinking( KIO::Job*, const QString&, const KURL& ) ) );

	connect( job, SIGNAL( result( KIO::Job* ) ), this,SLOT( slotFinished( KIO::Job* ) ) );

	QString tmp = i18n( "0 %" );
	progressItem->setText( 1 , tmp );
	p_myTreeViewItem->setText( 1 , tmp );

	tmp = m_transfer->sourceList().first().prettyURL();
	bool ok;
	if( m_transfer->sourceList().first().hasHost() ) {
		QTextCodec* codec = KGlobal::charsets()->codecForName( m_transfer->sourceConnection().fileSysEncoding(), ok );
		tmp = codec->toUnicode( tmp );
	}
	sourceItem->setText( 1, tmp );

	tmp = m_transfer->destURL().prettyURL();
	if( m_transfer->destURL().hasHost() ) {
		QTextCodec* codec = KGlobal::charsets()->codecForName( m_transfer->destConnection().fileSysEncoding(), ok );
		tmp = codec->toUnicode( tmp );
	}
	destinationItem->setText( 1, tmp );

	tmp = KIO::convertSize( (KIO::filesize_t)0 );
	speedItem->setText( 1 , i18n("%1/sec").arg( tmp ) );

	job->slotStart();

	return job;
}
//-----------------------------------------------
void KBearTransferViewItem::slotCopying( KIO::Job* , const KURL& source, const KURL& dest )  {
	m_finishedStat = true;
	QString tmp = source.prettyURL();
	bool ok;
	if( source.hasHost() ) {
		QTextCodec* codec = KGlobal::charsets()->codecForName( m_transfer->sourceConnection().fileSysEncoding(), ok );
		tmp = codec->toUnicode( tmp );
	}
	sourceItem->setText( 1, tmp );

	tmp = dest.prettyURL();
	if( dest.hasHost() ) {
		QTextCodec* codec = KGlobal::charsets()->codecForName( m_transfer->destConnection().fileSysEncoding(), ok );
		tmp = codec->toUnicode( tmp );
	}
	destinationItem->setText( 1, tmp );

	if( !m_transfer->isPaused() )
		transferTypeItem->setText( 1 , i18n("Copying") );
}
//-----------------------------------------------
void KBearTransferViewItem::slotMoving( KIO::Job* , const KURL& source, const KURL& dest )  {
	m_finishedStat = true;
	QString tmp = source.prettyURL();
	bool ok;
	if( source.hasHost() ) {
		QTextCodec* codec = KGlobal::charsets()->codecForName( m_transfer->sourceConnection().fileSysEncoding(), ok );
		tmp = codec->toUnicode( tmp );
	}
	sourceItem->setText( 1, tmp );

	tmp = dest.prettyURL();
	if( dest.hasHost() ) {
		QTextCodec* codec = KGlobal::charsets()->codecForName( m_transfer->destConnection().fileSysEncoding(), ok );
		tmp = codec->toUnicode( tmp );
	}
	destinationItem->setText( 1, tmp );

	if( !m_transfer->isPaused() )
		transferTypeItem->setText( 1 , i18n("Moving") );
}
//-----------------------------------------------
void KBearTransferViewItem::slotLinking( KIO::Job*, const QString& target, const KURL& dest ) {
	sourceItem->setText( 1, target );

	bool ok;
	QString tmp = dest.prettyURL();
	if( dest.hasHost() ) {
		QTextCodec* codec = KGlobal::charsets()->codecForName( m_transfer->destConnection().fileSysEncoding(), ok );
		tmp = codec->toUnicode( tmp );
	}
	destinationItem->setText( 1, tmp );

	if( !m_transfer->isPaused() )
		transferTypeItem->setText( 1 , i18n("Linking") );
}
//-----------------------------------------------
void KBearTransferViewItem::slotTotalSize( KIO::Job* , KIO::filesize_t totSize ) {
	totalSizeItem->setText( 1 , i18n("%1").arg( KIO::convertSize(totSize) ) );
	m_totalSize = totSize;
}
//-----------------------------------------------
void KBearTransferViewItem::slotProcessedSize( KIO::Job*, KIO::filesize_t procSize ) {
	processedSizeItem->setText( 1 , KIO::convertSize( procSize ) );
	m_processedSize = procSize;
}
//-----------------------------------------------
void KBearTransferViewItem::slotPercent( KIO::Job*, unsigned long percent ) {
	QString p = i18n("%1 %").arg( percent );
	progressItem->setText( 1 , p );
	p_myTreeViewItem->setText( 1 , p );
}
//-----------------------------------------------
void KBearTransferViewItem::slotSpeed( KIO::Job*, unsigned long speed ) {
	QString tmp = KIO::convertSize( (KIO::filesize_t)speed );
	speedItem->setText( 1 , i18n("%1/sec").arg( tmp ) );
	if( speed > 0 ) {
		QTime t = KIO::calculateRemaining( m_totalSize, m_processedSize, (KIO::filesize_t)speed );
		remainingTimeItem->setText( 1 , t.toString() );
	}
}
//-----------------------------------------------
void KBearTransferViewItem::slotTotalDirs( KIO::Job*, unsigned long totDirs ) {
	totalDirsItem->setText( 1 , i18n("%1").arg( totDirs ) );
}
//-----------------------------------------------
void KBearTransferViewItem::slotTotalFiles( KIO::Job*, unsigned long totFiles ) {
	totalFilesItem->setText( 1 , i18n("%1").arg( totFiles ) );
}
//-----------------------------------------------
void KBearTransferViewItem::slotProcessedDirs( KIO::Job*, unsigned long pDirs ) {
	processedDirsItem->setText( 1 , i18n("%1").arg( pDirs ) );
}
//-----------------------------------------------
void KBearTransferViewItem::slotProcessedFiles( KIO::Job*, unsigned long pFiles ) {
	processedFilesItem->setText( 1 , i18n("%1").arg( pFiles ) );
}
//-----------------------------------------------
void KBearTransferViewItem::slotShowMenu( QListViewItem* item ){
	if( ! item || item != p_myTreeViewItem  )
		return;
	QPopupMenu menu( 0L );

	if( m_transfer->job() ) {// is the job started ?
		int id = menu.insertItem( i18n("&Cancel"), this, SLOT( slotStop() ) );
		menu.setItemEnabled( id, m_finishedStat );
		KBearCopyJob* job = static_cast<KBearCopyJob*>( m_transfer->job() );
		if( ! job->localDest() || ! job->localSrc() ) {
			menu.insertSeparator();
			if( ! m_transfer->isPaused() )
				id =menu.insertItem( i18n("&Pause"), this, SLOT( slotPause() ) );
			else
				id =menu.insertItem( i18n("&Resume"), this, SLOT( slotResume() ) );
			menu.setItemEnabled( id, m_finishedStat );
		}
	}
	else {
		menu.insertItem( i18n("&Start"), this, SLOT( slotStart() ) );
	}
	menu.setMouseTracking( true );
	menu.exec( QCursor::pos() );
}
//-----------------------------------------------
void KBearTransferViewItem::slotFinished( KIO::Job* job ) {
	m_transfer->setJob( 0L );
	if( job ) {
		job->disconnect( this );
		if( job->error() && job->error() != KIO::ERR_USER_CANCELED ){
			QStringList list = job->detailedErrorStrings();
			KMessageBox::detailedError( p_myTreeViewItem->listView(), list[1], list[2], list[0] );
		}
	}
	if( p_myTreeViewItem ) {
		delete p_myTreeViewItem;
		p_myTreeViewItem = 0L;
	}
	emit finished( this );
}
//-----------------------------------------------
void KBearTransferViewItem::slotPause() {
	if( m_transfer->job() && ! m_transfer->isPaused() ) {
		connectionManager->pauseJob( m_transfer->job() );
	}
}
//-----------------------------------------------
void KBearTransferViewItem::slotResume() {
	if( m_transfer->job() && m_transfer->isPaused() ) {
		connectionManager->resumeJob( m_transfer->job() );
	}
}
//-----------------------------------------------
void KBearTransferViewItem::slotPaused( KIO::Job* job ) {
	if( job != m_transfer->job() )
		return;
	kdDebug()<<"KBearTransferViewItem PAUSED"<<endl;
	m_transfer->pause( true );
	transferTypeItem->setText( 1 , i18n("Paused") );
}
//-----------------------------------------------
void KBearTransferViewItem::slotResumed( KIO::Job* job ) {
	if( job != m_transfer->job() )
		return;
	kdDebug()<<"KBearTransferViewItem RESUMED"<<endl;
	m_transfer->pause( false );
}
//-----------------------------------------------
void KBearTransferViewItem::slotStart() {
	emit start( m_transfer );
}
//-----------------------------------------------
void KBearTransferViewItem::stop() {
	if( m_transfer->job() )
		slotStop();
	else // the transfer isn't started
		slotFinished();
}
//-----------------------------------------------
void KBearTransferViewItem::slotStop() {
	m_transferViewPage->disconnect( this );
	if(  m_transfer->job() ) {
		m_transfer->job()->kill( false );
	}
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbeartransferviewitem.moc"
#endif

