/***************************************************************************
                          connection.h  -  description
                             -------------------
    begin                : sn jan 6 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONNECTION_H
#define CONNECTION_H

//////////////////////////////////////////////////////
// Qt specific includes
#include <qstring.h>
#include <qmap.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <kdatastream.h>
#include <kio/global.h>

class KURL;
/**
  *@author Bjrn Sahlstrm
  */

class Connection {
public: 
	/** */
	Connection();
	/** */
	Connection( const KURL& url );
	~Connection();
	/** @returns whether the connection is for local file system*/
	bool isLocal() const { return m_host==QString::null;}
	/** @returns connection settings as @ref KIO::MetaData */
	KIO::MetaData metaData() const;
	/** Set meta data information */
	void setMetaData( const KIO::MetaData&);
	/** @returns Label for the site */
	QString label() const { return m_label;}
	/** @returns Name of the server to connect to, like ftp.kde.org */
	QString protocol() const { return m_protocol;}
	/** @returns Name of the server to connect to, like ftp.kde.org */
	QString host() const { return m_host;}
	/** @returns port number to connect to*/
	int port() const { return m_port;}
	/** @returns whether to use anonymous login or not*/
	bool anonym() const { return m_anonym;}
	/** @returns whether to use passivemode (PASV)or not*/
	bool passiveMode() const { return m_passiveMode;}
	/** @returns whether to use passivemode (EPSV)or not*/
	bool extendedPassiveMode() const { return m_extendedPassiveMode;}
	/** @returns whether to use binary/ASCII mode ( binary=true, ASCII=false)*/
	bool binaryMode() const { return m_binaryMode;}
	/** @returns whether to use log or not*/
	bool enableLog() const { return m_enableLog;}
	/** @returns whether to use *.part extensions or not*/
	bool markPartial() const { return m_markPartial;}
	/** @returns whether to use 'list -a' or not*/
	bool listA() const { return m_listA;}
	/** @returns users login name for the remote host */
	QString user() const { return m_user;}
	/** @returns users password for the remote host */
	QString pass() const { return m_pass;}
	/** @returns Initial path for the remote host */
	QString remotePath() const { return (m_remotePath==""?QString("/"):m_remotePath);}
	/** @returns Initial path for the localhost */
	QString localPath() const { return (m_localPath==""?QString("/"):m_localPath);}
	/** @returns if auto reconnect is tuned on or off */
	bool autoReconnect() const { return m_autoReconnect; }
	/** @returns if transfers should be queued */
	bool queue() const { return m_queue; }
	/** @returns if a single connection is to be used for filesys operations */
	bool singleConnection() const { return m_singleConnection; }
	/** @returns number of seconds before trying to reconnect */
	int reconnectTime() const { return m_reconnectTime; }
	/** @returns number of times to try to reconnect */
	int numOfRetries() const { return m_numOfRetries; }
	/** Set label for the site */
	void setLabel( const QString& label ) { m_label = label; }
	/** Set name of the server to connect to, like ftp.kde.org */
	void setProtocol( const QString& protocol ) { m_protocol = protocol; }
	/** Set name of the server to connect to, like ftp.kde.org */
	void setHost( const QString& host ) { m_host = host; }
	/** Set port number to connect to*/
	void setPort( const int& port ) { m_port = port; }
	/** Set whether to use anonymous login or not*/
	void setAnonym( bool anonym ) { m_anonym = anonym; }
	/** Set whether to use passivemode (PASV) or not*/
	void setPassiveMode( bool passive ) { m_passiveMode = passive; }
	/** Set whether to use passivemode (EPSV) or not*/
	void setExtendedPassiveMode( bool e_passive ) { m_extendedPassiveMode = e_passive; }
	/** Set whether to use passivemode or not*/
	void setBinaryMode( bool binary ) { m_binaryMode = binary; }
	/** Set whether to enable log or not*/
	void setEnableLog( bool log ) { m_enableLog = log; }
	/** Set whether to use *.part extensions or not*/
	void setMarkPartial( bool part ) { m_markPartial = part; }
	/** Set whether to use *.part extensions or not*/
	void setListA( bool a ) { m_listA = a; }
	/** Set users login name for the remote host */
	void setUser( const QString& user ) { m_user = user; }
	/** Set users password for the remote host */
	void setPass( const QString& pass ) { m_pass = pass; }
	/** Set initial path for the remote host */
	void setRemotePath( const QString& remotePath ) { m_remotePath = (remotePath==""?QString("/"):remotePath); }
	/** Set initial path for the localhost */
	void setLocalPath( const QString& localPath ) { m_localPath = (localPath==""?QString("/"):localPath); }
	/** Set if autmatic reconnect on failure */
	void setAutoReconnect( bool r ) { m_autoReconnect = r; }
	/** Set number of seconds before tying to reconnect */
	void setReconnectTime( int t ) { m_reconnectTime = t; }
	/** Set number of times to try to reconnect */
	void setNumOfRetries( int n ) { m_numOfRetries = n; }
	/** Set if transfers should be queued or not, default is not queue */
	void setQueue( bool q ) { m_queue = q; }
	/** Set if a single connection is to be used for filesys operations, default is false */
	void setSingleConnection( bool s ) { m_singleConnection = s; }
	/** Set if a single connection is to be used for filesys operations, default is false */
	void setFileSysEncoding(  const QString& e ) { m_fileSysEncoding = e; }
	QString fileSysEncoding() const { return m_fileSysEncoding; }

	void setFireWallType( unsigned int t ) { m_firewallType = t; }
	void setFireWallHost( const QString& h ) { m_firewallHost = h; }
	void setFireWallPort( unsigned int p ) { m_firewallPort = p; }
	void setFireWallUser( const QString& u ) { m_firewallUser = u; }
	void setFireWallPass( const QString& p ) { m_firewallPass = p; }
	void setFireWallAccount( const QString& a ) { m_firewallAccount = a; }
	void setFireWallMacro( const QString& m ) { m_firewallMacro = m; }
	unsigned int fireWallType() const { return m_firewallType; }
	QString fireWallHost() const { return m_firewallHost; }
	unsigned int fireWallPort() const { return m_firewallPort; }
	QString fireWallUser() const { return m_firewallUser; }
	QString fireWallPass() const { return m_firewallPass; }
	QString fireWallAccount() const { return m_firewallAccount; }
	QString fireWallMacro() const { return m_firewallMacro; }
	/** @returns an URL representing the contents of the connection */
	KURL url() const;
	/** */
	void insert( QDataStream& out ) const;
	/** */
	void extract( QDataStream& in );
protected:
	QString m_label;
	QString m_protocol;
	QString m_host;
	int m_port;
	bool m_anonym;
	bool m_passiveMode;
	bool m_extendedPassiveMode;
	bool m_binaryMode;
	bool m_enableLog;
	bool m_markPartial;
	bool m_listA;
	bool m_queue;
	bool m_singleConnection;
	bool m_autoReconnect;
	int m_reconnectTime;
	int m_numOfRetries;
	QString m_user;
	QString m_pass;
	QString m_remotePath;
	QString m_localPath;
	unsigned int m_firewallType;
	QString m_firewallHost;
	unsigned int m_firewallPort;
	QString m_firewallUser;
	QString m_firewallPass;
	QString m_firewallAccount;
	QString m_firewallMacro;
	QString m_fileSysEncoding;
};
///////////////////////////////////////////////////////
inline QDataStream& operator << ( QDataStream& s, const Connection& con ) {
	con.insert( s );
	return s;
}
///////////////////////////////////////////////////////
inline QDataStream& operator >> ( QDataStream& s, Connection& con ) {
	con.extract( s );
	return s;
}
///////////////////////////////////////////////////////
#endif
