/***************************************************************************
                         referencecounted.h  -  description
                             -------------------
    begin                : Mo Apr 18 2005
    copyright            : (C) 2005 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
                                                                          
    This program is free software; you can redistribute it and/or modify  
    it under the terms of the GNU General Public License as published by  
    the Free Software Foundation; either version 2 of the License, or     
    (at your option) any later version.                                   
                                                                          
 ***************************************************************************/

#ifndef REFERENCE_COUNTED_H
#define REFERENCE_COUNTED_H

/** 
 * A class to make objects reference counted.
 * Most likely you will want to subclass this class.
 * @see TCanvasItem for an example.
 * 
 * Whenever you get a reference to a ReferenceCounted
 * object to an addRef() and when ever you do not need
 * the object anymore, do a remRef(). If refCount() is 0
 * you can savely delete the object.
 */
class ReferenceCounted {
    public:
        ReferenceCounted();

	inline unsigned int addRef() 
	    {
		return ++m_counter;
	    }

	inline unsigned int remRef()
	    {
		return --m_counter;
	    }

	inline unsigned int refCount() const
	    {
		return m_counter;
	    }
	
    private:
	unsigned int m_counter;

};

#endif // REFERENCE_COUNTED_H


