/***************************************************************************
                          appearance.cpp  -  description
                             -------------------
    begin                : Tue Feb 8 2000
    copyright            : (C) 2000 by mark dufour
    email                : m.dufour@twi.tudelft.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "appearance.h"
#include "globals.h"
#include "browser.h"

#include <qmenubar.h>
#include <qtoolbar.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qstring.h>

appearance::appearance(QWidget *parent, const char *name) : QWidget(parent,name){
	initDialog();
}

void appearance::connect()
{
	QObject::connect( CBuppertoolbar, SIGNAL( toggled( bool ) ), this, SLOT( maintoolbarswitch( bool ) ) );
	QObject::connect( CBstatusbar, SIGNAL( toggled( bool ) ), this, SLOT( statusbarswitch( bool ) ) );
	QObject::connect( LBavailable, SIGNAL( selected( const QString & ) ), this, SLOT( availableSelected( const QString & ) ) ); 
	QObject::connect( Bselect, SIGNAL( clicked() ), this, SLOT( selectButton() ) );
	QObject::connect( Bclear, SIGNAL( clicked() ), this, SLOT( clearButton() ) );
	QObject::connect( Bdelete, SIGNAL( clicked() ), this, SLOT( deleteButton() ) );
	QObject::connect( Bdefault, SIGNAL( clicked() ), this, SLOT( defaultButton() ) );
	QObject::connect( Biconsetdir, SIGNAL( clicked() ), this, SLOT( iconsetButton() ) );
	QObject::connect( LEiconsetdir, SIGNAL( textChanged( const QString & ) ), this, SLOT( iconsetdirChanged( const QString & ) ) );
	QObject::connect( CBenableediting, SIGNAL( toggled( bool ) ), this, SLOT( enableeditingswitch( bool ) ) ); 
}

appearance::~appearance(){
}

void appearance::iconsetButton()
{
	QString dir = QFileDialog::getExistingDirectory();

	if( dir != QString::null )
		LEiconsetdir->setText( dir );
}

void appearance::iconsetdirChanged( const QString & )
{
	//browser->renewToolbar(); // keertje terug zetten
}

void appearance::selectButton()
{
	if( LBavailable->currentItem() != -1 )
			availableSelected( LBavailable->currentText() );
}

void appearance::clearButton()
{
	LBselected->clear();
	browser->renewToolbar();
}

void appearance::deleteButton()
{
	if( LBselected->currentItem() != -1 )
	{
		LBselected->removeItem( LBselected->currentItem() );
		browser->renewToolbar();
	}	
}

void appearance::defaultButton()
{
	defaultSelected();
	browser->renewToolbar();
}

void appearance::defaultSelected()
{
	LBselected->clear();

  	LBselected->insertItem("back");
  	LBselected->insertItem("information");
  	LBselected->insertItem("chat");
  	LBselected->insertItem("links");
  	LBselected->insertItem("new search");
}

void appearance::availableSelected( const QString &item )
{
	if( LBselected->findItem( item ) )
	{
		LBselected->removeItem( LBselected->index( LBselected->findItem( item ) ) );
		LBselected->insertItem( item, LBselected->currentItem()+1 );
	}
	else
		LBselected->insertItem( item );

	browser->renewToolbar();
}

void appearance::maintoolbarswitch( bool on )
{
	if( on )
		browser->toolBar->show();
	else
		browser->toolBar->hide();
}

void appearance::enableeditingswitch( bool on )
{
	if( on )
		browser->editmenuid = browser->mainmenu->insertItem( "&Editing Options", browser->editmenu, CTRL+Key_E, 3 );
	else
		browser->mainmenu->removeItem( browser->editmenuid ); 
}

void appearance::statusbarswitch( bool on )
{
	if( on )
		browser->statusBar()->show();
	else
		browser->statusBar()->hide();
}
