/***************************************************************************
 *   Copyright (C) 2003 by Hans Karlsson                                   *
 *   karlsson.h@home.se                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef TEXTLABEL_H
#define TEXTLABEL_H
#include "meter.h"
#include <qstring.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qfont.h>
#include <qfontmetrics.h>
#include <qstringlist.h>
#include <qrect.h>
class TextLabel : public Meter
{
public:
    TextLabel( int x,int y,int w,int h);
    TextLabel();
    ~TextLabel();

    void setValue( QString );
    void setValue( int );
    void setFontSize( int );
    void setColor( int, int, int );
    void setBGColor( int, int, int);
    void setFont( QString );
    void setAlignment( QString );
    void setFixedPitch( bool );
    void setShadow( int );
    void mUpdate( QPainter * );

    int getFontSize() const;
    QColor getColor() const;
    QColor getBGColor() const;
    QString getFont() const;
    QString getAlignment() const;
    bool getFixedPitch() const;
    int getShadow() const;


private:
    int alignment;
    int clip;
    QStringList value;
    QFont font;
    QColor color;
    QColor bgColor;
    int lineHeight;
    int shadow;

}
;
#endif // TEXTLABEL_H
