#ifndef __FISHES_H__
#define __FISHES_H__

#include <qobject.h>
#include <qstring.h>
#include <qcanvas.h>
#include <qstring.h>
#include <qdict.h>

class QTimer;

class fishSprite : public QObject, public QCanvasSprite
{
  Q_OBJECT
public:
    fishSprite( QCanvas *, QCanvasPixmapArray *, QObject * = 0, const char * = 0 );
    ~fishSprite();
    
    void init();
    void advance( int phase );
    
protected slots:
    void slotResized();
    void slotSettingsChanged();
    
private:
    enum fishDirections { Right = 0, Left};
    
    // Position
    int posx;
    int fishEndPosX;
    int posy;
    int posyupdown;
    
    
    // Direction
    fishDirections fishDirection;
    
    // Animation Frame
    int fishFrame; // pos in animate fish pic
    int fishFramesDir; // // how much animated pics i have in a direction
    int fishFrameAdd;
    int fishFrameDelay; // how much a same frame will be showed

    // well well!
    int mid_imagex;
    int mid_imagey;
    
};

class kfishManager : public QObject
{
    Q_OBJECT
public:
    kfishManager( QObject * = 0, const char * = 0);
    ~kfishManager();

signals:
    void signalResized();
    
public slots:
    void slotSettingsChanged();

private:
    void addFish(QString);
    
    void loadFishes();
    void showFishes();

    QCanvasPixmapArray *getFishAnimation(QString, int, int, int num, Qt::Orientation, int);
    
    int oldScale;
    int OldNumFishes;
    
    QDict<QCanvasPixmapArray> m_listFishesAnim;
    QDict<fishSprite> m_fish;
};

// swordfish 55 110
#endif
