/***************************************************************************
                          lexer.ll  -  description                              
                             -------------------                                         
    begin                : Wed Jul 5 2000                                           
    copyright            : (C) 2000 by Terk Zsolt                         
    email                : tz124@hszk.bme.hu                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

%{
  #include <stdlib.h>
  #include "qstring.h"
  #include "krule.h"
  #include "qcstring.h"
  #include "parser.h"

  #include "kexecutor.h"
  #define fromUtf8 fromLocal8Bit

  QCString qcs, qcs2, delimiter;
  char bound;
  int quoteType;

  QString * execute(QCString);

%}

%option noyywrap yylineno
%x Q1 Q2 Q3 Q4Start Q4 Q5 Q6Start Q6 Q7Start Q7a Q7b Q7c Q8Start Q8a Q8b
first     [a-zA-Z_]
next      [a-zA-Z_0-9]

%%
[ \t\n]           ;
#.*$              ;
{first}{next}*    { yylval.string=new QString(yytext); return WORD; }
[+\-][0-9]+       |
[0-9]+            { yylval.integer=atoi(yytext); return INT; }

  /* Q1: "quoted" string */
\"              { qcs=QCString(); BEGIN(Q1); }
<Q1>
{
  \\n         qcs+='\n';
  \\t         qcs+='\t';
  \\\n        ;
  \\.         qcs+=yytext[1];
  [^\\\n$"]+  {
                int i;
                for (i=0; i<yyleng; i++)
                  qcs+=yytext[i];
              }
  \$[a-zA-Z]+ { qcs+=getenv(yytext+1); }
  \$\{[^}]+\}  { yytext[yyleng-1]=0; qcs+=getenv(yytext+2); yytext[yyleng-1]='}'; }
  "\""        { BEGIN(INITIAL); yylval.string=new QString(QString::fromUtf8(qcs)); return STRING; }
  \n          ;
  .           qcs+=yytext[0];
}

  /* Q2: 'qouted' exact string */
"'"           { BEGIN(Q2); qcs=QCString(); }
<Q2>[^']      { qcs+=yytext[0]; }
<Q2>"'"       { BEGIN(INITIAL); yylval.string=new QString(qcs); return STRING; }

  /* Q3: `backquoted` string */
"`"           { BEGIN(Q3); qcs=QCString(); }
<Q3>
{
  \\n         qcs+='\n';
  \\t         qcs+='\t';
  \\\n        ;
  \\.         qcs+=yytext[1];
  [^\\\n`]+   {
                int i;
                for (i=0; i<yyleng; i++)
                  qcs+=yytext[i];
              }
  "`"         { BEGIN(INITIAL); yylval.string=execute(qcs); return STRING; }
  \n          ;
}

  /* Q4: q#specially# quoted exact strings */
(q|x)/[^;\- \n\ta-zA-Z0-9_] { BEGIN(Q4Start); quoteType=(yytext[0]=='x')?1:0; qcs=QCString(); }
<Q4Start>.    { bound=yytext[0]; BEGIN(Q4); }
<Q4>.         {
                if (yytext[0]==bound)
                {
                  BEGIN(INITIAL);
                  if (quoteType)
                    yylval.string=execute(qcs);
                  else
                    yylval.string=new QString(qcs);
                  return STRING;
                }
                else qcs+=yytext[0];
              }
<Q4>\n        ;

  /* Q5: <<END - like quotations */
"<<".*$       { BEGIN(Q5); delimiter=QCString(yytext+2); qcs=QCString(); }
<Q5>^.*$      {
                QCString line(yytext);
                if (line==delimiter) { BEGIN(INITIAL); yylval.string=new QString(qcs); return STRING; }
                if (qcs.isEmpty()) qcs=QCString(yytext);
                else qcs+=QCString("\n")+QCString(yytext);
              }
<Q5>\n        ;

  /* Q6: regular expressions like m/fo+/ */
m/[^;\- \n\ta-zA-Z0-9_] { BEGIN(Q6Start); qcs=QCString(); }
<Q6Start>.    { bound=yytext[0]; BEGIN(Q6); }
<Q6>\\t				qcs+='\t';
<Q6>\\n				qcs+='\n';
<Q6>.         {
                if (yytext[0]==bound)
                {
                  BEGIN(INITIAL);
                  yylval.string=new QString(qcs);
                  return REGEX;
                }
                else qcs+=yytext[0];
              }
<Q6>\n				;

  /* Q7: substitution expressions */
s/[^;\- \n\ta-zA-Z0-9_] { BEGIN(Q7Start); qcs=QCString(); qcs2=QCString();}
<Q7Start>.    { bound=yytext[0]; BEGIN(Q7a); }
<Q7a>\\t			qcs+='\t';
<Q7a>\\n			qcs+='\n';
<Q7a>.        {
                if (yytext[0]==bound)
                  BEGIN(Q7b);
                else qcs+=yytext[0];
              }
<Q7a>\n				;
<Q7b>\\t				qcs2+='\t';
<Q7b>\\n				qcs2+='\n';
<Q7b>.         {
                if (yytext[0]==bound)
                {
                  BEGIN(Q7c);
                }
                else qcs2+=yytext[0];
              }
<Q7b>\n				;
<Q7c>.|\n     {
                if (yytext[0]=='g') yylval.strings[2]=(QString *)1;
                else { yylval.strings[2]=NULL; unput(yytext[0]); }
                BEGIN(INITIAL);
                yylval.strings[0]=new QString(qcs);
                yylval.strings[1]=new QString(qcs2);
                return SUBSTITUTION;
              }


  /* Q8: regular translations */
(tr|y)/[^;\- \n\ta-zA-Z0-9_] { BEGIN(Q8Start); qcs=QCString(); qcs2=QCString();}
<Q8Start>.    { bound=yytext[0]; BEGIN(Q8a); }
<Q8a>\\t			qcs+='\t';
<Q8a>\\n			qcs+='\n';
<Q8a>.        {
                if (yytext[0]==bound)
                  BEGIN(Q8b);
                else qcs+=yytext[0];
              }
<Q8a>\n				;
<Q8b>\\t      qcs2+='\t';
<Q8b>\\n      qcs2+='\n';
<Q8b>.         {
                if (yytext[0]==bound)
                {
                  BEGIN(INITIAL);
                  yylval.strings[0]=new QString(qcs);
                  yylval.strings[1]=new QString(qcs2);
                  return TRANSLATION;
                }
                else qcs2+=yytext[0];
              }
<Q8b>\n				;

"->"|"::="        return ARROW;
"<-"              return LARROW;
".."              return TO;

":tabbed"         { yylval.integer=KRule::Tabbed; return MODIFIER; }
":framed"         { yylval.integer=KRule::Framed; return MODIFIER; }
":horizontal"     { yylval.integer=KRule::Horizontal; return MODIFIER; }
":wizard"         { yylval.integer=KRule::Wizard; return MODIFIER; }
":dialog"         { yylval.integer=KRule::Dialog; return MODIFIER; }
":reverse"        { yylval.integer=KRule::Reverse; return MODIFIER; }
":noeval"         { yylval.integer=KRule::NoEval; return MODIFIER; }
":double"         { yylval.integer=KRule::Double; return MODIFIER; }
":beside"         { yylval.integer=KRule::Beside; return MODIFIER; }
":tree"           { yylval.integer=KRule::Tree; return MODIFIER; }
":detailed"       { yylval.integer=KRule::Detailed; return MODIFIER; }

"@integer"        { yylval.integer=0; return SPECIAL; }
"@string"         { yylval.integer=1; return SPECIAL; }
"@list"           { yylval.integer=2; return SPECIAL; }
"@float"          { yylval.integer=3; return SPECIAL; }
"@button"         { yylval.integer=4; return SPECIAL; }
"@regexp"         { yylval.integer=5; return SPECIAL; }
"@infile"         { yylval.integer=6; return SPECIAL; }
"@outfile"        { yylval.integer=7; return SPECIAL; }
"@directory"      { yylval.integer=8; return SPECIAL; }
"@combo"          { yylval.integer=9; return SPECIAL; }
"@container"      { yylval.integer=10;return SPECIAL; }
"@close"          { yylval.integer=11;return SPECIAL; }
"@action"         { yylval.integer=12;return SPECIAL; }
"@edit"           { yylval.integer=13;return SPECIAL; }
"@combow"         { yylval.integer=14;return SPECIAL; }
"@exec"           { yylval.integer=15; return SPECIAL; }
"@echo"           { yylval.integer=16; return SPECIAL; }
"@icon"           { yylval.integer=17; return SPECIAL; }
"@text"           { yylval.integer=18; return SPECIAL; }
"@execclose"      { yylval.integer=19; return SPECIAL; }
"@execbuffer"     { yylval.integer=20; return SPECIAL; }
"@dump"           { yylval.integer=21; return SPECIAL; }
"@preview"        { yylval.integer=22; return SPECIAL; }
"@size"           { yylval.integer=23; return SPECIAL; }
"@password"       { yylval.integer=24; return SPECIAL; }
"@fork"           { yylval.integer=25; return SPECIAL; }
"@fill"           { yylval.integer=26; return SPECIAL; }
"@multicol"       { yylval.integer=27; return SPECIAL; }
 /* "@"{first}{next}* { yylval.integer=1; return SPECIAL; }  @string for everything else */

.                 return yytext[0];
<*>\n             ;
%%


QString * execute(QCString commandline)
{
  KExecutor x;
  return new QString(x.execute(commandline));
}

