/***************************************************************************
    copyright            : (C) 2001, 2006 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#ifndef DESCSOURCEPAGE_H
#define DESCSOURCEPAGE_H

#include "kdescsourcepage.h"
#include "wizardpagebase.h"

#include <qpixmap.h>
#include <qwmatrix.h>

/**
 * @short
 * Image description page.
 * 
 * @author Andras Mantia <amantia@kdewebdev.org>
 */
class DescSourcePage: public KDescSourcePage, public WizardPageBase  {
Q_OBJECT
public:
  DescSourcePage(QWidget *parent = 0, const char *name = 0);
  void invokeHelp();
  bool processPage();
  void setupPage();

private slots:
    
  /**
   * Detect settings changing and raise the correct detailed page.
   */
  void slotDescSettingsChanged();
  /**
   * Load the descriptions from a text file.
   */
  void slotLoadDescriptions();
  
  /**
   * Go to the next image.
   */
  void slotNextDescription();
  
  /**
   * Go to the previous image.
   */
  void slotPreviousDescription();

private:
  /** Currently the DescPosition-th image is described. */
  uint DescPosition;
  QPixmap pm;
  QPixmap pm_scale;
  QWMatrix matrix;
  double dx;

};

#endif
