/*
 * dvbsection.h
 *
 * Copyright (C) 2003-2006 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef DVBSECTION_H
#define DVBSECTION_H

#include <linux/dvb/dmx.h>

#include <qptrlist.h>
#include <qobject.h>
#include <qthread.h>
#include <qdatetime.h>



class DVBsection : public QObject, public QThread
{
	Q_OBJECT

public:

	DVBsection( bool *ok, int anum, int tnum, const QString &charset="ISO8859-1" );
	DVBsection( bool *ok, int anum, int tnum, bool openDemux, const QString &charset="ISO8859-1" );
	~DVBsection();

protected:

	virtual void run() {}
	QString langDesc( unsigned char* buf );
	void stopFilter();
	void closeFilter();
	bool setFilter( int pid, int tid, int timeout=5000, bool checkcrc=true );
	bool openFilter( int pid, int tid, int timeout=5000, bool checkcrc=true );
	unsigned int getBits( unsigned char *b, int offbits, int nbits );
	QString getText( unsigned char *buf, int length );
	QTime getTime( unsigned char *buf );
	QDate getDate( unsigned char *buf );
	QDateTime getDateTime( unsigned char *buf );

	int fdDemux;
	int indexChannels;
	bool isRunning;
	QString demuxer;
	int adapter;
	int tuner;
	QCString defaultCharset;
};

#endif /* DVBSECTION_H */
