/*
 * Java core library component.
 *
 * Copyright (c) 2002
 *      Dalibor Topic <robilad@yahoo.com>.  All rights reserved.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file.
 */

package org.kaffe.util.locale;

import java.util.ListResourceBundle;

public class Language_fr extends ListResourceBundle {
    public Object [] [] getContents() {
	return contents;
    }

    private Object [] [] contents = {
	{ "ab", "abkhaze" }, // ABKHAZIAN
	{ "aa", "afar" }, // AFAR
	{ "af", "afrikaans" }, // AFRIKAANS
	{ "sq", "albanais" }, // ALBANIAN
	{ "am", "amharique" }, // AMHARIC
	{ "ar", "arabe" }, // ARABIC
	{ "hy", "arm\u00E9nien" }, // ARMENIAN
	{ "as", "assamais" }, // ASSAMESE
	{ "ae", "avestique" }, // AVESTAN
	{ "ay", "aymara" }, // AYMARA
	{ "az", "az\u00E9ri" }, // AZERBAIJANI

	{ "ba", "bachkir" }, // BASHKIR
	{ "eu", "basque" }, // BASQUE
	{ "be", "bi\u00E9lorusse" }, // BELARUSIAN
	{ "bn", "bengali" }, // BENGALI
	{ "bh", "bihari" }, // BIHARI
	{ "bi", "bichlamar" }, // BISLAMA
	{ "nb", "norv\u00E9gien bokm\u00E5l" }, // NORWEGIAN BOKMAL
	{ "bs", "bosniaque" }, // BOSNIAN
	{ "br", "breton" }, // BRETON
	{ "bg", "bulgare" }, // BULGARIAN
	{ "my", "birman" }, // BURMESE

	{ "es", "espagnol" }, // CASTILLIAN; SPANISH
	{ "ca", "catalan" }, // CATALAN
	{ "ch", "chamorro" }, // CHAMORRO
	{ "ce", "tch\u00E9tch\u00E8ne" }, // CHECHEN
	{ "ny", "nyanja" }, // CHEWA; CHICHEWA; NYANJA
	{ "zh", "chinois" }, // CHINESE
	{ "za", "zhuang" }, // CHUANG; ZHUANG
	{ "cu", "slavon d'\u00E9glise" }, // CHURCH SLAVIC; SLAVONIC; CHURCH SLAVONIC; OLD BULGARIAN; OLD CHURCH SLAVONIC
	{ "cv", "tchouvache" }, // CHUVASH
	{ "kw", "cornique" }, // CORNISH
	{ "co", "corse" }, // CORSICAN
	{ "hr", "croate" }, // CROATIAN
	{ "cs", "tch\u00E8que" }, // CZECH

	{ "da", "danois" }, // DANISH
	{ "nl", "n\u00E9ederlandais" }, // DUTCH
	{ "dz", "dzongkha" }, // DZONGKHA

	{ "en", "anglais" }, // ENGLISH
	{ "eo", "esp\u00E9ranto" }, // ESPERANTO
	{ "et", "estonien" }, // ESTONIAN

	{ "fo", "f\u00E9ro\u00EFen" }, // FAROESE
	{ "fj", "fidjien" }, // FIJIAN
	{ "fi", "finnois" }, // FINNISH
	{ "fr", "fran\u00E7ais" }, // FRENCH
	{ "fy", "frison" }, // FRISIAN

	{ "gd", "ga\u00E9lique" }, // GAELIC; SCOTTISH GAELIC
	{ "gl", "galicien" }, // GALLEGAN
	{ "ka", "g\u00E9orgien" }, // GEORGIAN
	{ "de", "allemand" }, // GERMAN
	{ "ki", "kikuyu" }, // GIKUYU; KIKUYU
	{ "el", "grec moderne" }, // MODERN GREEK
	{ "gn", "guarani" }, // GUARANI
	{ "gu", "goudjrati" }, // GUJARATI

	{ "ha", "haoussa" }, // HAUSA
	{ "he", "h\u00E9breu" }, // HEBREW
	{ "iw", "h\u00E9breu" }, // HEBREW (WITHDRAWN)
	{ "hz", "herero" }, // HERERO
	{ "hi", "hindi" }, // HINDI
	{ "ho", "hiri motu" }, // HIRI MOTU
	{ "hu", "hongrois" }, // HUNGARIAN

	{ "is", "islandais" }, // ICELANDIC
	{ "io", "ido" }, // IDO
	{ "id", "indon\u00E9sien" }, // INDONESIAN
	{ "in", "indon\u00E9sien" }, // INDONESIAN (WITHDRAWN)
	{ "ia", "interlingua" }, // INTERLINGUA
	{ "ie", "interlingue" }, // INTERLINGUE
	{ "iu", "inuktitut" }, // INUKTITUT
	{ "ik", "inupiaq" }, // INUPIAQ
	{ "ga", "irlandais" }, // IRISH
	{ "it", "italien" }, // ITALIAN

	{ "ja", "japonais" }, // JAPANESE
	{ "jv", "javanais" }, // JAVANESE

	{ "kl", "groenlandais" }, // KALAALLISUT
	{ "kn", "kannada" }, // KANNADA
	{ "ks", "kashmiri" }, // KASHMIRI
	{ "kk", "kazakh" }, // KAZAKH
	{ "km", "khmer" }, // KHMER
	{ "rw", "rwanda" }, // KINYARWANDA
	{ "ky", "kirghize" }, // KIRGHIZ
	{ "kv", "komi" }, // KOMI
	{ "ko", "cor\u00E9en" }, // KOREAN
	{ "kj", "kuanyama" }, // KUANYAMA; KWANYAMA
	{ "ku", "kurde" }, // KURDISH

	{ "lo", "lao" }, // LAO
	{ "la", "latin" }, // LATIN
	{ "lv", "letton" }, // LATVIAN
	{ "lb", "luxembourgeois" }, // LETZEBURGESCH; LUXEMBOURGISH
	{ "li", "limbourgeois" }, // LIMBURGAN; LIMBURGER; LIMBURGISH
	{ "ln", "lingala" }, // LINGALA
	{ "lt", "lituanien" }, // LITHUANIAN

	{ "mk", "mac\u00E9donien" }, // MACEDONIAN
	{ "mg", "malgache" }, // MALAGASY
	{ "ms", "malais" }, // MALAY
	{ "ml", "malayalam" }, // MALAYALAM
	{ "mt", "maltais" }, // MALTESE
	{ "gv", "manx" }, // MANX
	{ "mi", "maori" }, // MAORI
	{ "mr", "marathe" }, // MARATHI
	{ "mh", "marshall" }, // MARSHALLESE
	{ "mo", "moldave" }, // MOLDAVIAN
	{ "mn", "mongol" }, // MONGOLIAN

	{ "na", "nauruan" }, // NAURU
	{ "nv", "navaho" }, // NAVAHO; NAVAJO
	{ "nd", "nd\u00E9b\u00E9l\u00E9 du Nord" }, // NORTH NDEBELE
	{ "nr", "nd\u00E9b\u00E9l\u00E9 du Sud" }, // SOUTH NDEBELE
	{ "ng", "ndonga" }, // NDONGA
	{ "ne", "n\u00E9palais" }, // NEPALI
	{ "se", "sami du Nord" }, // NORTHERN SAMI
	{ "no", "norv\u00E9gien" }, // NORWEGIAN
	{ "nn", "norv\u00E9gien nynorsk" }, // NORWEGIAN NYNORSK

	{ "oc", "occitan" }, // OCCITAN; PROVENCAL
	{ "or", "oriya" }, // ORIYA
	{ "om", "galla" }, // OROMO
	{ "os", "oss\u00E8te" }, // OSSETIAN; OSSETIC

	{ "pi", "pali" }, // PALI
	{ "pa", "pendjabi" }, // PANJABI
	{ "fa", "persan" }, // PERSIAN
	{ "pl", "polonais" }, // POLISH
	{ "pt", "portugais" }, // PORTUGUESE
	{ "ps", "pachto" }, // PUSHTO

	{ "qu", "quechua" }, // QUECHUA

	{ "rm", "rh\u00E9to-roman" }, // RAETO-ROMANCE
	{ "ro", "roumain" }, // ROMANIAN
	{ "rn", "rundi" }, // RUNDI
	{ "ru", "russe" }, // RUSSIAN

	{ "sm", "samoan" }, // SAMOAN
	{ "sg", "sango" }, // SANGO
	{ "sa", "sanskrit" }, // SANSKRIT
	{ "sc", "sarde" }, // SARDINIAN
	{ "sr", "serbe" }, // SERBIAN
	{ "sh", "serbo-croate" }, // SERBO-CROATIAN (WITHDRAWN)
	{ "sn", "shona" }, // SHONA
	{ "ii", "yi de Sichuan" }, // SICHUAN YI
	{ "sd", "sindhi" }, // SINDHI
	{ "si", "singhalais" }, // SINHALESE
	{ "sk", "slovaque" }, // SLOVAK
	{ "sl", "slov\u00E8ne" }, // SLOVENIAN
	{ "so", "somali" }, // SOMALI
	{ "st", "sotho du Sud" }, // SOUTHERN SOTHO
	{ "su", "sundanais" }, // SUNDANESE
	{ "sw", "swahili" }, // SWAHILI
	{ "ss", "swati" }, // SWATI
	{ "sv", "su\u00E9dois" }, // SWEDISH

	{ "tl", "tagalog" }, // TAGALOG
	{ "ty", "tahitien" }, // TAHITIAN
	{ "tg", "tadjik" }, // TAJIK
	{ "ta", "tamoul" }, // TAMIL
	{ "tt", "tatar" }, // TATAR
	{ "te", "t\u00E9lougu" }, // TELUGU
	{ "th", "tha\u00EF" }, // THAI
	{ "bo", "tib\u00E9tain" }, // TIBETAN
	{ "ti", "tigrigna" }, // TIGRINYA
	{ "to", "tongan (\u00CEles Tonga)" }, // TONGA (TONGA ISLANDS)
	{ "ts", "tsonga" }, // TSONGA
	{ "tn", "tswana" }, // TSWANA
	{ "tr", "turc" }, // TURKISH
	{ "tk", "turkm\u00E8ne" }, // TURKMEN
	{ "tw", "twi" }, // TWI

	{ "ug", "Ou\u00EFgour" }, // UIGHUR
	{ "uk", "ukrainien" }, // UKRAINIAN
	{ "ur", "ourdou" }, // URDU
	{ "uz", "ouszbek" }, // UZBEK

	{ "vi", "vietnamien" }, // VIETNAMESE
	{ "vo", "volap\u00FCk" }, // VOLAPUK

	{ "wa", "wallon" }, // WALLOON
	{ "cy", "gallois" }, // WELSH
	{ "wo", "wolof" }, // WOLOF

	{ "xh", "xhosa" }, // XHOSA

	{ "yi", "yiddish" }, // YIDDISH
	{ "ji", "yiddish" }, // YIDDISH (WITHDRAWN)
	{ "yo", "yoruba" }, // YORUBA

	{ "zu", "zoulou" }, // ZULU
    };
}
