// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Implements the molecule object
		\author Tim Shead (tshead@k-3d.com)
		\author Ed Millard (emillard@direcway.com)
*/

#include <k3dsdk/algebra.h>
#include <k3dsdk/bounded.h>
#include <k3dsdk/high_res_timer.h>
#include <k3dsdk/iapplication.h>
#include <k3dsdk/idag.h>
#include <k3dsdk/imaterial.h>
#include <k3dsdk/object.h>
#include <k3dsdk/persistence.h>
#include <k3dsdk/material_collection.h>
#include <k3dsdk/module.h>
#include <k3dsdk/renderman.h>
#include <k3dsdk/transformable.h>
#include <k3dsdk/viewport.h>

#include <sdpgl/sdpgl.h>

#include <boost/scoped_ptr.hpp>

namespace
{

/////////////////////////////////////////////////////////////////////////////
// molecule_implementation

class molecule_implementation :
	public k3d::bounded<k3d::material_collection<k3d::viewport::drawable<k3d::ri::renderable<k3d::transformable<k3d::persistent<k3d::object> > > > > >
{
	typedef k3d::bounded<k3d::material_collection<k3d::viewport::drawable<k3d::ri::renderable<k3d::transformable<k3d::persistent<k3d::object> > > > > > base;

public:
	molecule_implementation(k3d::idocument& Document) :
		base(Document),
		m_draw_style(k3d::init_name("drawStyle") + k3d::init_description("Draw Style [enum]") + k3d::init_value(0) + k3d::init_document(Document))
	{
		enable_serialization(k3d::persistence::proxy(m_draw_style));

		register_property(m_draw_style);
		
		m_position.changed_signal().connect(SigC::slot(*this, &molecule_implementation::async_redraw_all));
		m_orientation.changed_signal().connect(SigC::slot(*this, &molecule_implementation::async_redraw_all));
		m_scale.changed_signal().connect(SigC::slot(*this, &molecule_implementation::async_redraw_all));
	}

	const k3d::bounding_box extents()
	{
		// Fixme, Needs to be extents of all atom children
		return k3d::bounding_box(10, -10, 10, -10, 10, -10);
	}

	void on_viewport_draw(const k3d::viewport::render_state& State)
	{
		/** \todo implement me! */
	}

	void on_viewport_select(const k3d::viewport::render_state& State)
	{
		/** \todo implement me! */
	}

	void on_renderman_render(const k3d::ri::render_state& State)
	{
		/** \todo implement me! */
	}

	k3d::iplugin_factory& factory()
	{
		return get_factory();
	}

	static k3d::iplugin_factory& get_factory()
	{
		static k3d::plugin_factory<
			k3d::document_plugin<molecule_implementation>,
				k3d::interface_list<k3d::itransform_source,
				k3d::interface_list<k3d::itransform_sink > > > factory(
				k3d::uuid(0x45588855, 0x635d46d4, 0xa5aef51d, 0x0c4d019a),
				"Molecule",
				"Molecule primitive",
				"Objects",
				k3d::iplugin_factory::EXPERIMENTAL);

		return factory;
	}

private:
	friend class properties;

	k3d_data_property(int, k3d::immutable_name, k3d::change_signal, k3d::with_undo, k3d::local_storage, k3d::no_constraint) m_draw_style;
};

} // namespace

namespace libk3dchem
{

/////////////////////////////////////////////////////////////////////////////
// molecule_factory

k3d::iplugin_factory& molecule_factory()
{
	return molecule_implementation::get_factory();
}

} // namespace libk3dchem
