#ifndef K3DUI_TUTORIAL_MENU_H
#define K3DUI_TUTORIAL_MENU_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Provides an API for displaying a "Tutorial Menu" dialog which provides a UI for playing tutorial scripts
		\author Tim Shead (tshead@k-3d.com)
*/

// Forward declarations
namespace boost { namespace filesystem { class path; } }

namespace k3d
{

// Forward declarations
class icommand_node;

/// Sets the global path from which tutorials will be displayed
void set_tutorial_path(const boost::filesystem::path& Path);
/// Displays a singleton tutorial menu dialog
void create_tutorial_menu(k3d::icommand_node& Parent);

} // namespace k3d

#endif // K3DUI_TUTORIAL_MENU_H

