// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Implements the k3dControl class, which provides a UI for numeric quantities
		\author Tim Shead (tshead@k-3d.com)
*/

#include "k3dcontrol.h"
#include <k3dsdk/result.h>

/////////////////////////////////////////////////////////////////////////////
// k3dControl

k3dControl::k3dControl(k3d::iunknown* CommandNodeParent, const std::string& CommandNodeName) :
	base(CommandNodeParent, CommandNodeName),
	m_StateRecorder(0)
{
}

k3dControl::~k3dControl()
{
}

bool k3dControl::Attach(k3d::istate_recorder* const StateRecorder, const std::string& StateChangeName)
{
	 // You only get to attach once!
	assert_warning(!m_StateRecorder);

	// Store references ...
	m_StateRecorder = StateRecorder;
	m_StateChangeName = StateChangeName;

	return true;
}
