// K3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Implements implementation private
		\author Tim Shead (tshead@k-3d.com)
*/

#include "iplugin_factory.h"
#include "module_private.h"

namespace k3d
{

namespace detail
{

/////////////////////////////////////////////////////////////////////////////
// plugin_factory

plugin_factory::plugin_factory(const uuid& ClassID, const std::string Name, const std::string ShortDescription, const std::string DefaultCategory, const quality_t Quality) :
	m_class_id(ClassID),
	m_name(Name),
	m_short_description(ShortDescription),
	m_default_category(DefaultCategory),
	m_quality(Quality)
{
}

const uuid& plugin_factory::class_id()
{
	return m_class_id;
}

const std::string plugin_factory::name()
{
	return m_name;
}

const std::string plugin_factory::short_description()
{
	return m_short_description;
}

const std::string plugin_factory::default_category()
{
	return m_default_category;
}

k3d::iplugin_factory::quality_t plugin_factory::quality()
{
	return m_quality;
}

} // namespace detail

} // namespace k3d


