#ifndef K3DSDK_COMPUTED_PROPERTY_H
#define K3DSDK_COMPUTED_PROPERTY_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include "iproperty.h"

namespace k3d
{

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// computed_property

/// Implementation of iproperty that can front for any function object
template<typename data_t, typename functor_t>
class computed_property :
	public iproperty
{
public:
	computed_property(const char* const Name, const char* const Description, functor_t Function) :
		m_name(Name),
		m_description(Description),
		m_function(Function)
	{
	}
	
	~computed_property()
	{
		m_deleted_signal.emit();
	}

	const std::string name()
	{
		return m_name;
	}

	const std::string description()
	{
		return m_description;
	}

	const std::type_info& type()
	{
		return typeid(data_t);
	}

	const boost::any value()
	{
		return boost::any(m_function());
	}

	changed_signal_t& changed_signal()
	{
		return m_changed_signal;
	}
	
	deleted_signal_t& deleted_signal()
	{
		return m_deleted_signal;
	}

private:
	const char* const m_name;
	const char* const m_description;
	functor_t m_function;
	changed_signal_t m_changed_signal;
	deleted_signal_t m_deleted_signal;
};
	
template<class ObjectType, typename ResultType>
class method_call_t
{
public:
	explicit method_call_t(ObjectType& Object, ResultType (ObjectType::*Method)()) :
		m_object(Object),
		m_method(Method)
	{
	}

	ResultType operator()()
	{
		return (m_object.*m_method)();
	}

private:
	ObjectType& m_object;
	ResultType (ObjectType::*m_method)();
};

template<typename ObjectType, typename ResultType>
method_call_t<ObjectType, ResultType> method_call(ObjectType& Object, ResultType (ObjectType::*Method)())
{
	return method_call_t<ObjectType, ResultType>(Object, Method);
}

} // namespace k3d

#endif // K3DSDK_COMPUTED_PROPERTY_H

