# $Id: Result.pm,v 1.1.1.1 2005/06/28 04:25:15 kuro Exp $
package Juman::Result;
require 5.004_04; # For base pragma.
use Juman::Morpheme;
use strict;
use base qw/ Juman::MList /;
use vars qw/ %DEFAULT /;

=head1 NAME

Juman::Result - ǲϷ̥֥ in Juman

=head1 SYNOPSIS

  $result = new Juman::Result( "...\n...\nEOS\n" );

=head1 DESCRIPTION

Juman ˤǲϤη̤ݻ륪֥ȡ

=head1 CONSTRUCTOR

=over 4

=item new ( RESULT )

Juman νϤԤñ̤ȤƳǼ줿ꥹȤФե RESULT
ȤƸƤӽФȡηǲϷ̤ɽ֥Ȥ롥

=item new ( OPTIONS )

ʲγĥץꤷƥ󥹥ȥ饯ƤӽФ

=over 4

=item result => RESULT

Juman νʸ󡤤ޤϡʸԤñ̤ȤƳǼ줿ꥹ
Фե󥹤ꤹ롥

=item pattern => STRING

Ϸ̤ü뤿Υѥꤹ롥

=item mclass => NAME

ǥ֥Ȥꤹ롥̵ξϡC<Juman::Morpheme> 
롥

=cut
%DEFAULT = ( pattern => '^EOS$',
	     mclass  => 'Juman::Morpheme' );

sub new {
    my $class = shift;

    my( %opt ) = %DEFAULT;
    if( @_ == 1 ){
	$opt{result} = shift;
    } else {
	while( @_ ){
	    my $key = shift;
	    my $val = shift;
	    $key =~ s/\A-+//;
	    $opt{lc($key)} = $val;
	}
    }
    my $result  = $opt{result};
    my $pattern = $opt{pattern};
    my $mclass  = $opt{mclass};
    return undef unless( $result and $pattern and $mclass );

    # ʸľܻꤵ줿
    $result = [ map( "$_\n", split( /\n/, $result ) ) ] unless ref $result;

    my $this = {};
    bless $this, $class;

    my( $str );
    while ( defined( $str = shift @$result ) ) {
	if ( $str =~ m!$pattern! and @$result == 0 ) {
	    last;
	} elsif ( $str =~ m!\A\@ \@ \@ [^\@]! ){
	    # @פΤߤʤ̤
	    $this->push_mrph( $mclass->new( $str, scalar($this->mrph) ) );
	} elsif ( $str =~ s!\A\@ !! ) {
	    # @פƬˤƱ
	    ( $this->mrph )[-1]->push_doukei( $mclass->new( $str, scalar($this->mrph) ) );
	} else {
	    $this->push_mrph( $mclass->new( $str, scalar($this->mrph) ) );
	}
    }
    $this->set_readonly();

    $this;
}

=back

=head1 METHODS

ܥ֥Ȥϡ󥪥֥ C<Juman::MList> Ѿ褦
Ƥ롥äơ󥪥֥ȤФͭʰʲΥ
åɤѲǽǤ롥

=over 4

=item mrph

=item spec

=back

=head1 SEE ALSO

=over 4

=item *

L<Juman::Morpheme>

=item *

L<Juman::MList>

=back

=head1 AUTHOR

=over 4

=item
ڲ ̭ <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=cut

# ߴݤĤΥ᥽å
sub all {
    my( $this ) = @_;
    $this->spec();
}

1;
__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
