# $Id: Encode.pm,v 1.1.1.1 2005/06/28 04:25:15 kuro Exp $
package Juman::Encode;
require 5.008;
use strict;
use base qw/ Exporter /;
our @EXPORT_OK = qw/ encode decode set_encoding /;

=head1 NAME

Juman::Encode - character encoding functions

=head1 DESCRIPTION

Perl-5.8.x ʸɤȤ Unicode ѤƤ롥Τᡤ
ܸ EUC ȤäƤץȤϤԤ䡤ܸ EUC ǵ
줿ǡ򻲾ȤˤϡŪ encode/decode Ԥɬ
롥

Υ饤֥ǤϡΤδؿƤ롥

=head1 FUNCTIONS

=over 4

=item $octets = encode ( $string )

ʸC<encoding> ץ饰ޤǻꤵƤʸɤ encode ơ
Х롥

=cut
sub encode {
    my( $string ) = @_;
    if( $string and ${^ENCODING} ){
	${^ENCODING}->encode( $string );
    } else {
	$string;
    }
}

=item $string = decode ( $octets )

ХC<encoding> ץ饰ޤǻꤵƤʸɤ decode 
ơʸ롥

=cut
sub decode {
    my( $string ) = @_;
    if( $string and ${^ENCODING} ){
	${^ENCODING}->decode( $string );
    } else {
	$string;
    }
}

=item set_encoding ( $handle )

ꤵ줿եϥɥȤ̿ˡC<encoding> ץ饰ޤǻꤵ
ʸɤȤ褦ꤹ롥

=cut
sub set_encoding {
    my( $fh ) = @_;
    if( ${^ENCODING} ){
	my $name = ${^ENCODING}->name();
	binmode( $fh, ":encoding($name)" );
    }
}

1;

=back

δؿ⡤C<encoding> ץ饰ޤꤵƤʤˤϡ⤷
ʤ

=head1 MEMO

Υ饤֥ϡѿ C<${^ENCODING}> 򻲾ȤɬפΤؿ
򡤰ˤޤȤ뤿ƳʤʤСѿ C<${^ENCODING}> 
򻲾Ȥ褦Ȥ륳ɤϡJperl-5.005 Ǥ syntax error Ȥʤ뤿
롥

  Sample Script:
    use English qw/ $PERL_VERSION /;
    if( $PERL_VERSION > 5.008 ){
        ${^ENCODING}->encode( ... );
    }

  Error Message:
    syntax error at sample.perl line 3, near "{^"

=head1 SEE ALSO

=over 4

=item *

L<encoding>

=item *

L<Encode>

=back

=head1 AUTHOR

=over 4

=item
ڲ ̭ <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=cut

__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
