from core import Component, implements
from api import ITodoExtension

class TodoProcessor(Component):
#    _keys = ["advance","alarm_library","color",
#            "icon_number","alarm","font","urgency",
#            "custom_alarm","repeat_type",
#            "repeat_end_date","repeat_frequency",
#            "repeat_on","repeat_start_of_week",
#            "links"]
# only these are implemented so far:
    _keys = ["urgency"]
    _blankfield = list("[00-99:99 sI@A.... OOOO@N@@@@ ]")

    implements(ITodoExtension)

    def fields(self):
        return self._keys

    def handles_field(self, field):
        return field in self._keys + ['note']

    def get_field(self, todo, item):
        #print "Getting field!", todo, item
        if item in self._keys:
            if hasattr(self, "_get_%s" % item):
                return getattr(self, "_get_%s" % item)(todo)
            raise NotImplemented("Unable to get %s yet." % item)
        elif item == "note":
            if self._has_dbfield(todo):
                return todo['note'][31:]
            else:
                return todo['note']

    def set_field(self, todo, item, value):
        #print "Setting field!", todo, item, value
        if item in self._keys:
            if hasattr(self, "_set_%s" % item):
                return getattr(self, "_set_%s" % item)(todo, value)
            raise NotImplementedError("Unable to set %s yet." % item)
        elif item == "note":
            # argh, we'll have to find a way to get this to AVOID using the filters
            # otherwise we have a infinite recursion problem.
            todo['note'] = "".join(self._read_dbfield(todo)) + value

    def _get_urgency(self, todo):
        dbfield = self._read_dbfield(todo)
        if dbfield[29] in ('A','B','C','D'):
            return dbfield[29]
        else:
            return None
        
    def _set_urgency(self, todo, urgency):
        dbfield = self._read_dbfield(todo)
        if urgency is None:
            self._write_dbfield(todo, self._blankfield)
        elif urgency.upper() in ('A','B','C','D'):
            dbfield[29] = urgency.upper()
            self._write_dbfield(todo, dbfield)
        else:
            raise ValueError("Urgency must be A, B, C, D or None")

    def _has_dbfield(self, todo):
        note = todo['note']
        if len(note) >= 31 and note[0] == "[" and note[30] == "]":
            return True
        else:
            return False
    
    def _read_dbfield(self, todo):
        if self._has_dbfield(todo):
            return list(todo['note'][0:31])
        else:
            return self._blankfield

    def _write_dbfield(self, todo, dbfield):
        todo['note'] = "".join(dbfield) + self.get_field(todo, 'note')

