#ifndef _WIN32COMPAT_H
#define _WIN32COMPAT_H

#ifdef WIN32
 /* Not visible to non-WIN32 platforms */
 #include <stdio.h>
 #ifdef HAVE_WINDOWS_H
  #include <windows.h>
 #endif

 #ifdef HAVE_SYS_TIMEB_H
  #include <sys/timeb.h>
 #endif

 extern int my_strcasecmp(const char *a, const char *b);
 #define strcasecmp my_strcasecmp
 extern int my_snprintf(char *str, size_t size, const char *format, ...);
 #define snprintf my_snprintf

 struct win32_pthread_mutex {
	CRITICAL_SECTION csMutex;
 };

 struct win32_pthread_mutexattr {
	int type;
 };

 struct win32_pthread_cond {
	HANDLE hMutex;
	HANDLE hWake;
	DWORD thread_one;
	int thread_one_set;	/* Can remove if tid=0 is invalid */
	int generation_wakeone;
	int generation_wakeall;
	int waiters;
 };

 struct win32_pthread_condattr {
	int dummy;
 };

 #define PTHREAD_MUTEX_T(n)			struct win32_pthread_mutex n
 #define PTHREAD_MUTEX_DESTROY(v)		win32_pthread_mutex_destroy(& v)
 #define PTHREAD_MUTEX_INIT(v, a, n, r)		*(r) = win32_pthread_mutex_init(& v, a)
 #define PTHREAD_MUTEX_LOCK(v)			win32_pthread_mutex_lock(& v)
 #define PTHREAD_MUTEX_UNLOCK(v)		win32_pthread_mutex_unlock(& v)

 #define PTHREAD_MUTEXATTR_T(n)			struct win32_pthread_mutexattr n
 #define PTHREAD_MUTEXATTR_DESTROY(a)		win32_pthread_mutexattr_destroy(& a)
 #define PTHREAD_MUTEXATTR_INIT(a)		win32_pthread_mutexattr_init(& a)
 #define PTHREAD_MUTEXATTR_SETTYPE(a, t)	win32_pthread_mutexattr_settype(& a, t)

 #define PTHREAD_COND_T(n)			struct win32_pthread_cond n
 #define PTHREAD_COND_DESTROY(v)		win32_pthread_cond_destroy(& v)
 #define PTHREAD_COND_INIT(v, a)		win32_pthread_cond_init(& v, a)
 #define PTHREAD_COND_BROADCAST(v)		win32_pthread_cond_broadcast(& v)
 #define PTHREAD_COND_TIMEDWAIT(v, m, w)	win32_pthread_cond_timedwait(& v, & m, w)

 extern int win32_pthread_mutex_destroy(struct win32_pthread_mutex *m);
 extern int win32_pthread_mutex_init(struct win32_pthread_mutex *m, struct win32_pthread_mutexattr *a);
 extern int win32_pthread_mutex_lock(struct win32_pthread_mutex *m);
 extern int win32_pthread_mutex_unlock(struct win32_pthread_mutex *m);

 extern int win32_pthread_mutexattr_destroy(struct win32_pthread_mutexattr *a);
 extern int win32_pthread_mutexattr_init(struct win32_pthread_mutexattr *a);
 extern int win32_pthread_mutexattr_settype(struct win32_pthread_mutexattr *a, int t);
 extern int win32_pthread_mutexattr_gettype(struct win32_pthread_mutexattr *a, int *tp);

 extern int win32_pthread_cond_destroy(struct win32_pthread_cond *v);
 extern int win32_pthread_cond_init(struct win32_pthread_cond *v, struct win32_pthread_condattr *a);
 extern int win32_pthread_cond_broadcast(struct win32_pthread_cond *v);
 extern int win32_pthread_cond_timedwait(struct win32_pthread_cond *v, struct win32_pthread_mutex *m, const struct timeb *w);
#endif /* WIN32*/

#endif /* _WIN32COMPAT_H */

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
