#ifndef UI_FILE_H__
#define UI_FILE_H__

#include <hash.h>
#include <method.h>
#include <jmpthread.h>
#include <cls.h>

extern void dump_classes (hashtab* classes, FILE *f);
extern void dump_methods (hashtab* methods, FILE* f);
extern void dump_threads (hashtab* threads, FILE* f);

/** dump a method to the given file */
extern void dump_method_row (method* m, FILE* f);

/** dump a thread to the given file */
extern void dump_jmpthread_row (jmpthread* t, FILE* f);

/** Dump a class to the given file. */
extern void dump_class_row (cls* c, FILE* f);

extern void dumptimer_tick(void);

extern void dump_clean (void);

extern int dump_data (char* dumpdir, hashtab* classes, hashtab* methods, hashtab* threads);


#endif /* UI_FILE_H__ */

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
