#include <gtk/gtk.h>
#include <string.h>
#include <filtermenu.h>
#include <filter.h>
#include <cls.h>
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <jmp-config.h>
#include <gtkutils.h>

static void set_filter_recursive (GtkObject *object) {
    char* str;
    GtkMenuItem* gmi = GTK_MENU_ITEM (object);
    GtkLabel* label = GTK_LABEL (GTK_BIN (gmi)->child);
    gtk_label_get(label, &str);
    filter_set_filter (FILTER_MATCH_RECURSIVE, str);
}

static void set_filter_class (GtkObject *object) {
    char* str;
    GtkMenuItem* gmi = GTK_MENU_ITEM (object);
    GtkLabel* label = GTK_LABEL (GTK_BIN (gmi)->child);
    gtk_label_get(label, &str);
    filter_set_filter (FILTER_MATCH_CLASS, str);
}

static void set_filter_no_filter (GtkObject *object) {
    filter_clear_filters ();
}

GtkWidget* build_filter_menu (cls* c) {
    GtkWidget* filters;
    char* i;

    /* Quick select of filter.... */
    filters = gtk_menu_new ();
    
    /* No filter. */
    add_menu_item (filters, _("No filter"), (GCallback)set_filter_no_filter);

    /* A recursive filter for each package type. */
    i = c->name;
    while ((i = strchr (i, '.'))) {
	*i = '\0';
	add_menu_item (filters, c->name, (GCallback)set_filter_recursive);
	*i = '.';
	i++;
    }
    
    /* And a filter for the selected class. */
    add_menu_item (filters, c->name, (GCallback)set_filter_class);
    
    gtk_widget_show_all (filters);
    return filters;
}

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
