/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.serialize;

import java.io.IOException;
import java.util.Properties;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.serialize.CharInfo;
import org.apache.xalan.serialize.ElemDesc;
import org.apache.xalan.serialize.Encodings;
import org.apache.xalan.serialize.SerializerToXML;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.Trie;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SerializerToHTML
extends SerializerToXML {
    private BoolStack m_isRawStack = new BoolStack();
    private boolean m_inBlockElem = false;
    protected static CharInfo m_htmlcharInfo = new CharInfo(CharInfo.HTML_ENTITIES_RESOURCE);
    static Trie m_elementFlags = new Trie();
    private static ElemDesc m_dummy;
    private boolean m_specialEscapeURLs = true;
    private String m_currentElementName = null;

    static {
        m_elementFlags.put("BASEFONT", new ElemDesc(2));
        m_elementFlags.put("FRAME", new ElemDesc(10));
        m_elementFlags.put("FRAMESET", new ElemDesc(8));
        m_elementFlags.put("NOFRAMES", new ElemDesc(8));
        m_elementFlags.put("ISINDEX", new ElemDesc(10));
        m_elementFlags.put("APPLET", new ElemDesc(0x200000));
        m_elementFlags.put("CENTER", new ElemDesc(8));
        m_elementFlags.put("DIR", new ElemDesc(8));
        m_elementFlags.put("MENU", new ElemDesc(8));
        m_elementFlags.put("TT", new ElemDesc(4096));
        m_elementFlags.put("I", new ElemDesc(4096));
        m_elementFlags.put("B", new ElemDesc(4096));
        m_elementFlags.put("BIG", new ElemDesc(4096));
        m_elementFlags.put("SMALL", new ElemDesc(4096));
        m_elementFlags.put("EM", new ElemDesc(8192));
        m_elementFlags.put("STRONG", new ElemDesc(8192));
        m_elementFlags.put("DFN", new ElemDesc(8192));
        m_elementFlags.put("CODE", new ElemDesc(8192));
        m_elementFlags.put("SAMP", new ElemDesc(8192));
        m_elementFlags.put("KBD", new ElemDesc(8192));
        m_elementFlags.put("VAR", new ElemDesc(8192));
        m_elementFlags.put("CITE", new ElemDesc(8192));
        m_elementFlags.put("ABBR", new ElemDesc(8192));
        m_elementFlags.put("ACRONYM", new ElemDesc(8192));
        m_elementFlags.put("SUP", new ElemDesc(98304));
        m_elementFlags.put("SUB", new ElemDesc(98304));
        m_elementFlags.put("SPAN", new ElemDesc(98304));
        m_elementFlags.put("BDO", new ElemDesc(98304));
        m_elementFlags.put("BR", new ElemDesc(98314));
        m_elementFlags.put("BODY", new ElemDesc(8));
        m_elementFlags.put("ADDRESS", new ElemDesc(56));
        m_elementFlags.put("DIV", new ElemDesc(56));
        m_elementFlags.put("A", new ElemDesc(32768));
        m_elementFlags.put("MAP", new ElemDesc(98312));
        m_elementFlags.put("AREA", new ElemDesc(10));
        m_elementFlags.put("LINK", new ElemDesc(131082));
        m_elementFlags.put("IMG", new ElemDesc(2195458));
        m_elementFlags.put("OBJECT", new ElemDesc(2326528));
        m_elementFlags.put("PARAM", new ElemDesc(2));
        m_elementFlags.put("HR", new ElemDesc(58));
        m_elementFlags.put("P", new ElemDesc(56));
        m_elementFlags.put("H1", new ElemDesc(262152));
        m_elementFlags.put("H2", new ElemDesc(262152));
        m_elementFlags.put("H3", new ElemDesc(262152));
        m_elementFlags.put("H4", new ElemDesc(262152));
        m_elementFlags.put("H5", new ElemDesc(262152));
        m_elementFlags.put("H6", new ElemDesc(262152));
        m_elementFlags.put("PRE", new ElemDesc(0x100008));
        m_elementFlags.put("Q", new ElemDesc(98304));
        m_elementFlags.put("BLOCKQUOTE", new ElemDesc(56));
        m_elementFlags.put("INS", new ElemDesc(0));
        m_elementFlags.put("DEL", new ElemDesc(0));
        m_elementFlags.put("DL", new ElemDesc(56));
        m_elementFlags.put("DT", new ElemDesc(8));
        m_elementFlags.put("DD", new ElemDesc(8));
        m_elementFlags.put("OL", new ElemDesc(524296));
        m_elementFlags.put("UL", new ElemDesc(524296));
        m_elementFlags.put("LI", new ElemDesc(8));
        m_elementFlags.put("FORM", new ElemDesc(8));
        m_elementFlags.put("LABEL", new ElemDesc(16384));
        m_elementFlags.put("INPUT", new ElemDesc(18434));
        m_elementFlags.put("SELECT", new ElemDesc(18432));
        m_elementFlags.put("OPTGROUP", new ElemDesc(0));
        m_elementFlags.put("OPTION", new ElemDesc(0));
        m_elementFlags.put("TEXTAREA", new ElemDesc(18432));
        m_elementFlags.put("FIELDSET", new ElemDesc(24));
        m_elementFlags.put("LEGEND", new ElemDesc(0));
        m_elementFlags.put("BUTTON", new ElemDesc(18432));
        m_elementFlags.put("TABLE", new ElemDesc(56));
        m_elementFlags.put("CAPTION", new ElemDesc(8));
        m_elementFlags.put("THEAD", new ElemDesc(8));
        m_elementFlags.put("TFOOT", new ElemDesc(8));
        m_elementFlags.put("TBODY", new ElemDesc(8));
        m_elementFlags.put("COLGROUP", new ElemDesc(8));
        m_elementFlags.put("COL", new ElemDesc(10));
        m_elementFlags.put("TR", new ElemDesc(8));
        m_elementFlags.put("TH", new ElemDesc(0));
        m_elementFlags.put("TD", new ElemDesc(0));
        m_elementFlags.put("HEAD", new ElemDesc(0x400008));
        m_elementFlags.put("TITLE", new ElemDesc(8));
        m_elementFlags.put("BASE", new ElemDesc(10));
        m_elementFlags.put("META", new ElemDesc(131082));
        m_elementFlags.put("STYLE", new ElemDesc(131336));
        m_elementFlags.put("SCRIPT", new ElemDesc(229632));
        m_elementFlags.put("NOSCRIPT", new ElemDesc(56));
        m_elementFlags.put("HTML", new ElemDesc(8));
        m_elementFlags.put("FONT", new ElemDesc(4096));
        m_elementFlags.put("S", new ElemDesc(4096));
        m_elementFlags.put("STRIKE", new ElemDesc(4096));
        m_elementFlags.put("U", new ElemDesc(4096));
        m_elementFlags.put("NOBR", new ElemDesc(4096));
        ElemDesc elemDesc = (ElemDesc)m_elementFlags.get("BASE");
        elemDesc.setAttr("HREF", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("BLOCKQUOTE");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("Q");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("INS");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("DEL");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("A");
        elemDesc.setAttr("HREF", 2);
        elemDesc.setAttr("NAME", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("INPUT");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("CHECKED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("SELECT");
        elemDesc.setAttr("READONLY", 4);
        elemDesc.setAttr("MULTIPLE", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OPTGROUP");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OPTION");
        elemDesc.setAttr("SELECTED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("TEXTAREA");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("BUTTON");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("SCRIPT");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("FOR", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("IMG");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("OBJECT");
        elemDesc.setAttr("CLASSID", 2);
        elemDesc.setAttr("CODEBASE", 2);
        elemDesc.setAttr("DATA", 2);
        elemDesc.setAttr("ARCHIVE", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("FORM");
        elemDesc.setAttr("ACTION", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("HEAD");
        elemDesc.setAttr("PROFILE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("FRAME");
        elemDesc.setAttr("SRC", 2);
        m_dummy = new ElemDesc(8);
    }

    public SerializerToHTML() {
        this.m_charInfo = m_htmlcharInfo;
    }

    public void cdata(char[] ch, int start, int length) throws SAXException {
        if (this.m_currentElementName != null && (this.m_currentElementName.equalsIgnoreCase("SCRIPT") || this.m_currentElementName.equalsIgnoreCase("STYLE"))) {
            try {
                this.writeParentTagEnd();
                this.m_ispreserve = true;
                if (this.shouldIndent()) {
                    this.indent(this.m_currentIndent);
                }
                this.writeNormalizedChars(ch, start, length, true);
            }
            catch (IOException ioe) {
                throw new SAXException(XSLMessages.createXPATHMessage(66, null), ioe);
            }
        } else {
            super.cdata(ch, start, length);
        }
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        if (this.m_isRawStack.peekOrFalse()) {
            try {
                this.writeParentTagEnd();
                this.m_ispreserve = true;
                if (this.shouldIndent()) {
                    this.indent(this.m_currentIndent);
                }
                this.writeNormalizedChars(chars, start, length, false);
                return;
            }
            catch (IOException ioe) {
                throw new SAXException(XSLMessages.createXPATHMessage(66, null), ioe);
            }
        }
        super.characters(chars, start, length);
    }

    private int copyEntityIntoBuf(String s, int pos) throws SAXException {
        int l = s.length();
        this.accum('&');
        int i = 0;
        while (i < l) {
            this.accum(s.charAt(i));
            ++i;
        }
        this.accum(';');
        return pos;
    }

    public void endElement(String namespaceURI, String localName, String name) throws SAXException {
        if (namespaceURI != null && namespaceURI.length() > 0) {
            super.endElement(namespaceURI, localName, name);
            return;
        }
        this.m_currentIndent -= this.m_indentAmount;
        boolean hasChildNodes = this.childNodesWereAdded();
        this.m_isRawStack.pop();
        ElemDesc elemDesc = this.getElemDesc(name);
        boolean isBlockElement = elemDesc.is(8);
        boolean shouldIndent = false;
        if (this.m_ispreserve) {
            this.m_ispreserve = false;
        } else if (this.m_doIndent && (!this.m_inBlockElem || isBlockElement)) {
            this.m_startNewLine = true;
            shouldIndent = true;
        }
        this.m_inBlockElem = isBlockElement ^ true;
        if (hasChildNodes) {
            if (shouldIndent) {
                this.indent(this.m_currentIndent);
            }
            this.accum("</");
            this.accum(name);
            this.accum('>');
            this.m_currentElementName = name;
        } else if (!elemDesc.is(2)) {
            this.accum('>');
            this.accum('<');
            this.accum('/');
            this.accum(name);
            this.accum('>');
        } else {
            this.accum('>');
        }
        if (elemDesc.is(0x200000)) {
            this.m_ispreserve = true;
        }
        if (hasChildNodes && !this.m_preserves.isEmpty()) {
            this.m_preserves.pop();
        }
        this.m_isprevtext = false;
        this.m_cdataSectionStates.pop();
    }

    public void entityReference(String name) throws SAXException {
        this.accum("&");
        this.accum(name);
        this.accum(";");
    }

    ElemDesc getElemDesc(String name) {
        Object obj;
        if (name != null && (obj = m_elementFlags.get(name)) != null) {
            return (ElemDesc)obj;
        }
        return m_dummy;
    }

    public boolean getSpecialEscapeURLs() {
        return this.m_specialEscapeURLs;
    }

    private boolean isASCIIDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private String makeHHString(int i) {
        String s = Integer.toHexString(i).toUpperCase();
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }

    protected void processAttribute(String name, ElemDesc elemDesc, String value) throws SAXException {
        this.accum(' ');
        if ((value.length() == 0 || value.equalsIgnoreCase(name)) && elemDesc.isAttrFlagSet(name, 4)) {
            this.accum(name);
        } else {
            this.accum(name);
            this.accum('=');
            this.accum('\"');
            if (elemDesc.isAttrFlagSet(name, 2)) {
                this.writeAttrURI(value, this.m_specialEscapeURLs);
            } else {
                this.writeAttrString(value, this.m_encoding);
            }
            this.accum('\"');
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (target.equals("javax.xml.transform.disable-output-escaping")) {
            this.startNonEscaping();
        } else if (target.equals("javax.xml.transform.enable-output-escaping")) {
            this.endNonEscaping();
        } else {
            this.writeParentTagEnd();
            if (this.shouldIndent()) {
                this.indent(this.m_currentIndent);
            }
            this.accum("<?" + target);
            if (data.length() > 0 && !Character.isSpaceChar(data.charAt(0))) {
                this.accum(" ");
            }
            this.accum(String.valueOf(data) + ">");
            if (this.m_elemStack.isEmpty()) {
                this.outputLineSep();
            }
            this.m_startNewLine = true;
        }
    }

    public void setOutputFormat(Properties format) {
        this.m_specialEscapeURLs = OutputProperties.getBooleanProperty(OutputProperties.S_USE_URL_ESCAPING, format);
        super.setOutputFormat(format);
    }

    public void setSpecialEscapeURLs(boolean bool) {
        this.m_specialEscapeURLs = bool;
    }

    public void startDocument() throws SAXException {
        this.m_needToOutputDocTypeDecl = true;
        this.m_startNewLine = false;
        this.m_shouldNotWriteXMLHeader = true;
        if (this.m_needToOutputDocTypeDecl && (this.m_doctypeSystem != null || this.m_doctypePublic != null)) {
            this.accum("<!DOCTYPE HTML");
            if (this.m_doctypePublic != null) {
                this.accum(" PUBLIC \"");
                this.accum(this.m_doctypePublic);
                this.accum("\"");
            }
            if (this.m_doctypeSystem != null) {
                if (this.m_doctypePublic == null) {
                    this.accum(" SYSTEM \"");
                } else {
                    this.accum(" \"");
                }
                this.accum(this.m_doctypeSystem);
                this.accum("\"");
            }
            this.accum(">");
            this.accum(this.m_lineSep);
        }
        this.m_needToOutputDocTypeDecl = false;
    }

    public void startElement(String namespaceURI, String localName, String name, Attributes atts) throws SAXException {
        if (namespaceURI != null && namespaceURI.length() > 0) {
            super.startElement(namespaceURI, localName, name, atts);
            return;
        }
        boolean savedDoIndent = this.m_doIndent;
        this.writeParentTagEnd();
        this.pushState(namespaceURI, localName, this.m_cdataSectionNames, this.m_cdataSectionStates);
        ElemDesc elemDesc = this.getElemDesc(name);
        boolean isBlockElement = elemDesc.is(8);
        boolean isHeadElement = elemDesc.is(0x400000);
        if (this.m_ispreserve) {
            this.m_ispreserve = false;
        } else if (this.m_doIndent && this.m_currentElementName != null && (!this.m_inBlockElem || isBlockElement)) {
            this.m_startNewLine = true;
            this.indent(this.m_currentIndent);
        }
        this.m_inBlockElem = isBlockElement ^ true;
        this.m_isRawStack.push(elemDesc.is(256));
        this.m_currentElementName = name;
        this.accum('<');
        this.accum(name);
        int nAttrs = atts.getLength();
        int i = 0;
        while (i < nAttrs) {
            this.processAttribute(atts.getQName(i), elemDesc, atts.getValue(i));
            ++i;
        }
        this.openElementForChildren();
        this.m_currentIndent += this.m_indentAmount;
        this.m_isprevtext = false;
        this.m_doIndent = savedDoIndent;
        if (isHeadElement) {
            this.writeParentTagEnd();
            if (this.m_doIndent) {
                this.indent(this.m_currentIndent);
            }
            this.accum("<META http-equiv=\"Content-Type\" content=\"text/html; charset=");
            String encoding = Encodings.getMimeEncoding(this.m_encoding);
            this.accum(encoding);
            this.accum('\"');
            this.accum('>');
        }
    }

    public void writeAttrString(String string, String encoding) throws SAXException {
        char[] chars = string.toCharArray();
        int strLen = chars.length;
        int i = 0;
        while (i < strLen) {
            char ch = chars[i];
            if (ch < this.m_maxCharacter && !this.m_charInfo.isSpecial(ch)) {
                this.accum(ch);
            } else if (ch == '<' || ch == '>') {
                this.accum(ch);
            } else if (ch == '&' && i + 1 < strLen && chars[i + 1] == '{') {
                this.accum(ch);
            } else {
                int pos = this.accumDefaultEntity(ch, i, chars, strLen, false);
                if (i != pos) {
                    i = pos - 1;
                } else {
                    String entityName;
                    if (SerializerToXML.isUTF16Surrogate(ch)) {
                        try {
                            i = this.writeUTF16Surrogate(ch, chars, i, strLen);
                        }
                        catch (IOException ioe) {
                            throw new SAXException(ioe);
                        }
                    }
                    if ((entityName = this.m_charInfo.getEntityNameForChar(ch)) != null) {
                        this.accum('&');
                        this.accum(entityName);
                        this.accum(';');
                    } else if (ch < this.m_maxCharacter) {
                        this.accum(ch);
                    } else if (ch < this.m_maxCharacter) {
                        this.accum(ch);
                    } else {
                        this.accum("&#");
                        this.accum(Integer.toString(ch));
                        this.accum(';');
                    }
                }
            }
            ++i;
        }
    }

    public void writeAttrURI(String string, boolean doURLEscaping) throws SAXException {
        char[] stringArray = string.toCharArray();
        int len = stringArray.length;
        int i = 0;
        while (i < len) {
            char ch = stringArray[i];
            if (ch < '!' || ch > '~') {
                if (doURLEscaping) {
                    int high;
                    if (ch <= '\u007f') {
                        this.accum('%');
                        this.accum(this.makeHHString(ch));
                    } else if (ch <= '\u07ff') {
                        high = ch >> 6 | 0xC0;
                        int low = ch & 0x3F | 0x80;
                        this.accum('%');
                        this.accum(this.makeHHString(high));
                        this.accum('%');
                        this.accum(this.makeHHString(low));
                    } else if (SerializerToXML.isUTF16Surrogate(ch)) {
                        int highSurrogate = ch & 0x3FF;
                        int wwww = (highSurrogate & 0x3C0) >> 6;
                        int uuuuu = wwww + 1;
                        int zzzz = (highSurrogate & 0x3C) >> 2;
                        int yyyyyy = (highSurrogate & 3) << 4 & 0x30;
                        ch = stringArray[++i];
                        int lowSurrogate = ch & 0x3FF;
                        int xxxxxx = lowSurrogate & 0x3F;
                        int byte1 = 0xF0 | uuuuu >> 2;
                        int byte2 = 0x80 | (uuuuu & 3) << 4 & 0x30 | zzzz;
                        int byte3 = 0x80 | (yyyyyy |= (lowSurrogate & 0x3C0) >> 6);
                        int byte4 = 0x80 | xxxxxx;
                        this.accum('%');
                        this.accum(this.makeHHString(byte1));
                        this.accum('%');
                        this.accum(this.makeHHString(byte2));
                        this.accum('%');
                        this.accum(this.makeHHString(byte3));
                        this.accum('%');
                        this.accum(this.makeHHString(byte4));
                    } else {
                        high = ch >> 12 | 0xE0;
                        int middle = (ch & 0xFC0) >> 6 | 0x80;
                        int low = ch & 0x3F | 0x80;
                        this.accum('%');
                        this.accum(this.makeHHString(high));
                        this.accum('%');
                        this.accum(this.makeHHString(middle));
                        this.accum('%');
                        this.accum(this.makeHHString(low));
                    }
                } else if (ch < this.m_maxCharacter) {
                    this.accum(ch);
                } else {
                    this.accum("&#");
                    this.accum(Integer.toString(ch));
                    this.accum(';');
                }
            } else if (ch == '%') {
                if (i + 2 < len && this.isASCIIDigit(stringArray[i + 1]) && this.isASCIIDigit(stringArray[i + 2])) {
                    this.accum(ch);
                } else if (doURLEscaping) {
                    this.accum('%');
                    this.accum(this.makeHHString(ch));
                } else {
                    this.accum(ch);
                }
            } else if (ch == '\"') {
                if (doURLEscaping) {
                    this.accum("%22");
                } else {
                    this.accum("&quot;");
                }
            } else {
                this.accum(ch);
            }
            ++i;
        }
    }
}

