open Core.Std
open Core_extended.Std
open OUnit

let test =
  "extended_float" >:::
    [ "pretty" >:: fun () ->
        List.iter ~f:(fun (f, s) -> string_of_float f @? (s = Float.pretty f))
          [ (0.004, "0");
            (0.0049, "0");
            (0.005, "0.01");
            (0.009, "0.01");
            (0.01,  "0.01");
            (0.10,  "0.1");
            (0.99,  "0.99");
            (0.994, "0.99");
            (0.995, "1");
            (1.0,   "1");
            (1.001, "1");
            (1.006, "1.01");
            (1.01,  "1.01");
            (9.99,  "9.99");
            (9.994, "9.99");
            (9.995, "10");
            (9.996, "10");
            (10.0,  "10");
            (10.1,  "10.1");
            (99.9,  "99.9");
            (99.94, "99.9");
            (99.95, "100");
            (99.96, "100");
            (100.0, "100");
            (100.6, "101");
            (999.0, "999");
            (999.4, "999");
            (999.5, "1000");
            (1000.0, "1000");
            (9999.0, "9999");

            (10_000.0, "10k");
            (12_345.0, "12k3");
            (12_500.0, "12k5");
            (99_999.0, "100k");
            (100_000.0, "100k");
            (999_499.0, "999k");

            (999_500.0, "1m");
            (1_000_000.0, "1m");
            (1_230_000.0, "1m23");
            (999_499_000.0, "999m");
          ]
    ]
