#ifndef _DSP_C
#define _DSP_C

#include <math.h>
#include <string.h>

void
signal_copy_circular ( float *dst , const float *src , int n , int s ) 
{
  memcpy ( dst , src + ( s * sizeof(float) ) , ( n - s ) * sizeof(float) ) ;
  memcpy ( dst + ( ( n - s ) * sizeof(float) ) , src , s * sizeof(float) ) ;
}

void
signal_uninterleave ( float *dst , const float *src , int f , int c ) 
{
  int i , k = 0 ;
  for ( i = 0 ; i < f ; i++ ) {
    int j ;
    for ( j = 0 ; j < c ; j++ ) {
      dst[(j*f)+i] = src[k++] ;
    }
  }
}

inline float 
signal_interpolate ( const float *signal , int signal_n , float index )
{
  int index_i = (int) floorf ( index ) ;
  float index_f = index - (float) index_i ;
  if ( index_i == signal_n - 1 ) {
    return ( signal[index_i] * ( 1.0 - index_f ) ) + ( signal[0] * index_f ) ;
  } else {
    return ( signal[index_i] * ( 1.0 - index_f ) ) + ( signal[index_i+1] * index_f ) ;
  }
}

inline float 
signal_interpolate_safe ( const float *signal , int signal_n , float index )
{
  if ( index < 0 || index >= signal_n ) {
    return 0.0 ;
  }
  return signal_interpolate ( signal , signal_n , index ) ;
}

#endif
