#ifndef _SIGNAL_C
#define _SIGNAL_C

#include <signal.h>
#include <errno.h>
#include <string.h>
#include <pthread.h>

volatile int hangup_received = 0 ;
volatile int interrupt_received = 0 ;

void 
actual_signal_handler ( int s )
{
  switch ( s ) {
  case SIGHUP:
    hangup_received = 1 ; break ;
  case SIGINT:
    interrupt_received = 1 ; break ;
  }
}

void *
signal_management_thread ( void *PTR )
{
  pthread_setcanceltype ( PTHREAD_CANCEL_ASYNCHRONOUS , 0 ) ;
  sigset_t blocked ;  
  sigprocmask ( SIG_SETMASK , 0 , &blocked ) ;
  int s ;
  sigwait ( &blocked , &s ) ;
  if ( s != SIGSEGV ) {
    sigprocmask ( SIG_UNBLOCK , &blocked , 0 ) ;
  }
  actual_signal_handler ( s ) ;
  return NULL ;
}

int
install_signal_handlers ( void )
{
  sigset_t signals ;
  sigemptyset ( &signals ) ;
  sigaddset ( &signals , SIGHUP ) ;
  sigaddset ( &signals , SIGINT ) ;
  sigaddset ( &signals , SIGQUIT ) ;
  sigaddset ( &signals , SIGPIPE ) ;
  sigaddset ( &signals , SIGTERM ) ;
  sigaddset ( &signals , SIGUSR1 ) ;
  sigaddset ( &signals , SIGUSR2 ) ;
  struct sigaction action ;
  action.sa_handler = actual_signal_handler ;
  action.sa_mask = signals ;
  action.sa_flags = SA_RESTART | SA_RESETHAND ;
  int i ;
  for ( i = 1 ; i < 32 ; i++ ) {
    if ( sigismember ( &signals , i ) ) {
      if ( sigaction ( i , &action , 0 ) ) {
	fprintf ( stderr , "sigaction() failed: %d\n" , i ) ;
	return -1 ;
      }
    }
  } 
  if ( pthread_sigmask ( SIG_SETMASK , &signals , 0 ) ) {
    fprintf ( stderr , "pthread_sigmask() failed: %s\n" , strerror ( errno ) ) ;
    return -1;
  }
  pthread_t signal_thread_id ;
  if ( pthread_create ( &signal_thread_id , 0 , signal_management_thread , 0 ) ) {
    fprintf ( stderr , "pthread_create() failed\n" ) ;
    return -1;
  }
  pthread_detach ( signal_thread_id ) ;
  return 0 ;
}

#endif
