#ifndef UTILS_H
#define UTILS_H

/*
 * Copyright (c) Abraham vd Merwe <abz@blio.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	  notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	  notice, this list of conditions and the following disclaimer in the
 *	  documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of other contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <regex.h>
#include <stdlib.h>
#include <stdio.h>

#include "typedefs.h"

/*
 * Search ``string'' for matches to the extended regular expression given in
 * ``pattern'', Returns TRUE if a match for ``pattern'' was found in ``string'',
 * FALSE otherwise.
 */
bool ereg_match (const char *pattern,const char *string);

/*
 * Search ``string'' for matches to the extended regular expression given in
 * ``pattern'', Returns TRUE if a match for ``pattern'' was found in ``string'',
 * FALSE otherwise. If a match was found, the results is stored in ``regs''
 * which is of size ``nregs''. The strings in these registers can be extracted
 * with ereg_extract().
 */
bool ereg (const char *pattern,const char *string,regmatch_t regs[],size_t nregs);

/*
 * Extract a substring from `string'' according to `reg'' and store
 * the result in `substring''.
 */
void ereg_extract (char *substring,const char *string,regmatch_t reg);

/*
 * Trim blanks from left and right sides of given string.
 */
void trim (char *str);

/*
 * Check if the given file is one of the types specified in
 * type, and that we have the necessary permissions to open
 * the file in the mode specified. Mode can be one or more of
 * the following characters: 'r' (readable), 'w' (writable),
 * 'x' (executable), e.g. "rw" would mean that we want read
 * and write permissions. Type can be one or more of the
 * following characters: 'l' (symbolic link), 'r' (regular
 * file), 'd' (directory), 'c' (character device), 'b' (block
 * device), 'f' (fifo), 's' (socket), e.g. "bsf" would mean
 * that we want a block device, socket, or a fifo. Both type
 * and mode must contain at least one character.
 */
bool fperm (const char *filename,const char *type,const char *mode);

/*
 * Read the next line from `fp''. returns NULL if
 * successful, the error string otherwise.
 */
const char *readline (FILE *fp,char *result);

/*
 * Check if any process with name `name'' is running. Returns TRUE, if
 * so, FALSE if not or if some error occurred.
 */
bool alive (const char *name);

#endif
