
/****************************************************************************
 *
 * All portions copyright their respective authors.  All rights reserved.
 *
 * This file is part of IVMan (ivm).
 *
 * This file may be distributed under the terms of the Q Public License
 * as defined by Troll Tech AS of Norway and appearing in the file
 * LICENSE.QPL included in the packaging of this file.
 * 
 * See http://www.troll.no/qpl for QPL licensing information.
 *
 * $Id: dbus_interface.c,v 1.6 2005/11/29 00:42:48 ro_han Exp $
 *****************************************************************************/

#include <dbus/dbus.h>
#include <stdlib.h>

#include "dbus_interface.h"
#include "common.h"

void ivm_check_dbus_error(const DBusError * error)
{
    if (dbus_error_is_set(error)) {
        DEBUG(_("DBus Error! %s: %s"), error->name, error->message);
    }
}
